/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.consumption.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.data.DataModel;
import org.eclipse.jst.ws.axis2.consumption.core.messages.Axis2ConsumptionUIMessages;
import org.eclipse.jst.ws.axis2.consumption.core.utils.WSDLPropertyReader;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class Axis2ProxyWidget
extends SimpleWidgetDataContributor {
    DataModel model;
    IStatus status = Status.OK_STATUS;
    private Button genProxyCheckbox_;
    private Button syncAndAsyncRadioButton;
    private Button syncOnlyRadioButton;
    private Button asyncOnlyRadioButton;
    private Combo databindingTypeCombo;
    private Combo portNameCombo;
    private Combo serviceNameCombo;
    private Text packageText;
    Label label;
    Label fillLabel;
    Label fillLabel1;
    Label fillLabel2;
    Label fillLabel3;
    Label fillLabel4;
    Label fillLabel5;
    Label fillLabel6;
    private Table namespace2packageTable = null;
    private Button generateAllCheckBoxButton;
    private Button testCaseCheckBoxButton;
    private WSDLPropertyReader reader;
    private List serviceQNameList = null;
    Axis2EmitterContext context;

    public Axis2ProxyWidget(DataModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        Composite mainComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        mainComp.setLayout((Layout)layout);
        layout.numColumns = 3;
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.label = new Label(mainComp, 0);
        this.label.setText(Axis2ConsumptionUIMessages.LABEL_SERVICE_NAME_CAPTION);
        this.serviceNameCombo = new Combo(mainComp, 2060);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.serviceNameCombo.setLayoutData((Object)gd);
        this.serviceNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setServiceName(Axis2ProxyWidget.this.serviceNameCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.label = new Label(mainComp, 0);
        this.label.setText(Axis2ConsumptionUIMessages.LABEL_PORTNAME);
        this.portNameCombo = new Combo(mainComp, 2060);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.portNameCombo.setLayoutData((Object)gd);
        this.portNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setPortName(Axis2ProxyWidget.this.portNameCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.label = new Label(mainComp, 0);
        this.label.setText(Axis2ConsumptionUIMessages.LABEL_DATABINDING_CAPTION);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.databindingTypeCombo = new Combo(mainComp, 2060);
        this.databindingTypeCombo.setLayoutData((Object)gd);
        this.fillDatabinderCombo();
        this.databindingTypeCombo.select(0);
        this.databindingTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setDatabindingType(Axis2ProxyWidget.this.databindingTypeCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.label = new Label(mainComp, 0);
        this.label.setText(Axis2ConsumptionUIMessages.LABEL_PACKEGE_NAME);
        this.packageText = new Text(mainComp, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.packageText.setLayoutData((Object)gd);
        this.packageText.setText("");
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2ProxyWidget.this.model.setPackageText(Axis2ProxyWidget.this.packageText.getText());
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fillLabel = new Label(mainComp, 256);
        this.fillLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Text clientlabel = new Text(mainComp, 8);
        clientlabel.setText(Axis2ConsumptionUIMessages.LABEL_CLIENT_SIDE);
        clientlabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.syncAndAsyncRadioButton = new Button(mainComp, 16);
        this.syncAndAsyncRadioButton.setLayoutData((Object)gd);
        this.syncAndAsyncRadioButton.setText(Axis2ConsumptionUIMessages.LABEL_SYNC_AND_ASYNC);
        this.syncAndAsyncRadioButton.setVisible(true);
        this.syncAndAsyncRadioButton.setSelection(!this.context.isAsync() && !this.context.isSync() ? true : this.context.isAsync() && this.context.isSync());
        this.syncAndAsyncRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setSync(!Axis2ProxyWidget.this.syncAndAsyncRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setASync(!Axis2ProxyWidget.this.syncAndAsyncRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.syncOnlyRadioButton = new Button(mainComp, 16);
        this.syncOnlyRadioButton.setLayoutData((Object)gd);
        this.syncOnlyRadioButton.setText(Axis2ConsumptionUIMessages.LABEL_SYNC);
        this.syncOnlyRadioButton.setSelection(this.context.isSync() && !this.context.isAsync());
        this.syncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setSync(Axis2ProxyWidget.this.syncOnlyRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setASync(!Axis2ProxyWidget.this.syncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.asyncOnlyRadioButton = new Button(mainComp, 16);
        this.asyncOnlyRadioButton.setLayoutData((Object)gd);
        this.asyncOnlyRadioButton.setText(Axis2ConsumptionUIMessages.LABEL_ASYNC);
        this.asyncOnlyRadioButton.setSelection(this.context.isAsync() && !this.context.isSync());
        this.asyncOnlyRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setASync(Axis2ProxyWidget.this.asyncOnlyRadioButton.getSelection());
                Axis2ProxyWidget.this.model.setSync(!Axis2ProxyWidget.this.asyncOnlyRadioButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.model.setSync(this.context.isSync());
        this.model.setASync(this.context.isAsync());
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fillLabel = new Label(mainComp, 256);
        this.fillLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.testCaseCheckBoxButton = new Button(mainComp, 32);
        this.testCaseCheckBoxButton.setLayoutData((Object)gd);
        this.testCaseCheckBoxButton.setText(Axis2ConsumptionUIMessages.LABEL_GENERATE_TESTCASE_CAPTION);
        this.testCaseCheckBoxButton.setSelection(this.context.isClientTestCase());
        this.model.setTestCaseCheck(this.context.isClientTestCase());
        this.testCaseCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setTestCaseCheck(Axis2ProxyWidget.this.testCaseCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.generateAllCheckBoxButton = new Button(mainComp, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.generateAllCheckBoxButton.setLayoutData((Object)gd);
        this.generateAllCheckBoxButton.setSelection(this.context.isClientGenerateAll());
        this.generateAllCheckBoxButton.setText(Axis2ConsumptionUIMessages.LABEL_GENERATE_ALL);
        this.generateAllCheckBoxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Axis2ProxyWidget.this.model.setGenerateAllCheck(Axis2ProxyWidget.this.generateAllCheckBoxButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fillLabel3 = new Label(mainComp, 256);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fillLabel4 = new Label(mainComp, 256);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 5;
        this.namespace2packageTable = new Table(mainComp, 2050);
        this.namespace2packageTable.setLinesVisible(true);
        this.namespace2packageTable.setHeaderVisible(true);
        this.namespace2packageTable.setEnabled(true);
        this.namespace2packageTable.setLayoutData((Object)gd);
        this.declareColumn(this.namespace2packageTable, 350, Axis2ConsumptionUIMessages.LABEL_NAMESPACE);
        this.declareColumn(this.namespace2packageTable, 200, Axis2ConsumptionUIMessages.LABEL_PACKAGE);
        this.namespace2packageTable.setVisible(true);
        final TableEditor editor = new TableEditor(this.namespace2packageTable);
        editor.setColumn(1);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.namespace2packageTable.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = Axis2ProxyWidget.this.namespace2packageTable.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = Axis2ProxyWidget.this.namespace2packageTable.getTopIndex();
                while (index < Axis2ProxyWidget.this.namespace2packageTable.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = Axis2ProxyWidget.this.namespace2packageTable.getItem(index);
                    int i = 0;
                    while (i < Axis2ProxyWidget.this.namespace2packageTable.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)Axis2ProxyWidget.this.namespace2packageTable, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            editor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
                Axis2ProxyWidget.this.model.setNamespaseToPackageMapping(Axis2ProxyWidget.this.getNs2PkgMapping());
            }
        });
        this.populateParamsFromWSDL();
        this.populateModel();
        return this;
    }

    private void declareColumn(Table table, int width, String colName) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(colName);
    }

    public String getNs2PkgMapping() {
        String returnList = "";
        TableItem[] items = this.namespace2packageTable.getItems();
        int i = 0;
        while (i < items.length) {
            String packageValue = items[i].getText(1);
            if (packageValue != null && !"".equals(packageValue)) {
                returnList = String.valueOf(returnList) + ("".equals(returnList) ? "" : ",") + items[i].getText(0) + "=" + packageValue;
            }
            ++i;
        }
        return "".equals(returnList) ? null : returnList;
    }

    public boolean isGenProxy() {
        return true;
    }

    public void setGenerateProxy(Boolean genProxy) {
        this.genProxyCheckbox_.setSelection(genProxy.booleanValue());
    }

    private void fillDatabinderCombo() {
        this.databindingTypeCombo.add("ADB");
        this.databindingTypeCombo.add("NONE");
        this.databindingTypeCombo.select(0);
    }

    private void populateModel() {
        this.model.setServiceName(this.serviceNameCombo.getText());
        this.model.setPortName(this.portNameCombo.getText());
        this.model.setPackageText(this.packageText.getText());
        this.model.setDatabindingType(this.databindingTypeCombo.getText());
        if (this.syncAndAsyncRadioButton.getSelection()) {
            this.model.setASync(!this.syncAndAsyncRadioButton.getSelection());
            this.model.setSync(!this.syncAndAsyncRadioButton.getSelection());
        }
        this.model.setGenerateAllCheck(this.generateAllCheckBoxButton.getSelection());
        this.model.setTestCaseCheck(this.testCaseCheckBoxButton.getSelection());
        this.model.setNamespaseToPackageMapping(this.getNs2PkgMapping());
    }

    public IStatus getStatus() {
        IStatus result = null;
        return result;
    }

    private void populatePackageName() {
        this.packageText.setText(this.reader.packageFromTargetNamespace());
    }

    public void populateParamsFromWSDL() {
        if (this.reader == null) {
            this.reader = new WSDLPropertyReader();
        }
        try {
            String lname = this.model.getWsdlURI();
            if (!"".equals(lname.trim())) {
                this.reader.readWSDL(this.model.getWebProjectName(), lname);
                this.serviceQNameList = this.reader.getServiceList();
                if (!this.serviceQNameList.isEmpty()) {
                    this.serviceNameCombo.removeAll();
                    int i = 0;
                    while (i < this.serviceQNameList.size()) {
                        Object serviceQnameInstance = this.serviceQNameList.get(0);
                        Class QNameClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.xml.namespace.QName");
                        Method GetLocalPartMethod = QNameClass.getMethod("getLocalPart", null);
                        Object resultLocalPart = GetLocalPartMethod.invoke(serviceQnameInstance, null);
                        this.serviceNameCombo.add(resultLocalPart.toString());
                        ++i;
                    }
                    this.serviceNameCombo.select(0);
                    this.loadPortNames();
                } else {
                    if (this.serviceNameCombo != null) {
                        this.serviceNameCombo.removeAll();
                    }
                    if (this.portNameCombo != null) {
                        this.portNameCombo.removeAll();
                    }
                }
                this.populatePackageName();
                this.loadNamespaces(this.reader.getDefinitionNamespaceMap());
            }
        }
        catch (Exception e) {
            this.status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2ConsumptionUIMessages.ERROR_INVALID_WSDL_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    private void loadNamespaces(Map namespaceMap) {
        Iterator namespaces = namespaceMap.values().iterator();
        this.namespace2packageTable.removeAll();
        TableItem[] items = new TableItem[namespaceMap.size()];
        int i = 0;
        while (namespaces.hasNext()) {
            items[i] = new TableItem(this.namespace2packageTable, 0);
            String namespace = (String)namespaces.next();
            items[i].setText(0, namespace);
            items[i].setText(1, this.getPackageFromNamespace(namespace));
            ++i;
        }
        this.namespace2packageTable.setVisible(true);
    }

    private void loadPortNames() {
        List ports;
        int selectionIndex = this.serviceNameCombo.getSelectionIndex();
        if (selectionIndex != -1 && !(ports = this.reader.getPortNameList(this.serviceQNameList.get(selectionIndex))).isEmpty()) {
            this.portNameCombo.removeAll();
            int i = 0;
            while (i < ports.size()) {
                this.portNameCombo.add(ports.get(i).toString());
                ++i;
            }
            this.portNameCombo.select(0);
        }
    }

    public String getPackageFromNamespace(String namespace) {
        Object stringReturn = null;
        try {
            Class URLProcessorClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.util.URLProcessor");
            Method makePackageNameMethod = URLProcessorClass.getMethod("makePackageName", String.class);
            stringReturn = makePackageNameMethod.invoke(null, namespace);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (String)stringReturn;
    }
}

