/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveSaveAdapter;
import org.eclipse.jst.jee.archive.internal.ArchiveImpl;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.jst.jee.archive.internal.ZipFileArchiveLoadAdapterImpl;
import org.eclipse.jst.jee.archive.internal.ZipStreamArchiveSaveAdapterImpl;

public class ArchiveFactoryImpl
implements IArchiveFactory {
    public IArchive openArchive(IPath archivePath) throws ArchiveOpenFailureException {
        ZipFile zipFile;
        File file = new File(archivePath.toOSString());
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(e);
            throw openFailureException;
        }
        catch (IOException e) {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(e);
            throw openFailureException;
        }
        ZipFileArchiveLoadAdapterImpl loadAdapter = new ZipFileArchiveLoadAdapterImpl(zipFile);
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setOption("LOAD_ADAPTER", loadAdapter);
        return this.openArchive(archiveOptions);
    }

    public IArchive openArchive(ArchiveOptions archiveOptions) throws ArchiveOpenFailureException {
        ArchiveImpl archive = new ArchiveImpl(archiveOptions);
        archive.setArchiveFactory(this);
        return archive;
    }

    public void closeArchive(IArchive archive) {
        ((ArchiveImpl)archive).close();
    }

    public void saveArchive(IArchive archive, IPath outputPath, IProgressMonitor monitor) throws ArchiveSaveFailureException {
        try {
            monitor.beginTask("Saving archive to: " + outputPath.toOSString(), 199);
            String aUri = outputPath.toOSString();
            File aFile = new File(aUri);
            ArchiveUtil.checkWriteable(aFile);
            boolean fileExisted = aFile.exists();
            IArchiveSaveAdapter aSaveAdapter = null;
            try {
                File destinationFile = fileExisted ? ArchiveUtil.createTempFile(aUri, aFile.getCanonicalFile().getParentFile()) : aFile;
                aSaveAdapter = this.createSaveAdapterForJar(destinationFile);
                aSaveAdapter.setArchive(archive);
                this.save(aSaveAdapter, (IProgressMonitor)new SubProgressMonitor(monitor, 198));
                aSaveAdapter.close();
                if (fileExisted) {
                    ArchiveUtil.cleanupAfterTempSave(aUri, aFile, destinationFile);
                }
                monitor.worked(1);
            }
            catch (IOException e) {
                throw new ArchiveSaveFailureException("Error saving archive: " + archive + " to output path: " + outputPath, e);
            }
            catch (ArchiveSaveFailureException failure) {
                try {
                    if (aSaveAdapter != null) {
                        aSaveAdapter.close();
                    }
                }
                catch (IOException iOException) {}
                if (!fileExisted) {
                    aFile.delete();
                }
                throw failure;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IArchiveSaveAdapter createSaveAdapterForJar(File aFile) throws IOException {
        if (aFile.exists() && aFile.isDirectory()) {
            throw new IOException("The specified file: " + aFile.getAbsolutePath() + " exists and is a directory");
        }
        File parent = aFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        return new ZipStreamArchiveSaveAdapterImpl(out);
    }

    protected void save(IArchiveSaveAdapter anAdapter, IProgressMonitor monitor) throws ArchiveSaveFailureException {
        try {
            anAdapter.save(monitor);
        }
        finally {
            try {
                anAdapter.close();
            }
            catch (IOException e) {
                throw new ArchiveSaveFailureException(e);
            }
        }
    }

    public void saveArchive(IArchive archive, ArchiveOptions archiveOptions, IProgressMonitor monitor) throws ArchiveSaveFailureException {
        try {
            monitor.beginTask("Saving archive", 200);
            IArchiveSaveAdapter aSaveAdapter = (IArchiveSaveAdapter)archiveOptions.getOption("SAVE_ADAPTER");
            try {
                aSaveAdapter.setArchive(archive);
                this.save(aSaveAdapter, (IProgressMonitor)new SubProgressMonitor(monitor, 198));
                aSaveAdapter.close();
                monitor.worked(2);
            }
            catch (ArchiveSaveFailureException failure) {
                try {
                    if (aSaveAdapter != null) {
                        aSaveAdapter.close();
                    }
                }
                catch (IOException iOException) {}
                throw failure;
            }
            catch (IOException iOException) {
                throw new ArchiveSaveFailureException("Error saving archive: " + archive);
            }
        }
        finally {
            monitor.done();
        }
    }
}

