/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.editor.JSPEditorPluginImageHelper;
import org.eclipse.jst.jsp.ui.internal.wizard.NewJSPFileWizardPage;
import org.eclipse.jst.jsp.ui.internal.wizard.NewJSPTemplatesWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewJSPWizard
extends Wizard
implements INewWizard {
    private NewJSPFileWizardPage fNewFilePage;
    private NewJSPTemplatesWizardPage fNewFileTemplatesPage;
    private IStructuredSelection fSelection;

    public void addPages() {
        this.fNewFilePage = new NewJSPFileWizardPage("JSPWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection)));
        this.fNewFilePage.setTitle(JSPUIMessages._UI_WIZARD_NEW_HEADING);
        this.fNewFilePage.setDescription(JSPUIMessages._UI_WIZARD_NEW_DESCRIPTION);
        this.addPage((IWizardPage)this.fNewFilePage);
        this.fNewFileTemplatesPage = new NewJSPTemplatesWizardPage();
        this.addPage((IWizardPage)this.fNewFileTemplatesPage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(JSPUIMessages._UI_WIZARD_NEW_TITLE);
        ImageDescriptor descriptor = JSPEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/newjspfile_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        this.fNewFileTemplatesPage.saveLastSavedPreferences();
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.fNewFilePage.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            String templateString = this.fNewFileTemplatesPage.getTemplateString();
            if (templateString != null) {
                Preferences preference = JSPCorePlugin.getDefault().getPluginPreferences();
                String charSet = preference.getString("outputCodeset");
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                    outputStreamWriter.write(templateString);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    file.setContents((InputStream)inputStream, true, false, null);
                    inputStream.close();
                }
                catch (Exception e) {
                    Logger.log(202, "Could not create contents for new JSP file", e);
                }
            }
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }
}

