/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EARComponentSaveStrategyImpl
extends ComponentSaveStrategyImpl {
    public EARComponentSaveStrategyImpl(IVirtualComponent component) {
        super(component);
    }

    public void setDataModel(IDataModel dataModel) {
        super.setDataModel(dataModel);
        this.setArchive((Archive)dataModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE"));
        this.overwriteHandler = (IOverwriteHandler)dataModel.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER");
        if (this.overwriteHandler != null) {
            this.overwriteHandler.setEarSaveStrategy(this);
        }
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return null;
    }

    public void save() throws SaveFailureException {
        this.saveFiles();
        this.saveManifest();
        this.saveMofResources();
        this.progressMonitor.subTask(EARArchiveOpsResourceHandler.Updating_project_classpath_UI_);
    }

    public void save(Archive anArchive) throws SaveFailureException {
        this.progressMonitor.subTask(anArchive.getURI());
        this.saveArchiveAsJARInEAR(anArchive);
    }

    protected void saveArchiveAsJARInEAR(Archive anArchive) throws SaveFailureException {
        try {
            anArchive.save(this.createNestedSaveStrategy(anArchive));
            this.progressMonitor.worked(1);
        }
        catch (IOException e) {
            throw new SaveFailureException(anArchive.getURI(), (Exception)e);
        }
    }

    protected SubProgressMonitor subMonitor() {
        return new SubProgressMonitor(this.progressMonitor, 10);
    }

    public void setMonitor(IProgressMonitor newMonitor) {
        this.progressMonitor = newMonitor;
    }

    protected boolean shouldSave(File aFile) {
        if (aFile.isArchive()) {
            return this.getFilter().shouldSave(aFile.getURI(), this.getArchive());
        }
        return super.shouldSave(aFile);
    }

    protected boolean shouldLinkAsComponentRef(Archive archive) {
        if (this.dataModel != null) {
            List list = (List)this.dataModel.getProperty("IEnterpriseApplicationImportDataModelProperties.HANDLED_PROJECT_MODELS_LIST");
            int i = 0;
            while (i < list.size()) {
                if (archive == ((IDataModel)list.get(i)).getProperty("IJ2EEArtifactImportDataModelProperties.FILE")) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean shouldSave(String uri) {
        if (this.overwriteHandler != null) {
            if (this.overwriteHandler.isOverwriteNone()) {
                return false;
            }
            return super.shouldSave(uri) && (this.overwriteHandler.isOverwriteAll() || this.overwriteHandler.isOverwriteResources() || this.overwriteHandler.shouldOverwrite(uri));
        }
        return true;
    }
}

