/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PHPEditorResolvingAction
extends TextEditorAction {
    private CodeData[] fCodeDatas;

    public PHPEditorResolvingAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
        super(resourceBundle, string, iTextEditor);
        this.setEnabled(true);
    }

    public void run() {
        if (this.isValid()) {
            this.doRun();
        }
    }

    protected abstract void doRun();

    protected ITextSelection getCurrentSelection() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return null;
        }
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            return null;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    protected boolean isValid() {
        CodeData[] codeDataArray;
        String string;
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return false;
        }
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iDocumentProvider == null || iEditorInput == null) {
            return false;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        if (iDocument == null) {
            return false;
        }
        if (!(iDocument instanceof IStructuredDocument)) {
            return false;
        }
        ITextSelection iTextSelection = this.getCurrentSelection();
        int n = iTextSelection.getOffset();
        IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
        try {
            string = iStructuredDocument.getPartition(n).getType();
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
        if (!string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return false;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return false;
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            codeDataArray = (CodeData[])iTextRegion;
            try {
                iTextRegion = codeDataArray.getPhpToken(n - iStructuredDocumentRegion.getStartOffset() - codeDataArray.getStart());
            }
            catch (BadLocationException badLocationException) {
                iTextRegion = null;
            }
        }
        if (iTextRegion == null) {
            return false;
        }
        codeDataArray = CodeDataResolver.getInstance().resolve(iStructuredDocument, n);
        this.fCodeDatas = this.filterCodeDatas(codeDataArray);
        return this.fCodeDatas.length > 0;
    }

    protected abstract CodeData[] filterCodeDatas(CodeData[] var1);

    protected CodeData[] getCodeDatas() {
        return this.fCodeDatas;
    }
}

