/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectOutline;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.OpenAction;
import org.eclipse.php.internal.ui.editor.LinkingSelectionListener;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineLabelProvider;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineViewGroup;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.MultiElementSelection;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPOutlineElementComparer;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class ProjectOutlinePart
extends ViewPart
implements IMenuListener,
FocusListener {
    final String MEMENTO_KEY_PROJECT = "ProjectOutlinePart.storedProjectName";
    protected ProjectOutlineViewGroup actionGroup;
    protected IProject currentProject;
    private String initProjectName;
    protected ProjectOutlineContentProvider fContentProvider;
    private Menu fContextMenu;
    protected ProjectOutlineLabelProvider fLabelProvider;
    private ISelection fLastOpenSelection;
    private boolean fLinkingEnabled;
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor(iWorkbenchPart);
            if (ProjectOutlinePart.this.getViewer().getTree().getVisible() && pHPStructuredEditor != null) {
                ProjectOutlinePart.this.updateInputForCurrentEditor((IEditorPart)pHPStructuredEditor);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
            PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor(iWorkbenchPart);
            if (ProjectOutlinePart.this.getViewer().getTree().getVisible() && pHPStructuredEditor != null) {
                ProjectOutlinePart.this.updateInputForCurrentEditor((IEditorPart)pHPStructuredEditor);
            }
        }
    };
    private ISelectionChangedListener fPostSelectionListener;
    private final LinkingSelectionListener fSelectionListener = new LinkingSelectionListener(){

        public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
            Object object;
            IStructuredSelection iStructuredSelection;
            if (iWorkbenchPart instanceof IEditorPart) {
                ProjectOutlinePart.this.handleUpdateInput((IEditorPart)iWorkbenchPart);
            }
            if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() > 0 && (object = iStructuredSelection.getFirstElement()) instanceof IProject) {
                ProjectOutlinePart.this.setProject((IProject)object);
                return;
            }
            super.selectionChanged(iWorkbenchPart, iSelection);
        }
    };
    protected PHPTreeViewer fViewer;
    private String fWorkingSetName;
    OpenAction openEditorAction;
    private boolean showAll = false;
    private UpdateViewJob updateViewJob;

    public void focusGained(FocusEvent focusEvent) {
        ((ProjectOutlineContentProvider)this.fViewer.getContentProvider()).postRefresh(this.fViewer.getInput(), true);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                Object object;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null && (object = treeItem.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(ProjectOutlinePart.this.fLabelProvider.getTooltipText(object));
                }
            }
        });
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
            this.fLastOpenSelection = null;
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    protected ProjectOutlineViewGroup createActionGroup() {
        return new ProjectOutlineViewGroup(this);
    }

    public ProjectOutlineContentProvider createContentProvider() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("explorerCuchildren");
        return new ProjectOutlineContentProvider(this, bl);
    }

    protected ProjectOutlineLabelProvider createLabelProvider() {
        return new ProjectOutlineLabelProvider(1090519051, 3, this.fContentProvider);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        if (iMemento != null) {
            this.initProjectName = iMemento.getString("ProjectOutlinePart.storedProjectName");
        }
    }

    public void saveState(IMemento iMemento) {
        if (this.currentProject != null) {
            iMemento.putString("ProjectOutlinePart.storedProjectName", this.currentProject.getName());
        }
        super.saveState(iMemento);
    }

    public void createPartControl(Composite composite) {
        this.getSite().getPage().addPartListener(this.fPartListener);
        this.fViewer = this.createViewer(composite);
        PHPElementSorter pHPElementSorter = new PHPElementSorter();
        pHPElementSorter.setUsingCategories(false);
        pHPElementSorter.setUsingLocation(true);
        this.fViewer.setSorter(pHPElementSorter);
        this.fViewer.getControl().addFocusListener((FocusListener)this);
        this.fSelectionListener.setViewer(this.getViewer());
        this.fSelectionListener.setResetEmptySelection(false);
        this.setProviders();
        this.fViewer.setUseHashlookup(true);
        this.setUpPopupMenu();
        this.initLinkingEnabled();
        this.actionGroup = this.createActionGroup();
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ProjectOutlinePart.this.handlePostSelectionChanged(selectionChangedEvent);
            }
        };
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.addMouseTrackListener();
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                ProjectOutlinePart.this.fLastOpenSelection = openEvent.getSelection();
                ProjectOutlinePart.this.openEditorAction.run((IStructuredSelection)ProjectOutlinePart.this.fLastOpenSelection);
            }
        });
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.updateTitle();
        IEditorPart iEditorPart = this.getViewSite().getPage().getActiveEditor();
        this.updateInputForCurrentEditor(iEditorPart);
        this.openEditorAction = new OpenAction((IWorkbenchSite)this.getSite());
        this.fillActionBars();
        this.setLinkingEnabled(this.isLinkingEnabled());
        if (this.initProjectName != null) {
            this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(this.initProjectName));
        }
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this.fContentProvider);
        this.fViewer.refresh();
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new ProjectOutlineTreeViewer(composite, 772);
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this.fContentProvider);
        super.dispose();
    }

    void editorActivated(IEditorPart iEditorPart) {
    }

    private void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.actionGroup.fillActionBars(iActionBars);
    }

    String getFrameName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return this.fLabelProvider.getText(object);
    }

    String getToolTipText(Object object) {
        Object object2;
        String string = !(object instanceof IResource) ? (object instanceof PHPWorkspaceModelManager ? PHPUIMessages.PHPExplorerPart_workspace : (object instanceof PHPCodeData ? PHPElementLabels.getTextLabel(object, 1090519051L) : this.fLabelProvider.getText(object))) : ((object2 = ((IResource)object).getFullPath()).isRoot() ? PHPUIMessages.PHPExplorer_title : object2.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return string;
        }
        object2 = MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip, this.fWorkingSetName);
        if (string.length() == 0) {
            return object2;
        }
        return MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip2, string, this.fWorkingSetName);
    }

    public PHPTreeViewer getViewer() {
        return this.fViewer;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    private void handlePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (this.isLinkingEnabled() && !iSelection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)iSelection);
        }
        this.fLastOpenSelection = iSelection;
    }

    public void handleUpdateInput(IEditorPart iEditorPart) {
        IProject iProject = null;
        if (iEditorPart != null) {
            PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)iEditorPart);
            if (pHPStructuredEditor != null) {
                PHPFileData pHPFileData = pHPStructuredEditor.getPHPFileData();
                iProject = PHPWorkspaceModelManager.getInstance().getProjectForFileData(pHPFileData, this.currentProject);
            } else {
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                if (iEditorInput instanceof FileEditorInput) {
                    FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
                    iProject = fileEditorInput.getFile().getProject();
                }
            }
        }
        if (iProject != null) {
            this.setProject(iProject);
        }
    }

    private void initLinkingEnabled() {
        this.setLinkingEnabled(PreferenceConstants.getPreferenceStore().getBoolean("browsingProjectstoeditor"));
    }

    public boolean isInCurrentProject(Object object) {
        if (this.currentProject != null) {
            return this.currentProject.equals((Object)PHPModelUtil.getResource((Object)object).getProject());
        }
        return false;
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof PHPCodeData) {
                EditorUtility.revealInEditor(iEditorPart, (PHPCodeData)object);
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        PHPUiPlugin.createStandardGroups(iMenuManager);
        this.actionGroup.setContext(new ActionContext(this.fViewer.getSelection()));
        this.actionGroup.fillContextMenu(iMenuManager);
        this.actionGroup.setContext(null);
    }

    void projectStateChanged(Object object) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed() && control.isVisible()) {
            this.fViewer.refresh(object, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    public void setLinkingEnabled(boolean bl) {
        this.fLinkingEnabled = bl;
        PreferenceConstants.getPreferenceStore().setValue("browsingProjectstoeditor", bl);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchPartSite.getPage();
        if (iWorkbenchPage == null) {
            return;
        }
        if (bl) {
            iWorkbenchPage.addPostSelectionListener((ISelectionListener)this.fSelectionListener);
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart != null) {
                this.editorActivated(iEditorPart);
            }
        } else {
            iWorkbenchPage.removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        }
    }

    public void setProject(IProject iProject) {
        if (iProject == this.currentProject) {
            return;
        }
        this.currentProject = iProject;
        if (this.updateViewJob == null) {
            this.updateViewJob = new UpdateViewJob();
        }
        this.updateViewJob.schedule();
        this.actionGroup.updateActions();
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        IPHPTreeContentProvider[] iPHPTreeContentProviderArray = TreeProvider.getTreeProviders(this.getViewSite().getId());
        this.fContentProvider.setTreeProviders(iPHPTreeContentProviderArray);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setTreeProviders(iPHPTreeContentProviderArray);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
    }

    public void setShowAll(boolean bl) {
        if (bl != this.showAll) {
            this.showAll = bl;
            if (this.updateViewJob == null) {
                this.updateViewJob = new UpdateViewJob();
            }
            this.updateViewJob.schedule();
        }
    }

    private void setUpPopupMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ISelection iSelection = ProjectOutlinePart.this.fViewer.getSelection();
                if (!iSelection.isEmpty()) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    boolean cfr_ignored_0 = iStructuredSelection.getFirstElement() instanceof PHPFunctionData;
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(IEditorPart iEditorPart) {
        this.handleUpdateInput(iEditorPart);
    }

    void updateTitle() {
        Object object = this.fViewer.getInput();
        if (object == null || object instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String string = PHPElementLabels.getTextLabel(object, 1090519051L);
            this.setContentDescription(string);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    private class ProjectOutlineTreeViewer
    extends PHPTreeViewer {
        List fPendingGetChildren;

        public ProjectOutlineTreeViewer(Composite composite, int n) {
            super(composite, n);
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
            this.setComparer(new PHPOutlineElementComparer());
        }

        public void add(Object object, Object[] objectArray) {
            if (this.fPendingGetChildren.contains(object)) {
                return;
            }
            super.add(object, objectArray);
        }

        private TreePath createTreePath(TreeItem treeItem) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(treeItem.getData());
            TreeItem treeItem2 = treeItem.getParentItem();
            while (treeItem2 != null) {
                arrayList.add(treeItem2.getData());
                treeItem2 = treeItem2.getParentItem();
            }
            Collections.reverse(arrayList);
            return new TreePath(arrayList.toArray());
        }

        private Object filter(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
            int n = 0;
            while (n < viewerFilterArray.length) {
                ViewerFilter viewerFilter = viewerFilterArray[n];
                if (!viewerFilter.select((Viewer)ProjectOutlinePart.this.fViewer, object2, object)) {
                    return null;
                }
                ++n;
            }
            return object;
        }

        protected Object[] filter(Object[] objectArray) {
            ViewerFilter[] viewerFilterArray = this.getFilters();
            if (viewerFilterArray == null || viewerFilterArray.length == 0) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            Object object = this.getRoot();
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                if (!this.isEssential(objectArray[n])) {
                    int n2 = 0;
                    while (n2 < viewerFilterArray.length) {
                        bl = viewerFilterArray[n2].select((Viewer)this, object, objectArray[n]);
                        if (!bl) break;
                        ++n2;
                    }
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        private Object getElement(TreeItem treeItem) {
            Object object = treeItem.getData();
            if (object == null) {
                return null;
            }
            return object;
        }

        protected Object[] getFilteredChildren(Object object) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ViewerFilter[] viewerFilterArray = ProjectOutlinePart.this.fViewer.getFilters();
            if (ProjectOutlinePart.this.fViewer.getContentProvider() == null) {
                return new Object[0];
            }
            Object[] objectArray = ((ITreeContentProvider)ProjectOutlinePart.this.fViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                Object object2 = objectArray[n];
                if (!this.isEssential(object2)) {
                    if ((object2 = this.filter(object2, object, viewerFilterArray)) != null) {
                        arrayList.add(object2);
                    }
                } else {
                    arrayList.add(object2);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        protected Object[] getRawChildren(Object object) {
            try {
                this.fPendingGetChildren.add(object);
                Object[] objectArray = super.getRawChildren(object);
                return objectArray;
            }
            finally {
                this.fPendingGetChildren.remove(object);
            }
        }

        public ISelection getSelection() {
            IContentProvider iContentProvider = this.getContentProvider();
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return StructuredSelection.EMPTY;
            }
            if (!(iContentProvider instanceof IMultiElementTreeContentProvider)) {
                return super.getSelection();
            }
            Tree tree = this.getTree();
            TreeItem[] treeItemArray = tree.getSelection();
            ArrayList<Object> arrayList = new ArrayList<Object>(treeItemArray.length);
            ArrayList<TreePath> arrayList2 = new ArrayList<TreePath>();
            int n = 0;
            while (n < treeItemArray.length) {
                TreeItem treeItem = treeItemArray[n];
                Object object = this.getElement(treeItem);
                if (object != null) {
                    if (!arrayList.contains(object)) {
                        arrayList.add(object);
                    }
                    arrayList2.add(this.createTreePath(treeItem));
                }
                ++n;
            }
            return new MultiElementSelection((StructuredViewer)this, arrayList, arrayList2.toArray(new TreePath[arrayList2.size()]));
        }

        protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = null;
            arrayList = iSelection2 instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)iSelection2).toList()) : new ArrayList<IProject>();
            boolean bl = false;
            for (Object e : iStructuredSelection) {
                IProject iProject;
                if (e instanceof PHPProjectModel) {
                    iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)e);
                    if (iProject.isOpen()) continue;
                    arrayList.add(iProject);
                    bl = true;
                    continue;
                }
                if (!(e instanceof IProject) || !(iProject = (IProject)e).isOpen()) continue;
                bl = true;
            }
            if (bl) {
                iSelection2 = new StructuredSelection(arrayList);
                this.setSelection(iSelection2, true);
            }
            super.handleInvalidSelection(iSelection, iSelection2);
        }

        private boolean isEssential(Object object) {
            if (object instanceof IContainer) {
                IContainer iContainer = (IContainer)object;
                try {
                    return iContainer.members().length > 0;
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            return false;
        }

        public boolean isExpandable(Object object) {
            ViewerFilter[] viewerFilterArray = ProjectOutlinePart.this.fViewer.getFilters();
            Object[] objectArray = ((ITreeContentProvider)ProjectOutlinePart.this.fViewer.getContentProvider()).getChildren(object);
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (this.isEssential(object2)) {
                    return true;
                }
                if ((object2 = this.filter(object2, object, viewerFilterArray)) != null) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    class UpdateViewJob
    extends Job {
        public UpdateViewJob() {
            super("updateViewJob");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ProjectOutlinePart.this.getViewer().getInput() != ((UpdateViewJob)UpdateViewJob.this).ProjectOutlinePart.this.currentProject) {
                        ProjectOutlinePart.this.getViewer().setInput(((UpdateViewJob)UpdateViewJob.this).ProjectOutlinePart.this.currentProject);
                    }
                }
            });
            ProjectOutlinePart.this.fContentProvider.postRefresh(ProjectOutlinePart.this.currentProject, true);
            return Status.OK_STATUS;
        }
    }
}

