/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.rangedifferencer;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.LCS;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

class RangeComparatorLCS
extends LCS {
    private final IRangeComparator comparator1;
    private final IRangeComparator comparator2;
    private int[][] lcs;

    public static RangeDifference[] findDifferences(IProgressMonitor pm, IRangeComparator left, IRangeComparator right) {
        RangeComparatorLCS lcs = new RangeComparatorLCS(left, right);
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (String)CompareMessages.RangeComparatorLCS_0, (int)100);
        try {
            lcs.longestCommonSubsequence(monitor.newChild(95));
            RangeDifference[] rangeDifferenceArray = lcs.getDifferences(monitor.newChild(5));
            return rangeDifferenceArray;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    public RangeComparatorLCS(IRangeComparator comparator1, IRangeComparator comparator2) {
        this.comparator1 = comparator1;
        this.comparator2 = comparator2;
    }

    protected int getLength1() {
        return this.comparator1.getRangeCount();
    }

    protected int getLength2() {
        return this.comparator2.getRangeCount();
    }

    protected void initializeLcs(int lcsLength) {
        this.lcs = new int[2][lcsLength];
    }

    protected boolean isRangeEqual(int i1, int i2) {
        return this.comparator1.rangesEqual(i1, this.comparator2, i2);
    }

    protected void setLcs(int sl1, int sl2) {
        this.lcs[0][sl1] = sl1 + 1;
        this.lcs[1][sl1] = sl2 + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RangeDifference[] getDifferences(SubMonitor subMonitor) {
        try {
            block11: {
                block13: {
                    block12: {
                        block10: {
                            differences = new ArrayList<RangeDifference>();
                            length = this.getLength();
                            if (length != 0) break block10;
                            differences.add(new RangeDifference(2, 0, this.comparator2.getRangeCount(), 0, this.comparator1.getRangeCount()));
                            break block11;
                        }
                        subMonitor.beginTask(null, length);
                        index2 = 0;
                        index1 = 0;
                        s1 = -1;
                        s2 = -1;
                        break block12;
                        while (++index1 < this.lcs[0].length) lbl-1000:
                        // 2 sources

                        {
                            ** while ((l1 = this.lcs[0][index1]) != 0)
lbl17:
                            // 1 sources

                        }
lbl18:
                        // 2 sources

                        if (index1 < this.lcs[0].length) ** GOTO lbl-1000
                        break block13;
                        while (++index2 < this.lcs[1].length) lbl-1000:
                        // 2 sources

                        {
                            if ((l2 = this.lcs[1][index2]) == 0) continue;
                        }
                        if (index2 >= this.lcs[1].length) break block13;
                        end1 = l1 - 1;
                        end2 = l2 - 1;
                        if (s1 == -1 && (end1 != 0 || end2 != 0)) {
                            differences.add(new RangeDifference(2, 0, end2, 0, end1));
                        } else if (end1 != s1 + 1 || end2 != s2 + 1) {
                            leftStart = s1 + 1;
                            leftLength = end1 - leftStart;
                            rightStart = s2 + 1;
                            rightLength = end2 - rightStart;
                            differences.add(new RangeDifference(2, rightStart, rightLength, leftStart, leftLength));
                        }
                        s1 = end1;
                        s2 = end2;
                        ++index1;
                        ++index2;
                        this.worked(subMonitor, 1);
                    }
                    if (index1 < this.lcs[0].length && index2 < this.lcs[1].length) ** GOTO lbl-1000
                }
                if (s1 != -1 && (s1 + 1 < this.comparator1.getRangeCount() || s2 + 1 < this.comparator2.getRangeCount())) {
                    leftStart = s1 < this.comparator1.getRangeCount() ? s1 + 1 : s1;
                    rightStart = s2 < this.comparator2.getRangeCount() ? s2 + 1 : s2;
                    differences.add(new RangeDifference(2, rightStart, this.comparator2.getRangeCount() - (s2 + 1), leftStart, this.comparator1.getRangeCount() - (s1 + 1)));
                }
            }
            var17_16 = differences.toArray(new RangeDifference[differences.size()]);
            return var17_16;
        }
        finally {
            subMonitor.done();
        }
    }

    private void worked(SubMonitor subMonitor, int work) {
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        subMonitor.worked(work);
    }
}

