/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class PHPBuilderExtensionsRegistry {
    private static final String DEFAULT_EXTENSION_ID = "org.eclipse.php.core.project.build.DefaultPHPBuilderExtension";
    private static final String EXTENSION_NAME = "phpBuilderExtensions";
    private static final String BUILDER_ELEMENT = "builder";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private Map<String, Object> extensions;
    private static PHPBuilderExtensionsRegistry instance;

    private PHPBuilderExtensionsRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", EXTENSION_NAME);
        Object object = null;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if (BUILDER_ELEMENT.equals(iConfigurationElement.getName()) && DEFAULT_EXTENSION_ID.equals(iConfigurationElement.getAttribute(ID_ATTRIBUTE))) {
                try {
                    object = iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException coreException) {
                    PHPCorePlugin.log(coreException);
                }
                break;
            }
            ++n2;
        }
        if (object == null) {
            PHPCorePlugin.log(new IllegalStateException("no default project builder extension"));
            return;
        }
        this.extensions = new LinkedHashMap<String, Object>();
        this.extensions.put(DEFAULT_EXTENSION_ID, object);
        int n3 = 0;
        while (n3 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            if (BUILDER_ELEMENT.equals(iConfigurationElement.getName()) && !DEFAULT_EXTENSION_ID.equals(iConfigurationElement.getAttribute(ID_ATTRIBUTE))) {
                try {
                    this.extensions.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE));
                }
                catch (CoreException coreException) {
                    PHPCorePlugin.log(coreException);
                }
            }
            ++n3;
        }
    }

    public static synchronized PHPBuilderExtensionsRegistry getInstance() {
        if (instance == null) {
            instance = new PHPBuilderExtensionsRegistry();
        }
        return instance;
    }

    public IPHPBuilderExtension[] getExtensions() {
        Collection<Object> collection = PHPBuilderExtensionsRegistry.instance.extensions.values();
        return collection.toArray(new IPHPBuilderExtension[collection.size()]);
    }

    public IPHPBuilderExtension getExtension(String string) {
        return (IPHPBuilderExtension)PHPBuilderExtensionsRegistry.instance.extensions.get(string);
    }
}

