/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.connection;

import java.io.File;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;

public class DerbyShutdownService {
    public void dispose() {
    }

    public void connectionInfoCreated(ConnectionInfo info) {
    }

    public void connectionInfoRemoved(String name) {
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
    }

    public void connected(ConnectionInfo info, Connection connection) {
    }

    public void disconnected(ConnectionInfo info, Connection connection) {
        if (!info.getURL().startsWith("jdbc:derby:")) {
            return;
        }
        try {
            ConnectionInfo[] infos = new ConnectionInfo[]{};
            int n = 0;
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i] == info || infos[i].getSharedConnection() == null || !infos[i].getDriverClassName().equals(info.getDriverClassName()) || !this.getDBLocation(infos[i]).equals(this.getDBLocation(info))) continue;
                ++n;
            }
            if (n == 0) {
                this.shutdown(info);
            }
        }
        catch (Exception ex) {
            boolean a = false;
        }
    }

    protected File getDBLocation(ConnectionInfo info) {
        String url = info.getURL();
        int n = (url = url.substring("jdbc:derby:".length())).indexOf(59);
        if (n >= 0) {
            url = url.substring(0, n);
        }
        return new File(url);
    }

    protected void shutdown(ConnectionInfo info) {
        String uniqueName = DerbyShutdownService.generateName("shutdownInfo", DerbyShutdownService.getConnectionNames());
    }

    protected static Collection getConnectionNames() {
        ConnectionInfo[] infos = new ConnectionInfo[]{};
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < infos.length; ++i) {
            v.add(infos[i].getName());
        }
        return v;
    }

    protected static String generateName(String baseName, Collection exclusionList) {
        String curName = baseName;
        int count = 0;
        while (DerbyShutdownService.isIn(curName, exclusionList)) {
            curName = baseName + String.valueOf(count);
            ++count;
        }
        return baseName;
    }

    protected static boolean isIn(String s, Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (!s.equals(it.next())) continue;
            return true;
        }
        return false;
    }
}

