/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute;

import java.io.FileNotFoundException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.TableDataEditorPlugin;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.query.execute.ISQLExecutionProvider;
import org.eclipse.datatools.sqltools.internal.tabledataeditor.util.ResourceLoader;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.ResultsViewUIAccessor;
import org.eclipse.emf.common.util.WrappedException;

public class QueryOutputHelper {
    private String objectName = "";
    private String statementSource = "";
    private String profileName = "";
    private String databaseName = "";
    private OperationCommand stmtOutput = null;
    private Vector sqlExecutionProviders = null;
    private Connection jdbcConnection = null;
    private boolean updateOutputItemStatus = true;
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo;

    public QueryOutputHelper(Connection connection) {
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public QueryOutputHelper(String statementString, Connection connection, String profileName, String databaseName) {
        this.profileName = profileName;
        this.statementSource = statementString;
        this.jdbcConnection = connection;
        this.sqlExecutionProviders = this.getSQLExecutionProviders();
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setOutputItem(OperationCommand stmtOutput) {
        this.stmtOutput = stmtOutput;
    }

    public void setUpdateOutputItemStatus(boolean updateOutputItemStatus) {
        this.updateOutputItemStatus = updateOutputItemStatus;
    }

    public void setStatement(String statementSource) {
        this.statementSource = statementSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runSQLScrapbookQuery() {
        try {
            if (this.jdbcConnection == null) return true;
            OperationCommand oi = this.getOutputItem(ResourceLoader.INSTANCE.queryString("_UI_SCRAPBOOK_ITEM_TITLE"));
            ResultsViewAPI.getInstance().updateStatus(oi, 2);
            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
            this.showMessage(this.statementSource);
            ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
            Statement stmt = null;
            try {
                if (provider != null) {
                    stmt = provider.execute(this.jdbcConnection, this.statementSource);
                } else {
                    stmt = this.isCallStatement(this.statementSource) ? this.jdbcConnection.prepareCall(this.statementSource) : this.jdbcConnection.createStatement();
                    if (!this.isCreateStatement(this.statementSource)) {
                        boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                        if (setLimit) {
                            int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                            stmt.setMaxRows(integer);
                        } else {
                            stmt.setMaxRows(0);
                        }
                        int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                        if (fieldSize > 0) {
                            stmt.setMaxFieldSize(fieldSize);
                        }
                    }
                    if (this.isCallStatement(this.statementSource)) {
                        ((CallableStatement)stmt).execute();
                    } else {
                        stmt.execute(this.statementSource);
                    }
                }
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet != null) {
                    ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 2);
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                    ResultsViewAPI.getInstance().appendResultSet(this.getOutputItem(), resultSet);
                    SQLWarning rsWarningMsgs = resultSet.getWarnings();
                    if (rsWarningMsgs != null) {
                        this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                        this.displayMessages(rsWarningMsgs);
                    }
                } else {
                    ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 3);
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
                }
                SQLWarning rsWarningMsgs = stmt.getWarnings();
                if (rsWarningMsgs == null) return true;
                this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                this.displayMessages(rsWarningMsgs);
                return true;
            }
            catch (SQLException exception) {
                SQLException sqlExp = exception;
                String sqlState = sqlExp.getSQLState();
                String sqlCode = Integer.toString(sqlExp.getErrorCode());
                String sqlMsg = sqlExp.getLocalizedMessage();
                String expMsg = exception.toString();
                this.showErrors("SQL State = " + sqlState + " SQL Code = " + sqlCode + " SQL Message = " + sqlMsg + " Exception message = " + expMsg, 6);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.showErrors(exception.toString(), 6);
                boolean bl = false;
                return bl;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (NoSuchElementException e) {
            this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
            return false;
        }
        catch (WrappedException e) {
            String msg = e.exception() instanceof FileNotFoundException ? ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString() : e.toString();
            this.showErrors(msg, 6);
            return false;
        }
        catch (Exception e) {
            this.showErrors(e.toString(), 6);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean runQuery() {
        if (this.jdbcConnection == null) return true;
        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
        this.showMessage(this.statementSource);
        Statement stmt = null;
        ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
        try {
            if (provider != null) {
                stmt = provider.execute(this.jdbcConnection, this.statementSource);
            } else {
                stmt = this.isCallStatement(this.statementSource) ? this.jdbcConnection.prepareCall(this.statementSource) : this.jdbcConnection.createStatement();
                boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
                if (setLimit) {
                    int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
                    stmt.setMaxRows(integer);
                } else {
                    stmt.setMaxRows(0);
                }
                int fieldSize = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
                if (fieldSize > 0) {
                    stmt.setMaxFieldSize(fieldSize);
                }
                if (this.isCallStatement(this.statementSource)) {
                    ((CallableStatement)stmt).execute();
                } else {
                    stmt.execute(this.statementSource);
                }
            }
            ResultSet resultSet = stmt.getResultSet();
            if (resultSet != null) {
                this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_SUCCESSFUL"));
                ResultsViewAPI.getInstance().appendResultSet(this.getOutputItem(), resultSet);
                int numDisplayed = ResultsViewUIAccessor.getInstance().getRowCount(this.stmtOutput);
                if (numDisplayed >= 1000) {
                    this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_MAX_RECORD_EXCEEDED"));
                } else {
                    this.showMessage(numDisplayed + " " + ResourceLoader.INSTANCE.queryString("_UI_MSG_RECORD_RETURNED"));
                }
                SQLWarning rsWarningMsgs = resultSet.getWarnings();
                if (rsWarningMsgs != null) {
                    this.showErrors(ResourceLoader.INSTANCE.queryString("_WARN_MESSAGES_ENCOUNTERED"), 4);
                    this.displayMessages(rsWarningMsgs);
                }
                ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), 3);
            }
            if (stmt == null) return true;
        }
        catch (Exception exception) {
            boolean bl;
            try {
                this.showErrors(exception.toString(), 6);
                bl = false;
                if (stmt == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
                    return false;
                }
                catch (WrappedException e) {
                    String msg = e.exception() instanceof FileNotFoundException ? ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString() : e.toString();
                    this.showErrors(msg, 6);
                    return false;
                }
                catch (Exception e) {
                    this.showErrors(e.toString(), 6);
                    return false;
                }
            }
            stmt.close();
            return bl;
        }
        stmt.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeDDL(String source) {
        if (this.jdbcConnection == null) return true;
        if (this.updateOutputItemStatus) {
            // empty if block
        }
        this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_MSG_EXE_STARTING"));
        this.showMessage(this.statementSource);
        Statement stmt = null;
        try {
            ISQLExecutionProvider provider = this.getProviderFor(this.jdbcConnection, this.statementSource);
            if (provider != null) {
                stmt = provider.execute(this.jdbcConnection, this.statementSource);
            } else if (this.isCallStatement(this.statementSource)) {
                stmt = this.jdbcConnection.prepareCall(this.statementSource);
                ((CallableStatement)stmt).execute();
            } else {
                stmt = this.jdbcConnection.createStatement();
                stmt.execute(this.statementSource);
            }
            if (this.updateOutputItemStatus) {
                // empty if block
            }
            this.showMessage(ResourceLoader.INSTANCE.queryString("_UI_LABEL_EXECUTION_SUCCESSFUL"));
            if (stmt == null) return true;
        }
        catch (Exception exception) {
            boolean bl;
            try {
                this.showErrors(exception.toString(), 6);
                bl = false;
                if (stmt == null) return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    this.showErrors(ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION"), 6);
                    return false;
                }
                catch (WrappedException e) {
                    String msg = e.exception() instanceof FileNotFoundException ? ResourceLoader.INSTANCE.queryString("_UI_LABEL_NO_CONNECTION_FILE") + "\n\n" + e.exception().toString() : e.toString();
                    this.showErrors(msg, 6);
                    return false;
                }
                catch (Exception e) {
                    this.showErrors(e.toString(), 6);
                    return false;
                }
            }
            stmt.close();
            return bl;
        }
        stmt.close();
        return true;
    }

    private boolean isCallStatement(String sql) {
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            if (sql.charAt(i) == ' ') continue;
            int end = Math.min(i + 4, len);
            String sub = sql.substring(i, end);
            return sub.toUpperCase().equals("CALL");
        }
        return false;
    }

    private boolean isCreateStatement(String sql) {
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            if (sql.charAt(i) == ' ') continue;
            int end = Math.min(i + 6, len);
            String sub = sql.substring(i, end);
            return sub.toUpperCase().equals("CREATE");
        }
        return false;
    }

    private void showErrors(String messageText, int newStatus) {
        if (this.updateOutputItemStatus) {
            ResultsViewAPI.getInstance().updateStatus(this.getOutputItem(), newStatus);
        }
        this.showMessage(messageText);
    }

    private void showMessage(String messageText) {
        ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), messageText);
    }

    private OperationCommand getOutputItem() {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OperationCommand(1, null, this.objectName, this.profileName, this.databaseName);
            ResultsViewAPI.getInstance().createNewInstance(this.stmtOutput, null);
        }
        return this.stmtOutput;
    }

    private OperationCommand getOutputItem(String source) {
        if (this.stmtOutput == null) {
            this.stmtOutput = new OperationCommand(1, null, source, this.profileName, this.databaseName);
            ResultsViewAPI.getInstance().createNewInstance(this.stmtOutput, null);
        }
        return this.stmtOutput;
    }

    protected Runnable getTerminateHandler() {
        Runnable run = new Runnable(){

            public void run() {
                ResultsViewAPI.getInstance().updateStatus(QueryOutputHelper.this.getOutputItem(), 5);
                QueryOutputHelper.this.stmtOutput = null;
            }
        };
        return run;
    }

    private void displayMessages(SQLWarning except) {
        String reason = "";
        reason = except instanceof DataTruncation ? ResourceLoader.INSTANCE.queryString("_WARN_DATA_WAS_TRUNCATED") : ResourceLoader.INSTANCE.queryString("_WARN_SQL_WARNINGS_FOUND");
        ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), reason);
        do {
            ResultsViewAPI.getInstance().appendStatusMessage(this.getOutputItem(), "SQLState=" + except.getSQLState() + " " + except.getMessage());
        } while ((except = except.getNextWarning()) != null);
    }

    private Vector getSQLExecutionProviders() {
        Vector<SQLExecutionProviderExtension> providers = new Vector<SQLExecutionProviderExtension>();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.server.ui", "SQLExecutionProvider");
        if (extensionPoint == null) {
            return new Vector();
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        block2: for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("provider")) continue;
                try {
                    SQLExecutionProviderExtension sepe = new SQLExecutionProviderExtension(configElements[j]);
                    providers.add(sepe);
                }
                catch (CoreException e) {
                    Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "An error was detected when creating the SQL Execution Provider.", (Throwable)e);
                    TableDataEditorPlugin.getDefault().getLog().log((IStatus)status);
                }
                continue block2;
            }
        }
        return providers;
    }

    private ISQLExecutionProvider getProviderFor(Connection con, String stmt) {
        Database db = this.getDatabaseFor(con);
        if (db != null) {
            Iterator it = this.sqlExecutionProviders.iterator();
            while (it.hasNext()) {
                SQLExecutionProviderExtension sepe = (SQLExecutionProviderExtension)it.next();
                if (!sepe.vendor.equals("*") && !db.getVendor().equals(sepe.vendor) || !sepe.version.equals("*") && !db.getVersion().equals(sepe.version) || !sepe.getExecutionProvider().isProviderFor(stmt)) continue;
                return sepe.getExecutionProvider();
            }
        }
        return null;
    }

    private Database getDatabaseFor(Connection con) {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        int n = profiles.length;
        for (int i = 0; i < n; ++i) {
            IManagedConnection connection;
            ConnectionInfo info;
            IConnectionProfile profile = profiles[i];
            if (!profile.isConnected() || !con.equals((info = (ConnectionInfo)(connection = profile.getManagedConnection((class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo == null ? QueryOutputHelper.class$("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo") : class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo).getName())).getConnection().getRawConnection()).getSharedConnection())) continue;
            return info.getSharedDatabase();
        }
        return null;
    }

    private class SQLExecutionProviderExtension {
        ISQLExecutionProvider executionProvider;
        String vendor;
        String version;

        public SQLExecutionProviderExtension(IConfigurationElement element) throws CoreException {
            this.vendor = element.getAttribute("vendor");
            this.version = element.getAttribute("version");
            this.executionProvider = (ISQLExecutionProvider)element.createExecutableExtension("class");
        }

        public ISQLExecutionProvider getExecutionProvider() {
            return this.executionProvider;
        }
    }
}

