/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.jface.util.ListenerList;

public class SQLToolsProfileListenersManager {
    private static SQLToolsProfileListenersManager _manager;
    private ListenerList _listeners = new ListenerList();

    private SQLToolsProfileListenersManager() {
    }

    public static synchronized SQLToolsProfileListenersManager getInstance() {
        if (_manager == null) {
            _manager = new SQLToolsProfileListenersManager();
        }
        return _manager;
    }

    public void addProfileListener(ISQLToolsProfileListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.add((Object)listener);
    }

    public void removeProfileListener(ISQLToolsProfileListener listener) {
        if (listener == null) {
            return;
        }
        this._listeners.remove((Object)listener);
    }

    public void fireProfileAdded(IConnectionProfile profile) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ISQLToolsProfileListener)listeners[i]).profileAdded(profile);
        }
    }

    public void fireProfileDeleted(IConnectionProfile profile) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ISQLToolsProfileListener)listeners[i]).profileDeleted(profile);
        }
    }

    public void fireProfileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        Object[] listeners = this._listeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ISQLToolsProfileListener)listeners[i]).profileChanged(profile, oldName, oldDesc, oldAutoConnect, onlyNameChanged, oldProfile);
        }
    }
}

