/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.util;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class HTMLPrinter {
    private static RGB BG_COLOR_RGB;

    static {
        block3: {
            BG_COLOR_RGB = null;
            final Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            BG_COLOR_RGB = display.getSystemColor(29).getRGB();
                        }
                    });
                }
                catch (SWTError error) {
                    if (error.code == 45) break block3;
                    throw error;
                }
            }
        }
    }

    public static void addBullet(StringBuffer buffer, String face, int height, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append("<span style= \"font-size:");
            buffer.append(height);
            buffer.append(".0pt;font-family:");
            buffer.append(face);
            buffer.append("\">");
            buffer.append(bullet);
            buffer.append("</span>");
            buffer.append("</li>");
        }
    }

    public static void addPageEpilog(StringBuffer buffer) {
        buffer.append("</font></body></html>");
    }

    public static void addParagraph(StringBuffer buffer, String face, int height, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append("<span style= \"font-size:");
            buffer.append(height);
            buffer.append(".0pt;font-family:");
            buffer.append(face);
            buffer.append("\">");
            buffer.append(paragraph);
            buffer.append("</span>");
        }
    }

    public static void addSmallHeader(StringBuffer buffer, String face, int height, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append("<span style= \"font-size:");
            buffer.append(height);
            buffer.append(".0pt;font-family:");
            buffer.append(face);
            buffer.append("\">");
            buffer.append(header);
            buffer.append("</span>");
            buffer.append("</h5>");
        }
    }

    private static void appendColor(StringBuffer buffer, RGB rgb) {
        buffer.append('#');
        buffer.append(Integer.toHexString(rgb.red));
        buffer.append(Integer.toHexString(rgb.green));
        buffer.append(Integer.toHexString(rgb.blue));
    }

    public static String convertToHTMLContent(String content) {
        content = HTMLPrinter.replace(content, '&', "&amp;");
        content = HTMLPrinter.replace(content, '\"', "&quot;");
        content = HTMLPrinter.replace(content, '<', "&lt;");
        return HTMLPrinter.replace(content, '>', "&gt;");
    }

    public static void endBulletList(StringBuffer buffer) {
        buffer.append("</ul>");
    }

    private static RGB getBgColor() {
        if (BG_COLOR_RGB != null) {
            return BG_COLOR_RGB;
        }
        return new RGB(255, 255, 225);
    }

    public static void insertPageProlog(StringBuffer buffer, String font, int height, int position, RGB bgRGB) {
        if (bgRGB == null) {
            HTMLPrinter.insertPageProlog(buffer, font, height, position, HTMLPrinter.getBgColor());
        } else {
            StringBuffer pageProlog = new StringBuffer(60);
            pageProlog.append("<html><body text=\"#000000\" bgcolor=\"");
            HTMLPrinter.appendColor(pageProlog, bgRGB);
            pageProlog.append("\"><font face=\"" + font + "\" size=\"" + height + ".0pt\">");
            buffer.insert(position, pageProlog.toString());
        }
    }

    public static void insertStyles(StringBuffer buffer, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuffer styleBuf = new StringBuffer(10 * styles.length);
        int i = 0;
        while (i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = buffer.indexOf("<body ");
        if (index == -1) {
            return;
        }
        buffer.insert(index + 5, (Object)styleBuf);
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static void startBulletList(StringBuffer buffer) {
        buffer.append("<ul>");
    }

    private HTMLPrinter() {
    }
}

