/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.extract;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.extract.ExtractData;
import org.eclipse.datatools.sqltools.data.internal.ui.FileFormatWizardPage;
import org.eclipse.datatools.sqltools.data.internal.ui.OutputItemAdapter;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.ExtractDataWizardPage;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.Messages;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ExtractDataWizard
extends Wizard {
    protected Table table;
    protected FileFormatWizardPage page;

    public ExtractDataWizard(Table table) {
        this.table = table;
        this.setWindowTitle(Messages.getString("ExtractDataWizard.ExtractData"));
    }

    public void addPages() {
        this.page = new ExtractDataWizardPage("org.eclipse.wst.rdb.data.ui.extractData");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveSettings();
        String colDelim = this.page.getColumnDelimiter();
        String stringDelim = this.page.getStringDelimiter();
        String filePath = this.page.getFilePath();
        final ExtractData extract = new ExtractData(this.table, filePath);
        extract.setDelims(colDelim, stringDelim);
        final OperationCommand item = this.initDbOutputItem();
        Job job = new Job(Messages.getString("ExtractDataWizard.DataExtraction")){

            protected IStatus run(IProgressMonitor monitor) {
                int ret = extract.doExtract((Output)new OutputItemAdapter(item));
                ResultsViewAPI.getInstance().updateStatus(item, ret);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
        return true;
    }

    protected OperationCommand initDbOutputItem() {
        String qualifiedTableName = DataCorePlugin.getQualifiedTableName((Table)this.table);
        int actionType = 10;
        String displayStr = qualifiedTableName;
        String consumerName = null;
        Database database = this.table.getSchema().getCatalog() != null ? this.table.getSchema().getCatalog().getDatabase() : this.table.getSchema().getDatabase();
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)database);
        String connectionProfieName = ((ConnectionInfoImpl)connInfo).getConnectionProfile().getName();
        String databaseName = database.getName();
        OperationCommand oCommand = new OperationCommand(actionType, displayStr, consumerName, connectionProfieName, databaseName);
        return oCommand;
    }

    protected String getFullyQualifiedName() {
        return "\"" + this.table.getSchema().getName() + "\".\"" + this.table.getName() + "\"";
    }
}

