/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.XMLDataInputStream;
import org.eclipse.datatools.enablement.oda.xml.util.date.DateUtil;

public class ResultSet
implements IResultSet {
    private ResultSetMetaData rsMetaData;
    private int maxRows;
    private boolean wasNull;
    private boolean isClosed;
    private SaxParserConsumer spConsumer;

    public ResultSet(XMLDataInputStream is, RelationInformation ri, String tableName, int maxRows) throws OdaException {
        this.rsMetaData = new ResultSetMetaData(ri, tableName);
        this.maxRows = maxRows;
        this.isClosed = false;
        this.spConsumer = new SaxParserConsumer(ri, is, tableName);
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return this.rsMetaData;
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("ResultSet.ResultSetClosed"));
        }
    }

    public void close() throws OdaException {
        this.spConsumer.close();
        this.rsMetaData = null;
        this.isClosed = true;
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        this.testClosed();
        if (this.spConsumer.getCurrentRowNo() >= this.maxRows && this.maxRows != 0) {
            return false;
        }
        return this.spConsumer.next();
    }

    public int getRow() throws OdaException {
        this.testClosed();
        return this.spConsumer.getCurrentRowNo();
    }

    public String getString(int index) throws OdaException {
        this.testClosed();
        String result = this.spConsumer.getResultSet()[this.getRowPosition()][this.getColumnPosition(index)];
        this.wasNull = result == null;
        return result;
    }

    private int getColumnPosition(int index) {
        return index - 1;
    }

    private int getRowPosition() {
        return this.spConsumer.getRowPosition();
    }

    private int getColumnIndex(String columnName) throws OdaException {
        int i = 1;
        while (i <= this.rsMetaData.getColumnCount()) {
            if (this.rsMetaData.getColumnName(i).equals(columnName)) {
                return i;
            }
            ++i;
        }
        throw new OdaException();
    }

    public String getString(String name) throws OdaException {
        this.testClosed();
        return this.getString(this.getColumnIndex(name));
    }

    public int getInt(int index) throws OdaException {
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String name) throws OdaException {
        return this.stringToInt(this.getString(name));
    }

    private int stringToInt(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0;
    }

    public double getDouble(int index) throws OdaException {
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String name) throws OdaException {
        return this.stringToDouble(this.getString(name));
    }

    private double stringToDouble(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new Double(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String name) throws OdaException {
        return this.stringToBigDecimal(this.getString(name));
    }

    private BigDecimal stringToBigDecimal(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException e) {
                this.wasNull = true;
            }
        }
        return null;
    }

    public Date getDate(int index) throws OdaException {
        return this.stringToDate(this.getString(index));
    }

    public Date getDate(String columnName) throws OdaException {
        return this.stringToDate(this.getString(columnName));
    }

    private Date stringToDate(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                java.util.Date date = DateUtil.toDate((Object)stringValue);
                return new Date(date.getTime());
            }
            catch (OdaException oe) {
                this.wasNull = true;
                return null;
            }
        }
        return null;
    }

    public Time getTime(int index) throws OdaException {
        return this.stringToTime(this.getString(index));
    }

    public Time getTime(String columnName) throws OdaException {
        return this.stringToTime(this.getString(columnName));
    }

    private Time stringToTime(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                java.util.Date date = DateUtil.toDate((Object)stringValue);
                return new Time(date.getTime());
            }
            catch (OdaException oe) {
                this.wasNull = true;
                return null;
            }
        }
        this.wasNull = true;
        return null;
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        return this.stringToTimestamp(this.getString(index));
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.stringToTimestamp(this.getString(columnName));
    }

    private Timestamp stringToTimestamp(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            try {
                stringValue = stringValue.replaceAll("\\QT\\E", " ").split("\\QZ\\E")[0];
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException e) {
                try {
                    long timeMills = new Long(stringValue);
                    return new Timestamp(timeMills);
                }
                catch (NumberFormatException e1) {
                    try {
                        java.util.Date date = DateUtil.toDate((Object)stringValue);
                        Timestamp timeStamp = new Timestamp(date.getTime());
                        return timeStamp;
                    }
                    catch (OdaException oe) {
                        this.wasNull = true;
                        return null;
                    }
                }
            }
        }
        this.wasNull = true;
        return null;
    }

    public boolean wasNull() throws OdaException {
        this.testClosed();
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        this.testClosed();
        return this.getColumnIndex(columnName);
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.stringToBoolean(this.getString(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        return this.stringToBoolean(this.getString(index));
    }

    private Boolean stringToBoolean(String stringValue) throws OdaException {
        this.testClosed();
        if (stringValue != null) {
            if (stringValue.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (stringValue.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            try {
                if (Integer.parseInt(stringValue) == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            catch (NumberFormatException e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }
}

