/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.creation.core.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.jst.ws.axis2.creation.core.messages.Axis2CreationUIMessages;
import org.eclipse.jst.ws.axis2.creation.core.utils.CommonUtils;
import org.eclipse.jst.ws.axis2.creation.core.utils.ServiceXMLCreator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class Axis2BUServiceCreationCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private IWebService ws;

    public Axis2BUServiceCreationCommand(DataModel model, IWebService ws, String project) {
        this.model = model;
        this.ws = ws;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        String serviceClass = this.ws.getWebServiceInfo().getImplURL();
        try {
            String workspaceDirectory = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            String currentDynamicWebProjectDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)this.model.getWebProjectName());
            String matadataDir = FileUtils.addAnotherNodeToPath((String)workspaceDirectory, (String)".metadata");
            String matadataPluginsDir = FileUtils.addAnotherNodeToPath((String)matadataDir, (String)".plugins");
            String matadataAxis2Dir = FileUtils.addAnotherNodeToPath((String)matadataPluginsDir, (String)"org.eclipse.jst.ws.axis2");
            String webservicesDir = FileUtils.addAnotherNodeToPath((String)matadataAxis2Dir, (String)"webservices");
            this.model.setPathToWebServicesTempDir(webservicesDir);
            String serviceName = CommonUtils.classNameFromQualifiedName(serviceClass);
            String servicesDirectory = FileUtils.addAnotherNodeToPath((String)webservicesDir, (String)serviceName);
            String serviceXMLDirectory = FileUtils.addAnotherNodeToPath((String)servicesDirectory, (String)"META-INF");
            FileUtils.createDirectorys((String)servicesDirectory);
            FileUtils.createDirectorys((String)serviceXMLDirectory);
            if (this.model.isGenerateServicesXML()) {
                ServiceXMLCreator serviceXMLCreator = new ServiceXMLCreator(serviceName, serviceClass, null);
                File serviceXMLFile = new File(String.valueOf(serviceXMLDirectory) + File.separator + "services.xml");
                FileWriter serviceXMLFileWriter = new FileWriter(serviceXMLFile, false);
                BufferedWriter writer = new BufferedWriter(serviceXMLFileWriter);
                writer.write(serviceXMLCreator.toString());
                writer.close();
            } else {
                String pathToServicesXML = this.model.getPathToServicesXML();
                if (pathToServicesXML == null) {
                    status = StatusUtils.errorStatus((String)Axis2CreationUIMessages.ERROR_INVALID_SERVICES_XML);
                    environment.getStatusHandler().reportError(status);
                } else {
                    File serviceXMLFile = new File(pathToServicesXML);
                    File targetServicesXMLFile = new File(String.valueOf(serviceXMLDirectory) + File.separator + "services.xml");
                    FileUtils.copy((File)serviceXMLFile, (File)targetServicesXMLFile);
                }
            }
            String defaultClassesSubDirectory = "build" + File.separator + "classes";
            String classesDirectory = String.valueOf(currentDynamicWebProjectDir) + File.separator + defaultClassesSubDirectory;
            FileUtils.copyDirectory((File)new File(classesDirectory), (File)new File(servicesDirectory));
        }
        catch (IOException e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2CreationUIMessages.ERROR_INVALID_FILE_READ_WRITEL, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)Axis2CreationUIMessages.ERROR_INVALID_SERVICE_CREATION, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            environment.getStatusHandler().reportError(status);
        }
        return status;
    }
}

