/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.wst.xsd.ui.internal.actions.MoveXSDElementAction;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDElementDeclarationAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CompartmentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ComplexTypeEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.StructureEditPart;
import org.eclipse.wst.xsd.ui.internal.commands.BaseDragAndDropCommand;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupDefinitionReferenceEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDGroupsForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.figures.GenericGroupFigure;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;

public class XSDElementDragAndDropCommand
extends BaseDragAndDropCommand {
    protected ModelGroupEditPart topMostGroup;

    public XSDElementDragAndDropCommand(EditPartViewer viewer, ChangeBoundsRequest request, GraphicalEditPart target, XSDBaseFieldEditPart itemToDrag, Point location) {
        super(viewer, request);
        this.target = target;
        this.itemToDrag = itemToDrag;
        this.location = location;
        this.setup();
    }

    protected void setup() {
        this.canExecute = false;
        if (this.target instanceof ModelGroupEditPart) {
            this.parentEditPart = (ModelGroupEditPart)this.target;
            if (((GenericGroupFigure)this.parentEditPart.getFigure()).getIconFigure().getBounds().contains(this.location)) {
                this.xsdComponentToDrag = (XSDConcreteComponent)((XSDElementDeclarationAdapter)this.itemToDrag.getModel()).getTarget();
                this.action = new MoveXSDElementAction(((ModelGroupEditPart)this.target).getXSDModelGroup(), this.xsdComponentToDrag, null, null);
                this.canExecute = this.action.canMove();
            }
        } else if (this.target instanceof BaseFieldEditPart) {
            this.targetSpacesList = new ArrayList();
            List targetEditPartSiblings = this.calculateFieldEditParts();
            this.calculateModelGroupList();
            this.doDrop(targetEditPartSiblings, (GraphicalEditPart)this.itemToDrag);
        }
    }

    protected void doDrop(List siblings, GraphicalEditPart movingEditPart) {
        this.commonSetup(siblings, movingEditPart);
        if (this.previousRefComponent instanceof XSDElementDeclaration && this.nextRefComponent instanceof XSDElementDeclaration) {
            XSDModelGroup modelGroup = (XSDModelGroup)((XSDElementDeclaration)this.previousRefComponent).getContainer().getContainer();
            if (this.parentEditPart != null) {
                modelGroup = ((ModelGroupEditPart)this.parentEditPart).getXSDModelGroup();
            }
            this.action = new MoveXSDElementAction(modelGroup, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
        } else if (this.previousRefComponent == null && this.nextRefComponent instanceof XSDElementDeclaration) {
            if (this.closerSibling == ABOVE_IS_CLOSER) {
                if (this.leftSiblingEditPart == null) {
                    this.action = new MoveXSDElementAction(this.topMostGroup.getXSDModelGroup(), this.xsdComponentToDrag, null, null, false);
                } else if (this.parentEditPart != null) {
                    this.action = new MoveXSDElementAction(((ModelGroupEditPart)this.parentEditPart).getXSDModelGroup(), this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
                }
            } else {
                XSDModelGroup modelGroup = (XSDModelGroup)((XSDElementDeclaration)this.nextRefComponent).getContainer().getContainer();
                this.action = new MoveXSDElementAction(modelGroup, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent);
            }
        } else if (this.previousRefComponent instanceof XSDElementDeclaration && this.nextRefComponent == null) {
            XSDModelGroup modelGroup = (XSDModelGroup)((XSDElementDeclaration)this.previousRefComponent).getContainer().getContainer();
            if (this.parentEditPart != null) {
                modelGroup = ((ModelGroupEditPart)this.parentEditPart).getXSDModelGroup();
            }
            this.action = this.closerSibling == ABOVE_IS_CLOSER ? new MoveXSDElementAction(modelGroup, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent) : (this.rightSiblingEditPart == null ? new MoveXSDElementAction(this.topMostGroup.getXSDModelGroup(), this.xsdComponentToDrag, null, null, true) : new MoveXSDElementAction(modelGroup, this.xsdComponentToDrag, this.previousRefComponent, this.nextRefComponent));
        }
        if (this.action != null) {
            this.canExecute = this.action.canMove();
        }
    }

    protected boolean handleFirstAndLastDropTargets(int index, List siblings) {
        int siblingYLocation;
        boolean isHandled = false;
        int pointerYLocation = this.location.y;
        if (index == 0 && siblings.size() > 0) {
            this.leftSiblingEditPart = null;
            this.rightSiblingEditPart = (GraphicalEditPart)siblings.get(0);
            siblingYLocation = this.getZoomedBounds((Rectangle)this.rightSiblingEditPart.getFigure().getBounds()).getCenter().y;
            this.closerSibling = BELOW_IS_CLOSER;
            if (Math.abs(pointerYLocation - siblingYLocation) > this.getZoomedBounds((Rectangle)this.rightSiblingEditPart.getFigure().getBounds()).height / 4) {
                isHandled = true;
                this.parentEditPart = this.topMostGroup;
                if (this.topMostGroup != null) {
                    this.closerSibling = ABOVE_IS_CLOSER;
                }
            }
        }
        if (index > 0 && index == siblings.size()) {
            this.leftSiblingEditPart = (GraphicalEditPart)siblings.get(index - 1);
            siblingYLocation = this.getZoomedBounds((Rectangle)this.leftSiblingEditPart.getFigure().getBounds()).getCenter().y;
            if (Math.abs(pointerYLocation - siblingYLocation) > this.getZoomedBounds((Rectangle)this.leftSiblingEditPart.getFigure().getBounds()).height / 4) {
                isHandled = true;
                this.parentEditPart = this.topMostGroup;
                if (this.topMostGroup != null) {
                    this.closerSibling = BELOW_IS_CLOSER;
                }
            }
        }
        return isHandled;
    }

    protected void calculateModelGroupList() {
        GraphicalEditPart editPart = this.target;
        while (editPart != null) {
            if (editPart instanceof ModelGroupEditPart) {
                this.getModelGroupEditParts((ModelGroupEditPart)editPart);
            } else if (editPart instanceof ComplexTypeEditPart || editPart instanceof StructureEditPart) {
                boolean foundTop = false;
                List list = editPart.getChildren();
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Object child = i.next();
                    if (!(child instanceof CompartmentEditPart)) continue;
                    List compartmentList = ((CompartmentEditPart)child).getChildren();
                    Iterator it = compartmentList.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof XSDGroupsForAnnotationEditPart)) continue;
                        XSDGroupsForAnnotationEditPart groups = (XSDGroupsForAnnotationEditPart)obj;
                        List groupList = groups.getChildren();
                        Iterator iter = groupList.iterator();
                        while (iter.hasNext()) {
                            Object groupChild = iter.next();
                            if (!(groupChild instanceof ModelGroupEditPart)) continue;
                            if (!foundTop) {
                                foundTop = true;
                                this.topMostGroup = (ModelGroupEditPart)groupChild;
                            }
                            this.getModelGroupEditParts((ModelGroupEditPart)groupChild);
                        }
                    }
                }
            }
            editPart = editPart.getParent();
        }
    }

    protected List getModelGroupEditParts(ModelGroupEditPart modelGroupEditPart) {
        ArrayList modelGroupList = new ArrayList();
        List list = modelGroupEditPart.getChildren();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof TargetConnectionSpacingFigureEditPart) {
                this.targetSpacesList.add(object);
                continue;
            }
            if (object instanceof ModelGroupDefinitionReferenceEditPart) {
                ModelGroupDefinitionReferenceEditPart groupRef = (ModelGroupDefinitionReferenceEditPart)object;
                List groupRefChildren = groupRef.getChildren();
                Iterator it = groupRefChildren.iterator();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof ModelGroupEditPart)) continue;
                    this.getModelGroupEditParts((ModelGroupEditPart)o);
                }
                continue;
            }
            if (!(object instanceof ModelGroupEditPart)) continue;
            this.getModelGroupEditParts((ModelGroupEditPart)object);
        }
        return modelGroupList;
    }
}

