/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.operations.IToggleSiteOperation;
import org.eclipse.update.operations.OperationsManager;

public class SiteStateAction
extends Action {
    private IConfiguredSite site;
    private Shell shell;

    public SiteStateAction(Shell shell) {
        this.shell = shell;
    }

    public void setSite(IConfiguredSite site) {
        this.site = site;
        boolean state = site.isEnabled();
        this.setText(state ? UpdateUIMessages.SiteStateAction_disableLabel : UpdateUIMessages.SiteStateAction_enableLabel);
    }

    public void run() {
        try {
            if (this.site == null) {
                return;
            }
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)status);
                return;
            }
            boolean oldValue = this.site.isEnabled();
            if (!this.confirm(!oldValue)) {
                return;
            }
            IToggleSiteOperation toggleSiteOperation = OperationsManager.getOperationFactory().createToggleSiteOperation(this.site);
            boolean restartNeeded = toggleSiteOperation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUI.logException(e);
        }
    }

    private boolean confirm(boolean newState) {
        String name = this.site.getSite().getURL().toString();
        String enableMessage = NLS.bind((String)UpdateUIMessages.SiteStateAction_enableMessage, (Object)name);
        String disableMessage = NLS.bind((String)UpdateUIMessages.SiteStateAction_disableMessage, (Object)name);
        String message = newState ? enableMessage : disableMessage;
        return MessageDialog.openConfirm((Shell)this.shell, (String)UpdateUIMessages.SiteStateAction_dialogTitle, (String)message);
    }
}

