/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.RetargetPatchElementDialog;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PreviewPatchPage2
extends WizardPage {
    protected static final String PREVIEWPATCHPAGE_NAME = "PreviewPatchPage";
    final WorkspacePatcher fPatcher;
    private final CompareConfiguration fConfiguration;
    private PatchCompareEditorInput fInput;
    private Combo fStripPrefixSegments;
    private Text fFuzzField;
    private Action fExcludeAction;
    private Action fIncludeAction;
    private Action fIgnoreWhiteSpace;
    private Action fReversePatch;
    private Action fMoveAction;
    protected boolean pageRecalculate = true;

    public PreviewPatchPage2(WorkspacePatcher patcher, CompareConfiguration configuration) {
        super(PREVIEWPATCHPAGE_NAME, PatchMessages.PreviewPatchPage_title, null);
        this.setDescription(PatchMessages.PreviewPatchPage2_8);
        Assert.isNotNull((Object)patcher);
        Assert.isNotNull((Object)configuration);
        this.fPatcher = patcher;
        this.fConfiguration = configuration;
        this.fConfiguration.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("IGNORE_WHITESPACE")) {
                    PreviewPatchPage2.this.rebuildTree();
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)parent);
        this.fInput = new PatchCompareEditorInput(this.getPatcher(), this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                if (this.isShowAll()) {
                    manager.add((IAction)PreviewPatchPage2.this.fIncludeAction);
                }
                manager.add((IAction)PreviewPatchPage2.this.fExcludeAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)PreviewPatchPage2.this.fMoveAction);
            }
        };
        this.buildPatchOptionsGroup(composite);
        try {
            this.fInput.run(null);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Control c = this.fInput.createContents(composite);
        this.initializeActions();
        this.fInput.contributeDiffViewerToolbarItems(this.getContributedActions(), this.getPatcher().isWorkspacePatch());
        c.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
    }

    private void updateEnablements() {
        boolean atLeastOneIsEnabled = false;
        if (this.fInput != null) {
            atLeastOneIsEnabled = this.fInput.hasResultToApply();
        }
        this.setPageComplete(atLeastOneIsEnabled);
    }

    private Action[] getContributedActions() {
        return new Action[]{this.fIgnoreWhiteSpace};
    }

    private void initializeActions() {
        this.fMoveAction = new Action(PatchMessages.PreviewPatchPage2_RetargetAction, null){

            public void run() {
                IStructuredSelection ss;
                Shell shell = PreviewPatchPage2.this.getShell();
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                PatchDiffNode node = null;
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).getFirstElement() instanceof PatchDiffNode) {
                    node = (PatchDiffNode)ss.getFirstElement();
                }
                if (node == null) {
                    return;
                }
                RetargetPatchElementDialog dialog = new RetargetPatchElementDialog(shell, PreviewPatchPage2.this.fPatcher, node);
                int returnCode = dialog.open();
                if (returnCode == 0) {
                    PreviewPatchPage2.this.rebuildTree();
                }
            }
        };
        this.fMoveAction.setToolTipText(PatchMessages.PreviewPatchPage2_RetargetTooltip);
        this.fMoveAction.setEnabled(true);
        this.fInput.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                boolean enable = false;
                if (obj instanceof PatchProjectDiffNode) {
                    enable = true;
                } else if (obj instanceof PatchFileDiffNode) {
                    PatchFileDiffNode node = (PatchFileDiffNode)obj;
                    enable = node.getDiffResult().getDiffProblem();
                } else if (obj instanceof HunkDiffNode) {
                    enable = true;
                }
                PreviewPatchPage2.this.fMoveAction.setEnabled(enable);
            }
        });
        this.fExcludeAction = new Action(PatchMessages.PreviewPatchPage2_0){

            public void run() {
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                if (selection instanceof TreeSelection) {
                    Iterator iter = ((TreeSelection)selection).iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof PatchDiffNode)) continue;
                        PatchDiffNode node = (PatchDiffNode)obj;
                        node.setEnabled(false);
                    }
                }
                PreviewPatchPage2.this.fInput.getViewer().refresh();
            }
        };
        this.fExcludeAction.setEnabled(true);
        this.fIncludeAction = new Action(PatchMessages.PreviewPatchPage2_1){

            public void run() {
                ISelection selection = PreviewPatchPage2.this.fInput.getViewer().getSelection();
                if (selection instanceof TreeSelection) {
                    Iterator iter = ((TreeSelection)selection).iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof PatchDiffNode)) continue;
                        PatchDiffNode node = (PatchDiffNode)obj;
                        node.setEnabled(true);
                    }
                }
                PreviewPatchPage2.this.fInput.getViewer().refresh();
            }
        };
        this.fIncludeAction.setEnabled(true);
        this.fIgnoreWhiteSpace = new Action(PatchMessages.PreviewPatchPage2_IgnoreWSAction, CompareUIPlugin.getImageDescriptor("etool16/ignorews_edit.gif")){

            public void run() {
                try {
                    PreviewPatchPage2.this.getContainer().run(false, true, new IRunnableWithProgress(this){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(PatchMessages.PreviewPatchPage2_IgnoreWhitespace, -1);
                            if (this.this$1.isChecked() != 7.access$0(this.this$1).getPatcher().isIgnoreWhitespace()) {
                                if (PreviewPatchPage2.access$6(7.access$0(this.this$1), PatchMessages.PreviewPatchPage2_2)) {
                                    if (7.access$0(this.this$1).getPatcher().setIgnoreWhitespace(this.this$1.isChecked())) {
                                        7.access$0(this.this$1).getCompareConfiguration().setProperty("IGNORE_WHITESPACE", new Boolean(this.this$1.isChecked()));
                                    }
                                } else {
                                    PreviewPatchPage2.access$7(7.access$0(this.this$1)).setChecked(!this.this$1.isChecked());
                                }
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ PreviewPatchPage2 access$0(7 var0) {
                return var0.PreviewPatchPage2.this;
            }
        };
        this.fIgnoreWhiteSpace.setChecked(false);
        this.fIgnoreWhiteSpace.setToolTipText(PatchMessages.PreviewPatchPage2_IgnoreWSTooltip);
        this.fIgnoreWhiteSpace.setDisabledImageDescriptor(CompareUIPlugin.getImageDescriptor("dtool16/ignorews_edit.gif"));
        this.fReversePatch = new Action(PatchMessages.PreviewPatchPage_ReversePatch_text){

            public void run() {
                try {
                    PreviewPatchPage2.this.getContainer().run(true, true, new IRunnableWithProgress(this){
                        final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(PatchMessages.PreviewPatchPage2_CalculateReverse, -1);
                            if (this.this$1.isChecked() != 9.access$0(this.this$1).getPatcher().isReversed()) {
                                if (PreviewPatchPage2.access$6(9.access$0(this.this$1), PatchMessages.PreviewPatchPage2_3)) {
                                    if (9.access$0(this.this$1).getPatcher().setReversed(this.this$1.isChecked())) {
                                        PreviewPatchPage2.access$0(9.access$0(this.this$1));
                                    }
                                } else {
                                    PreviewPatchPage2.access$8(9.access$0(this.this$1)).setChecked(!this.this$1.isChecked());
                                }
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ PreviewPatchPage2 access$0(9 var0) {
                return var0.PreviewPatchPage2.this;
            }
        };
        this.fReversePatch.setChecked(false);
        this.fReversePatch.setToolTipText(PatchMessages.PreviewPatchPage_ReversePatch_text);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillSegmentCombo();
            this.rebuildTree();
            this.updateEnablements();
        }
    }

    private boolean promptToRebuild(final String promptToConfirm) {
        final Control ctrl = this.getControl();
        final boolean[] result = new boolean[1];
        if (ctrl != null && !ctrl.isDisposed()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        try {
                            PreviewPatchPage2.this.fInput.saveChanges(null);
                        }
                        catch (CoreException e) {
                            CompareUIPlugin.log(e);
                        }
                        result[0] = PreviewPatchPage2.this.fInput.confirmRebuild(promptToConfirm);
                    }
                }
            };
            if (Display.getCurrent() == null) {
                ctrl.getDisplay().syncExec(runnable);
            } else {
                runnable.run();
            }
        }
        return result[0];
    }

    private void rebuildTree() {
        final Control ctrl = this.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!ctrl.isDisposed()) {
                        PreviewPatchPage2.this.fInput.buildTree();
                        PreviewPatchPage2.this.updateEnablements();
                    }
                }
            };
            if (Display.getCurrent() == null) {
                ctrl.getDisplay().syncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private void fillSegmentCombo() {
        if (this.getPatcher().isWorkspacePatch()) {
            this.fStripPrefixSegments.setEnabled(false);
        } else {
            this.fStripPrefixSegments.setEnabled(true);
            int length = 99;
            if (this.fStripPrefixSegments != null && this.pageRecalculate && (length = this.getPatcher().calculatePrefixSegmentCount()) != 99) {
                int k = 1;
                while (k < length) {
                    this.fStripPrefixSegments.add(Integer.toString(k));
                    ++k;
                }
                this.pageRecalculate = false;
            }
        }
    }

    private void buildPatchOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PatchMessages.PreviewPatchPage_PatchOptions_title);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        group.setLayout((Layout)gl);
        group.setLayoutData((Object)new GridData(768));
        this.createStripSegmentCombo(group);
        this.addSpacer((Composite)group);
        this.createFuzzFactorChooser(group);
        this.createReversePatchToggle((Composite)group);
        this.createShowRemovedToggle((Composite)group);
        this.createGenerateRejectsToggle((Composite)group);
        final WorkspacePatcher patcher = this.getPatcher();
        if (this.fStripPrefixSegments != null) {
            this.fStripPrefixSegments.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (patcher.getStripPrefixSegments() != PreviewPatchPage2.this.getStripPrefixSegments() && PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_4) && patcher.setStripPrefixSegments(PreviewPatchPage2.this.getStripPrefixSegments())) {
                        PreviewPatchPage2.this.rebuildTree();
                    }
                }
            });
        }
        this.fFuzzField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (patcher.getFuzz() != PreviewPatchPage2.this.getFuzzFactor()) {
                    if (PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_5)) {
                        if (patcher.setFuzz(PreviewPatchPage2.this.getFuzzFactor())) {
                            PreviewPatchPage2.this.rebuildTree();
                        }
                    } else {
                        PreviewPatchPage2.this.fFuzzField.setText(Integer.toString(patcher.getFuzz()));
                    }
                }
            }
        });
    }

    private void createFuzzFactorChooser(Group group) {
        final WorkspacePatcher patcher = this.getPatcher();
        Composite pair = new Composite((Composite)group, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_FuzzFactor_text);
        l.setToolTipText(PatchMessages.PreviewPatchPage_FuzzFactor_tooltip);
        gd = new GridData(548);
        l.setLayoutData((Object)gd);
        this.fFuzzField = new Text(pair, 2048);
        this.fFuzzField.setText("2");
        gd = new GridData(132);
        gd.widthHint = 30;
        this.fFuzzField.setLayoutData((Object)gd);
        Button b = new Button(pair, 8);
        b.setText(PatchMessages.PreviewPatchPage_GuessFuzz_text);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fuzz;
                if (PreviewPatchPage2.this.promptToRebuild(PatchMessages.PreviewPatchPage2_6) && (fuzz = PreviewPatchPage2.this.guessFuzzFactor(patcher)) >= 0) {
                    PreviewPatchPage2.this.fFuzzField.setText(Integer.toString(fuzz));
                }
            }
        });
        gd = new GridData(4);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = b.computeSize(-1, -1, true);
        gd.widthHint = Math.max(widthHint, minSize.x);
        b.setLayoutData((Object)gd);
    }

    private void createGenerateRejectsToggle(Composite pair) {
        final Button generateRejects = new Button(pair, 32);
        generateRejects.setText(PatchMessages.HunkMergePage_GenerateRejectFile);
        GridData gd = new GridData(548);
        generateRejects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPatchPage2.this.getPatcher().setGenerateRejectFile(generateRejects.getSelection());
            }
        });
        generateRejects.setSelection(false);
        generateRejects.setLayoutData((Object)gd);
    }

    private void createShowRemovedToggle(Composite pair) {
        final Button showRemoved = new Button(pair, 32);
        showRemoved.setText(PatchMessages.PreviewPatchPage2_7);
        GridData gd = new GridData(548);
        showRemoved.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewPatchPage2.this.fInput.setShowAll(showRemoved.getSelection());
                PreviewPatchPage2.this.fInput.updateTree();
            }
        });
        showRemoved.setSelection(this.fInput.isShowAll());
        showRemoved.setLayoutData((Object)gd);
    }

    private void createReversePatchToggle(Composite pair) {
        final Button reversePatch = new Button(pair, 32);
        reversePatch.setText(PatchMessages.PreviewPatchPage_ReversePatch_text);
        GridData gd = new GridData(548);
        reversePatch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PreviewPatchPage2.this.fReversePatch != null) {
                    PreviewPatchPage2.this.fReversePatch.setChecked(reversePatch.getSelection());
                    PreviewPatchPage2.this.fReversePatch.run();
                    if (PreviewPatchPage2.this.fReversePatch.isChecked() != reversePatch.getSelection()) {
                        reversePatch.setSelection(PreviewPatchPage2.this.fReversePatch.isChecked());
                    }
                }
            }
        });
        reversePatch.setSelection(this.getPatcher().isReversed());
        reversePatch.setLayoutData((Object)gd);
    }

    private void createStripSegmentCombo(Group group) {
        WorkspacePatcher patcher = this.getPatcher();
        Composite pair = new Composite((Composite)group, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        pair.setLayout((Layout)gl);
        GridData gd = new GridData(256);
        pair.setLayoutData((Object)gd);
        Label l = new Label(pair, 0);
        l.setText(PatchMessages.PreviewPatchPage_IgnoreSegments_text);
        gd = new GridData(36);
        l.setLayoutData((Object)gd);
        this.fStripPrefixSegments = new Combo(pair, 76);
        int prefixCnt = patcher.getStripPrefixSegments();
        String prefix = Integer.toString(prefixCnt);
        this.fStripPrefixSegments.add(prefix);
        this.fStripPrefixSegments.setText(prefix);
        gd = new GridData(548);
        this.fStripPrefixSegments.setLayoutData((Object)gd);
    }

    private void addSpacer(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(768);
        gd.widthHint = 10;
        label.setLayoutData((Object)gd);
    }

    public int getFuzzFactor() {
        int fuzzFactor = 0;
        if (this.fFuzzField != null) {
            String s = this.fFuzzField.getText();
            try {
                fuzzFactor = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return fuzzFactor;
    }

    public int getStripPrefixSegments() {
        int stripPrefixSegments = 0;
        if (this.fStripPrefixSegments != null) {
            String s = this.fStripPrefixSegments.getText();
            try {
                stripPrefixSegments = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return stripPrefixSegments;
    }

    private int guessFuzzFactor(final WorkspacePatcher patcher) {
        final int[] result = new int[]{-1};
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    result[0] = patcher.guessFuzzFactor(monitor);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return result[0];
    }

    public void ensureContentsSaved() {
        try {
            this.fInput.saveChanges((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    public WorkspacePatcher getPatcher() {
        return this.fPatcher;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fConfiguration;
    }

    static /* synthetic */ Action access$7(PreviewPatchPage2 previewPatchPage2) {
        return previewPatchPage2.fIgnoreWhiteSpace;
    }
}

