/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPElementLabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenProjectAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private static final int EMPTY_SELECTION = 1;
    private static final int ELEMENT_SELECTION = 2;
    private int fMode;
    private OpenResourceAction fWorkbenchAction;

    public OpenProjectAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.fWorkbenchAction = new OpenResourceAction(iWorkbenchSite.getShell());
        this.setText(this.fWorkbenchAction.getText());
        this.setToolTipText(this.fWorkbenchAction.getToolTipText());
        this.setEnabled(this.hasCloseProjects());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.open_project_action");
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        this.fWorkbenchAction.resourceChanged(iResourceChangeEvent);
        switch (this.fMode) {
            case 2: {
                this.setEnabled(this.fWorkbenchAction.isEnabled());
                break;
            }
            case 1: {
                this.internalResourceChanged(iResourceChangeEvent);
            }
        }
    }

    private void internalResourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta != null) {
            IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0) {
                    this.setEnabled(this.hasCloseProjects());
                    return;
                }
                ++n;
            }
        }
    }

    public void selectionChanged(ISelection iSelection) {
        this.setEnabled(this.hasCloseProjects());
        this.fMode = 1;
    }

    public void run(ISelection iSelection) {
        this.internalRun();
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            this.setEnabled(this.hasCloseProjects());
            this.fMode = 1;
            return;
        }
        this.fWorkbenchAction.selectionChanged(iStructuredSelection);
        this.setEnabled(this.fWorkbenchAction.isEnabled());
        this.fMode = 2;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            this.internalRun();
            return;
        }
        this.fWorkbenchAction.run();
    }

    private void internalRun() {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new PHPElementLabelProvider());
        elementListSelectionDialog.setTitle(PHPUIMessages.OpenProjectAction_dialog_title);
        elementListSelectionDialog.setMessage(PHPUIMessages.OpenProjectAction_dialog_message);
        elementListSelectionDialog.setElements(this.getClosedProjects());
        elementListSelectionDialog.setMultipleSelection(true);
        int n = elementListSelectionDialog.open();
        if (n != 0) {
            return;
        }
        Object[] objectArray = elementListSelectionDialog.getResult();
        IWorkspaceRunnable iWorkspaceRunnable = this.createRunnable(objectArray);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), PHPUIMessages.OpenProjectAction_dialog_title, PHPUIMessages.OpenProjectAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IWorkspaceRunnable createRunnable(final Object[] objectArray) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask("", objectArray.length);
                MultiStatus multiStatus = null;
                int n = 0;
                while (n < objectArray.length) {
                    IProject iProject = (IProject)objectArray[n];
                    try {
                        iProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    catch (CoreException coreException) {
                        if (multiStatus == null) {
                            multiStatus = new MultiStatus("org.eclipse.php.ui", 4, PHPUIMessages.OpenProjectAction_error_message, (Throwable)coreException);
                        }
                        multiStatus.merge(coreException.getStatus());
                    }
                    ++n;
                }
                iProgressMonitor.done();
                if (multiStatus != null) {
                    throw new CoreException(multiStatus);
                }
            }
        };
    }

    private Object[] getClosedProjects() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> arrayList = new ArrayList<IProject>(5);
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (!iProject.isOpen()) {
                arrayList.add(iProject);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private boolean hasCloseProjects() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!iProjectArray[n].isOpen()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

