/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterPHP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StructuredTextFoldingProviderPHP
implements IStructuredTextFoldingProvider,
IProjectionListener,
ITextInputListener,
ModelListener,
IPropertyChangeListener {
    private IDocument fDocument;
    private ProjectionViewer fViewer;
    private boolean fProjectionNeedsToBeEnabled = false;
    private static final int MAX_CHILDREN = 10;
    private static final int MAX_SIBLINGS = 1000;

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.projectionDisabled();
        this.fDocument = this.fViewer.getDocument();
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML;
            ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactoryPHP(true);
            if (projectionModelNodeAdapterFactoryPHP != null) {
                projectionModelNodeAdapterFactoryPHP.addProjectionViewer(this.fViewer);
            }
            if ((projectionModelNodeAdapterFactoryHTML = this.getAdapterFactoryHTML(true)) != null) {
                projectionModelNodeAdapterFactoryHTML.addProjectionViewer(this.fViewer);
            }
            this.addAllAdapters();
        }
        this.fProjectionNeedsToBeEnabled = false;
    }

    public void install(ProjectionViewer projectionViewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.fViewer = projectionViewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
        this.fViewer.addTextInputListener((ITextInputListener)this);
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        this.enablePropertyListener();
    }

    private boolean isInstalled() {
        return this.fViewer != null;
    }

    public void projectionDisabled() {
        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML;
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactoryPHP(false);
        if (projectionModelNodeAdapterFactoryPHP != null) {
            projectionModelNodeAdapterFactoryPHP.removeProjectionViewer(this.fViewer);
        }
        if ((projectionModelNodeAdapterFactoryHTML = this.getAdapterFactoryHTML(false)) != null) {
            projectionModelNodeAdapterFactoryHTML.removeProjectionViewer(this.fViewer);
        }
        if (this.fViewer.getProjectionAnnotationModel() != null) {
            this.fViewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.removeAllAdapters();
        this.fDocument = null;
        this.fProjectionNeedsToBeEnabled = false;
    }

    private void disablePropertyListener() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void projectionEnabled() {
        this.initialize();
    }

    private void enablePropertyListener() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void removeAdapterFromNodeAndChildren(Node node, int n) {
        if (node instanceof INodeNotifier) {
            INodeAdapter iNodeAdapter;
            INodeNotifier iNodeNotifier = (INodeNotifier)node;
            INodeAdapter iNodeAdapter2 = iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
            if (iNodeAdapter2 != null) {
                iNodeNotifier.removeAdapter(iNodeAdapter2);
            }
            if ((iNodeAdapter = iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class)) != null) {
                iNodeNotifier.removeAdapter(iNodeAdapter);
            }
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                Node node3 = node2;
                node2 = node3.getNextSibling();
                this.removeAdapterFromNodeAndChildren(node3, n + 1);
            }
        }
    }

    private void removeAllAdapters() {
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                IndexedRegion indexedRegion;
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null && (indexedRegion = iStructuredModel.getIndexedRegion(0)) instanceof Node) {
                    Node node = (Node)indexedRegion;
                    while (node != null) {
                        Node node2 = node;
                        node = node2.getNextSibling();
                        this.removeAdapterFromNodeAndChildren(node2, 0);
                    }
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        if (this.fDocument != null && this.fDocument != iDocument2) {
            this.projectionDisabled();
            this.fProjectionNeedsToBeEnabled = true;
        }
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        if (this.fProjectionNeedsToBeEnabled && this.fDocument == null && iDocument2 != null) {
            this.projectionEnabled();
            this.fProjectionNeedsToBeEnabled = false;
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer.removeTextInputListener((ITextInputListener)this);
            this.fViewer = null;
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
            this.disablePropertyListener();
        }
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        if (this.fDocument == null) {
            return;
        }
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
        assert (iStructuredModel instanceof DOMModelForPHP) : "Incompatible model or null";
        try {
            IDOMDocument iDOMDocument;
            INodeAdapter iNodeAdapter;
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            if (dOMModelForPHP != null && dOMModelForPHP.getFileData() == pHPFileData && (iNodeAdapter = (iDOMDocument = dOMModelForPHP.getDocument()).getAdapterFor(ProjectionModelNodeAdapterPHP.class)) != null) {
                assert (iNodeAdapter instanceof ProjectionModelNodeAdapterPHP) : "wrong adapter";
                ProjectionModelNodeAdapterPHP projectionModelNodeAdapterPHP = (ProjectionModelNodeAdapterPHP)iNodeAdapter;
                projectionModelNodeAdapterPHP.updateAdapter((Node)iDOMDocument);
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactoryPHP(false);
        if (projectionModelNodeAdapterFactoryPHP != null && ("foldClasses".equals(string) || "foldClasses".equals(string) || "foldPHPDoc".equals(string))) {
            projectionModelNodeAdapterFactoryPHP.initializePreference();
            this.initialize();
        }
    }

    private void addAdapterToNodeAndChildrenHTML(Node node, int n) {
        if (node instanceof INodeNotifier && n < 10) {
            INodeNotifier iNodeNotifier = (INodeNotifier)node;
            ProjectionModelNodeAdapterHTML projectionModelNodeAdapterHTML = (ProjectionModelNodeAdapterHTML)iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterHTML.class);
            if (projectionModelNodeAdapterHTML != null) {
                projectionModelNodeAdapterHTML.updateAdapter(node);
            } else {
                iNodeNotifier.getAdapterFor(ProjectionModelNodeAdapterHTML.class);
            }
            int n2 = 0;
            Node node2 = node.getFirstChild();
            while (node2 != null && n2 < 1000) {
                Node node3 = node2;
                node2 = node3.getNextSibling();
                this.addAdapterToNodeAndChildrenHTML(node3, n + 1);
                ++n2;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addAllAdapters() {
        System.currentTimeMillis();
        if (this.fDocument == null) return;
        IStructuredModel iStructuredModel = null;
        try {
            block9: {
                Node node;
                int n;
                block8: {
                    iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                    if (iStructuredModel == null) return;
                    IndexedRegion indexedRegion = iStructuredModel.getIndexedRegion(0);
                    if (indexedRegion == null) {
                        assert (iStructuredModel instanceof IDOMModel);
                        indexedRegion = ((IDOMModel)iStructuredModel).getDocument();
                    }
                    if (!(indexedRegion instanceof Node)) return;
                    n = 0;
                    node = (Node)indexedRegion;
                    this.addAdapterToDocumentPHP(node.getOwnerDocument());
                    if (!true) break block8;
                    if (node == null) return;
                    if (n >= 1000) break block9;
                }
                do {
                    Node node2 = node;
                    node = node2.getNextSibling();
                    this.addAdapterToNodeAndChildrenHTML(node2, 0);
                    ++n;
                    if (node == null) return;
                } while (n < 1000);
            }
            return;
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    private void addAdapterToDocumentPHP(Document document) {
        if (document == null) {
            return;
        }
        INodeNotifier iNodeNotifier = (INodeNotifier)document;
        ProjectionModelNodeAdapterPHP projectionModelNodeAdapterPHP = (ProjectionModelNodeAdapterPHP)iNodeNotifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
        if (projectionModelNodeAdapterPHP != null) {
            projectionModelNodeAdapterPHP.updateAdapter(document, this.fViewer);
        } else {
            iNodeNotifier.getAdapterFor(ProjectionModelNodeAdapterPHP.class);
        }
    }

    private ProjectionModelNodeAdapterFactoryHTML getAdapterFactoryHTML(boolean bl) {
        System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML = null;
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null) {
                    FactoryRegistry factoryRegistry = iStructuredModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterHTML.class) && bl) {
                        ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML2 = new ProjectionModelNodeAdapterFactoryHTML();
                        factoryRegistry.addFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryHTML2);
                        IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
                        IDOMDocument iDOMDocument = iDOMModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)iDOMDocument).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryHTML2);
                        }
                    }
                    projectionModelNodeAdapterFactoryHTML = (ProjectionModelNodeAdapterFactoryHTML)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterHTML.class);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        return projectionModelNodeAdapterFactoryHTML;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactoryPHP(boolean bl) {
        System.currentTimeMillis();
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = null;
        if (this.fDocument != null) {
            IStructuredModel iStructuredModel = null;
            try {
                iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
                if (iStructuredModel != null) {
                    FactoryRegistry factoryRegistry = iStructuredModel.getFactoryRegistry();
                    if (!factoryRegistry.contains(ProjectionModelNodeAdapterPHP.class) && bl) {
                        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP2 = new ProjectionModelNodeAdapterFactoryPHP();
                        factoryRegistry.addFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryPHP2);
                        IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
                        IDOMDocument iDOMDocument = iDOMModel.getDocument();
                        PropagatingAdapter propagatingAdapter = (PropagatingAdapter)((INodeNotifier)iDOMDocument).getAdapterFor(PropagatingAdapter.class);
                        if (propagatingAdapter != null) {
                            propagatingAdapter.addAdaptOnCreateFactory((INodeAdapterFactory)projectionModelNodeAdapterFactoryPHP2);
                        }
                    }
                    projectionModelNodeAdapterFactoryPHP = (ProjectionModelNodeAdapterFactoryPHP)factoryRegistry.getFactoryFor(ProjectionModelNodeAdapterPHP.class);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        return projectionModelNodeAdapterFactoryPHP;
    }
}

