/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.treecontent.IncludeModelPathRootConverter;
import org.eclipse.php.internal.ui.treecontent.IncludesNode;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class IncludePathTreeContent
implements IPHPTreeContentProvider {
    private static final String INCLUDE_PATHS_NODE_ID = "org.eclipse.php.ui.treecontent.IncludesNode";
    private static final String INCLUDE_PATHS_NODE_NAME = "Include Paths";
    static final IPath INCLUDE_PATHS_ROOT_PATH = new Path("\u0000IncludePaths");
    static final ElementTree includePathTree = new ElementTree();
    private static final Map<IProject, IncludesNode> projectNodes = new HashMap<IProject, IncludesNode>();
    private TreeViewer treeViewer;

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        return object instanceof PHPTreeNode;
    }

    public synchronized Object[] getChildren(Object object) {
        if (object instanceof IProject) {
            return this.getProjectChildren((IProject)object);
        }
        if (object instanceof PHPTreeNode && INCLUDE_PATHS_NODE_ID.equals(((PHPTreeNode)object).getId())) {
            return IncludePathTreeContent.getTreeNodeChildren((PHPTreeNode)object);
        }
        if (object instanceof PHPIncludePathModel || object instanceof PhpModelProxy) {
            return IncludePathTreeContent.getIncludeModelChildren((IPhpModel)object);
        }
        if (object instanceof IFolder) {
            return IncludePathTreeContent.getFolderChildren((IFolder)object);
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object object) {
        if (includePathTree == null) {
            return null;
        }
        if (object instanceof PHPFileData) {
            return IncludePathTreeContent.getFileParent((PHPFileData)object);
        }
        if (object instanceof IFolder) {
            return IncludePathTreeContent.getFolderParent((IFolder)object);
        }
        if (object instanceof PHPIncludePathModel) {
            PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
            return IncludePathTreeContent.getIncludeModelParent(pHPIncludePathModel);
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public void dispose() {
        for (Map.Entry<IProject, IncludesNode> entry : projectNodes.entrySet()) {
            IProject iProject = entry.getKey();
            IncludesNode includesNode = entry.getValue();
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)includesNode);
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            pHPProjectOptions.removeOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        }
    }

    public String getText(Object object) {
        if (object instanceof PHPTreeNode) {
            return this.getNodeText((PHPTreeNode)object);
        }
        if (object instanceof PHPIncludePathModel) {
            return this.getIncludeModelText((PHPIncludePathModel)object);
        }
        if (object instanceof PhpModelProxy) {
            PhpModelProxy phpModelProxy = (PhpModelProxy)object;
            return this.getProjectModelText(phpModelProxy);
        }
        if (object instanceof PHPFileData) {
            return this.getFileText((PHPFileData)object);
        }
        return null;
    }

    public Image getImage(Object object) {
        if (object instanceof PHPTreeNode) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return pHPTreeNode.getImage();
        }
        return null;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private static void createFileNode(CodeData codeData, IPath iPath) {
        includePathTree.createElement(iPath, (Object)codeData);
    }

    private IncludesNode createIncludePathsNode(IProject iProject) {
        Image image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_LIBRARY);
        IncludesNode includesNode = new IncludesNode(INCLUDE_PATHS_NODE_NAME, image, INCLUDE_PATHS_NODE_ID, iProject, this);
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)includesNode);
        projectNodes.put(iProject, includesNode);
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        pHPProjectOptions.addOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        return includesNode;
    }

    private static void createIncludePathTree(IPath iPath, IPhpModel iPhpModel) {
        CodeData[] codeDataArray;
        IPath iPath2 = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel);
        CodeData[] codeDataArray2 = codeDataArray = iPhpModel.getFileDatas();
        int n = codeDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData = codeDataArray2[n2];
            String string = codeData.getName();
            Path path = new Path(string);
            IPath iPath3 = iPath.append(path.removeFirstSegments(iPath2.segmentCount()));
            if (!includePathTree.includes(iPath3)) {
                IPath iPath4 = IncludePathTreeContent.findExistingIncludePathFolderNode(iPath, iPath3);
                IncludePathTreeContent.createMissingIncludePathFolderNodes(iPath3, iPath4);
                IncludePathTreeContent.createFileNode(codeData, iPath3);
            }
            ++n2;
        }
    }

    private static void createMissingIncludePathFolderNodes(IPath iPath, IPath iPath2) {
        IPath iPath3 = iPath2;
        do {
            iPath3 = iPath3.append(iPath.segment(iPath3.segmentCount()));
            includePathTree.createElement(iPath3, (Object)((Workspace)ResourcesPlugin.getWorkspace()).newResource(iPath3, 2));
        } while (iPath3.segmentCount() < iPath.segmentCount());
    }

    private static IPath findExistingIncludePathFolderNode(IPath iPath, IPath iPath2) {
        IPath iPath3 = iPath2;
        while ((iPath3 = iPath3.removeLastSegments(1)).segmentCount() > iPath.segmentCount() && !includePathTree.includes(iPath3)) {
        }
        return iPath3;
    }

    static IPhpModel findModel(PHPFileData pHPFileData) {
        IncludePathTreeContent.validateRoot();
        IPath[] iPathArray = includePathTree.getChildren(INCLUDE_PATHS_ROOT_PATH);
        IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
        Path path = new Path(pHPFileData.getName());
        String string = path.toOSString();
        if (iResource != null) {
            IPath iPath = iResource.getLocation();
            string = iPath != null ? iPath.toOSString() : iResource.getLocationURI().toString();
        }
        int n = 0;
        while (n < iPathArray.length) {
            IPath iPath;
            IPhpModel iPhpModel = IncludeModelPathRootConverter.from(iPathArray[n].segment(1));
            if (iPhpModel != null && (iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel)) != null && (string.startsWith(iPath.toOSString()) || path.isAbsolute() && path.segment(0).equals(iPhpModel.getID()))) {
                return iPhpModel;
            }
            ++n;
        }
        return null;
    }

    private static Object[] getTreeChildrenElements(IPath iPath) {
        IPath[] iPathArray = includePathTree.getChildren(iPath);
        Object[] objectArray = new Object[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            objectArray[n] = includePathTree.getElementData(iPathArray[n]);
            ++n;
        }
        return objectArray;
    }

    private static Object[] getFolderChildren(IFolder iFolder) {
        IPath iPath = iFolder.getFullPath();
        if (includePathTree.includes(iFolder.getFullPath())) {
            return IncludePathTreeContent.getPathChildren(iPath);
        }
        return NO_CHILDREN;
    }

    private static Object[] getIncludeModelChildren(IPhpModel iPhpModel) {
        IPath iPath = INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString(iPhpModel));
        if (!includePathTree.includes(iPath)) {
            IncludePathTreeContent.validateRoot();
            includePathTree.createElement(iPath, (Object)iPhpModel);
        }
        return IncludePathTreeContent.getPathChildren(iPath);
    }

    private static Object getIncludeModelParent(PHPIncludePathModel pHPIncludePathModel) {
        IPath iPath = INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString((IPhpModel)pHPIncludePathModel));
        if (includePathTree.includes(iPath)) {
            for (IncludesNode includesNode : projectNodes.values()) {
                Object[] objectArray = IncludePathTreeContent.getTreeNodeChildren(includesNode);
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] == pHPIncludePathModel) {
                        return includesNode;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    private static Object getFolderParent(IFolder iFolder) {
        IPath iPath = iFolder.getFullPath();
        if (includePathTree.includes(iPath)) {
            return includePathTree.getElementData(iPath.removeLastSegments(1));
        }
        return null;
    }

    private static Object getFileParent(PHPFileData pHPFileData) {
        String string = pHPFileData.getName();
        Path path = new Path(string);
        if (!includePathTree.includes(INCLUDE_PATHS_ROOT_PATH)) {
            return null;
        }
        IPath[] iPathArray = includePathTree.getChildren(INCLUDE_PATHS_ROOT_PATH);
        int n = 0;
        while (n < iPathArray.length) {
            IPath iPath;
            IPath iPath2 = PHPModelUtil.getIncludeModelLocation((IPhpModel)((PHPIncludePathModel)includePathTree.getElementData(iPathArray[n])));
            if (string.startsWith(iPath2.toOSString()) && includePathTree.includes(iPath = iPathArray[n].append(path.removeFirstSegments(iPath2.segmentCount())))) {
                IPath iPath3 = iPath.removeLastSegments(1);
                return includePathTree.getElementData(iPath3);
            }
            ++n;
        }
        return null;
    }

    private static Object[] getPathChildren(IPath iPath) {
        IPath iPath2 = iPath.uptoSegment(2);
        if (!includePathTree.includes(iPath2)) {
            return NO_CHILDREN;
        }
        Object object = includePathTree.getElementData(iPath2);
        if (!(object instanceof PHPIncludePathModel) && !(object instanceof PhpModelProxy)) {
            return NO_CHILDREN;
        }
        IncludePathTreeContent.createIncludePathTree(iPath2, (IPhpModel)object);
        return IncludePathTreeContent.getTreeChildrenElements(iPath);
    }

    private Object[] getProjectChildren(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        if (pHPProjectOptions != null) {
            return new Object[]{this.getTreeNode(iProject)};
        }
        return NO_CHILDREN;
    }

    private String getProjectModelText(PhpModelProxy phpModelProxy) {
        return phpModelProxy.getID();
    }

    private String getNodeText(PHPTreeNode pHPTreeNode) {
        return pHPTreeNode.getText();
    }

    private String getFileText(PHPFileData pHPFileData) {
        IPath[] iPathArray = includePathTree.getChildren(includePathTree.getRoot());
        int n = 0;
        while (n < iPathArray.length) {
            PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)includePathTree.getElementData(iPathArray[n]);
            IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)pHPIncludePathModel);
            if (pHPFileData.getName().startsWith(iPath.toOSString())) {
                return new Path(pHPFileData.getName()).lastSegment();
            }
            ++n;
        }
        return null;
    }

    private String getIncludeModelText(PHPIncludePathModel pHPIncludePathModel) {
        String string = pHPIncludePathModel.getID();
        IPath iPath = IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID());
        if (iPath != null) {
            return String.valueOf(string) + " (" + IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID()).toOSString() + ")";
        }
        return string;
    }

    private IncludesNode getTreeNode(IProject iProject) {
        Object[] objectArray;
        IncludesNode includesNode = projectNodes.get(iProject);
        if (includesNode == null) {
            includesNode = this.createIncludePathsNode(iProject);
        }
        if ((objectArray = IncludePathTreeContent.getTreeNodeChildren(includesNode)).length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                IncludePathTreeContent.getIncludeModelChildren((IPhpModel)objectArray[n]);
                ++n;
            }
        }
        return includesNode;
    }

    private static Object[] getTreeNodeChildren(PHPTreeNode pHPTreeNode) {
        IProject iProject = null;
        for (Map.Entry<IProject, IncludesNode> pHPProjectModel2 : projectNodes.entrySet()) {
            if (pHPProjectModel2.getValue() != pHPTreeNode) continue;
            iProject = pHPProjectModel2.getKey();
            break;
        }
        if (iProject == null) {
            return NO_CHILDREN;
        }
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel == null) {
            return NO_CHILDREN;
        }
        PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel("CompositeIncludePathModel");
        if (pHPIncludePathModelManager == null) {
            return NO_CHILDREN;
        }
        IPhpModel[] iPhpModelArray = pHPIncludePathModelManager.listModels();
        ArrayList<IPhpModel> arrayList = new ArrayList<IPhpModel>(iPhpModelArray.length);
        int n = 0;
        while (n < iPhpModelArray.length) {
            IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModelArray[n]);
            if (iPath != null) {
                arrayList.add(iPhpModelArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    private static void validateRoot() {
        if (!includePathTree.includes(INCLUDE_PATHS_ROOT_PATH)) {
            includePathTree.createElement(INCLUDE_PATHS_ROOT_PATH, (Object)INCLUDE_PATHS_ROOT_PATH.segment(1));
        }
    }
}

