/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.workingset.OthersWorkingSetUpdater;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class WorkingSetModel {
    public static final String CHANGE_WORKING_SET_MODEL_CONTENT = "workingSetModelChanged";
    public static final IElementComparer COMPARER = new WorkingSetComparar();
    private static final String TAG_LOCAL_WORKING_SET_MANAGER = "localWorkingSetManager";
    private static final String TAG_ACTIVE_WORKING_SET = "activeWorkingSet";
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String TAG_CONFIGURED = "configured";
    private ILocalWorkingSetManager fLocalWorkingSetManager;
    private List fActiveWorkingSets;
    private ListenerList fListeners;
    private IPropertyChangeListener fWorkingSetManagerListener;
    private OthersWorkingSetUpdater fOthersWorkingSetUpdater;
    private ElementMapper fElementMapper = new ElementMapper();
    private boolean fConfigured;

    private void initialize(IMemento iMemento) {
        if (iMemento == null) {
            this.fLocalWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
            this.addListenersToWorkingSetManagers();
            this.fActiveWorkingSets = new ArrayList(2);
            IWorkingSet iWorkingSet = this.fLocalWorkingSetManager.createWorkingSet(PHPUIMessages.WorkingSetModel_others_name, new IAdaptable[0]);
            iWorkingSet.setId("org.eclipse.php.ui.OthersWorkingSet");
            this.fLocalWorkingSetManager.addWorkingSet(iWorkingSet);
            this.fActiveWorkingSets.add(iWorkingSet);
        } else {
            this.restoreState(iMemento);
        }
        if (this.fOthersWorkingSetUpdater != null) {
            this.fOthersWorkingSetUpdater.init(this);
        }
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
    }

    public WorkingSetModel() {
        this.initialize(null);
    }

    public WorkingSetModel(IMemento iMemento) {
        this.initialize(iMemento);
    }

    private void addListenersToWorkingSetManagers() {
        this.fListeners = new ListenerList();
        this.fWorkingSetManagerListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WorkingSetModel.this.workingSetManagerChanged(propertyChangeEvent);
            }
        };
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetManagerListener);
        this.fLocalWorkingSetManager.addPropertyChangeListener(this.fWorkingSetManagerListener);
    }

    public void dispose() {
        if (this.fWorkingSetManagerListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.dispose();
            this.fWorkingSetManagerListener = null;
        }
    }

    public Object[] getChildren(IWorkingSet iWorkingSet) {
        return iWorkingSet.getElements();
    }

    public Object getParent(Object object) {
        if (object instanceof IWorkingSet && this.fActiveWorkingSets.contains(object)) {
            return this;
        }
        return this.fElementMapper.getFirstWorkingSet(object);
    }

    public Object[] getAllParents(Object object) {
        if (object instanceof IWorkingSet && this.fActiveWorkingSets.contains(object)) {
            return new Object[]{this};
        }
        return this.fElementMapper.getAllWorkingSets(object).toArray();
    }

    public Object[] addWorkingSets(Object[] objectArray) {
        ArrayList arrayList = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            List list = null;
            list = object instanceof IResource ? this.fElementMapper.getAllWorkingSetsForResource((IResource)object) : this.fElementMapper.getAllWorkingSets(object);
            if (list != null && list.size() > 0) {
                if (arrayList == null) {
                    arrayList = new ArrayList(Arrays.asList(objectArray));
                }
                arrayList.addAll(list);
            }
            ++n;
        }
        if (arrayList == null) {
            return objectArray;
        }
        return arrayList.toArray();
    }

    public boolean needsConfiguration() {
        return !this.fConfigured && this.fActiveWorkingSets.size() == 1 && "org.eclipse.php.ui.OthersWorkingSet".equals(((IWorkingSet)this.fActiveWorkingSets.get(0)).getId());
    }

    public void configured() {
        this.fConfigured = true;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.fListeners.remove((Object)iPropertyChangeListener);
    }

    public IWorkingSet[] getActiveWorkingSets() {
        return this.fActiveWorkingSets.toArray(new IWorkingSet[this.fActiveWorkingSets.size()]);
    }

    public IWorkingSet[] getAllWorkingSets() {
        ArrayList<IWorkingSet> arrayList = new ArrayList<IWorkingSet>();
        arrayList.addAll(this.fActiveWorkingSets);
        IWorkingSet[] iWorkingSetArray = this.fLocalWorkingSetManager.getWorkingSets();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (!arrayList.contains(iWorkingSetArray[n])) {
                arrayList.add(iWorkingSetArray[n]);
            }
            ++n;
        }
        IWorkingSet[] iWorkingSetArray2 = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int n2 = 0;
        while (n2 < iWorkingSetArray2.length) {
            if (!arrayList.contains(iWorkingSetArray2[n2])) {
                arrayList.add(iWorkingSetArray2[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IWorkingSet[arrayList.size()]);
    }

    public void setActiveWorkingSets(IWorkingSet[] iWorkingSetArray) {
        this.fActiveWorkingSets = new ArrayList(Arrays.asList(iWorkingSetArray));
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        if (this.fOthersWorkingSetUpdater != null) {
            this.fOthersWorkingSetUpdater.updateElements();
        }
        this.fireEvent(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET_MODEL_CONTENT, null, null));
    }

    public void saveState(IMemento iMemento) {
        iMemento.putString(TAG_CONFIGURED, Boolean.toString(this.fConfigured));
        this.fLocalWorkingSetManager.saveState(iMemento.createChild(TAG_LOCAL_WORKING_SET_MANAGER));
        Iterator iterator = this.fActiveWorkingSets.iterator();
        while (iterator.hasNext()) {
            IMemento iMemento2 = iMemento.createChild(TAG_ACTIVE_WORKING_SET);
            IWorkingSet iWorkingSet = (IWorkingSet)iterator.next();
            iMemento2.putString(TAG_WORKING_SET_NAME, iWorkingSet.getName());
        }
    }

    private void restoreState(IMemento iMemento) {
        IWorkingSet iWorkingSet;
        String string = iMemento.getString(TAG_CONFIGURED);
        if (string != null) {
            this.fConfigured = Boolean.valueOf(string);
        }
        this.fLocalWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
        this.addListenersToWorkingSetManagers();
        IMemento iMemento2 = iMemento.getChild(TAG_LOCAL_WORKING_SET_MANAGER);
        if (iMemento2 != null) {
            this.fLocalWorkingSetManager.restoreState(iMemento2);
        }
        if ((iWorkingSet = this.getHistoryWorkingSet()) != null) {
            this.fLocalWorkingSetManager.removeWorkingSet(iWorkingSet);
        }
        IMemento[] iMementoArray = iMemento.getChildren(TAG_ACTIVE_WORKING_SET);
        this.fActiveWorkingSets = new ArrayList(iMementoArray.length);
        int n = 0;
        while (n < iMementoArray.length) {
            String string2 = iMementoArray[n].getString(TAG_WORKING_SET_NAME);
            if (string2 != null) {
                IWorkingSet iWorkingSet2 = this.fLocalWorkingSetManager.getWorkingSet(string2);
                if (iWorkingSet2 == null) {
                    iWorkingSet2 = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(string2);
                }
                if (iWorkingSet2 != null) {
                    this.fActiveWorkingSets.add(iWorkingSet2);
                }
            }
            ++n;
        }
    }

    private void workingSetManagerChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("workingSetUpdaterInstalled".equals(string) && propertyChangeEvent.getSource() == this.fLocalWorkingSetManager) {
            IWorkingSetUpdater iWorkingSetUpdater = (IWorkingSetUpdater)propertyChangeEvent.getNewValue();
            if (iWorkingSetUpdater instanceof OthersWorkingSetUpdater) {
                this.fOthersWorkingSetUpdater = (OthersWorkingSetUpdater)iWorkingSetUpdater;
            }
            return;
        }
        if (!this.isAffected(propertyChangeEvent)) {
            return;
        }
        if ("workingSetContentChange".equals(string)) {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getNewValue();
            IAdaptable[] iAdaptableArray = this.fElementMapper.refresh(iWorkingSet);
            if (iAdaptableArray != null) {
                this.fireEvent(propertyChangeEvent);
            }
        } else if ("workingSetRemove".equals(string)) {
            IWorkingSet iWorkingSet = (IWorkingSet)propertyChangeEvent.getOldValue();
            ArrayList arrayList = new ArrayList(this.fActiveWorkingSets);
            arrayList.remove(iWorkingSet);
            this.setActiveWorkingSets(arrayList.toArray(new IWorkingSet[arrayList.size()]));
        } else if ("workingSetNameChange".equals(string)) {
            this.fireEvent(propertyChangeEvent);
        }
    }

    private void fireEvent(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private boolean isAffected(PropertyChangeEvent propertyChangeEvent) {
        if (this.fActiveWorkingSets == null) {
            return false;
        }
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        return object != null && this.fActiveWorkingSets.contains(object) || object2 != null && this.fActiveWorkingSets.contains(object2);
    }

    private IWorkingSet getHistoryWorkingSet() {
        IWorkingSet[] iWorkingSetArray = this.fLocalWorkingSetManager.getWorkingSets();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if ("org.eclipse.php.ui.HistoryWorkingSet".equals(iWorkingSetArray[n].getId())) {
                return iWorkingSetArray[n];
            }
            ++n;
        }
        return null;
    }

    private static class ElementMapper {
        private Map fElementToWorkingSet = new HashMap();
        private Map fWorkingSetToElement = new IdentityHashMap();
        private Map fResourceToWorkingSet = new HashMap();

        private ElementMapper() {
        }

        public void clear() {
            this.fElementToWorkingSet.clear();
            this.fWorkingSetToElement.clear();
            this.fResourceToWorkingSet.clear();
        }

        public void rebuild(IWorkingSet[] iWorkingSetArray) {
            this.clear();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                this.put(iWorkingSetArray[n]);
                ++n;
            }
        }

        public IAdaptable[] remove(IWorkingSet iWorkingSet) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])this.fWorkingSetToElement.remove(iWorkingSet);
            if (iAdaptableArray != null) {
                int n = 0;
                while (n < iAdaptableArray.length) {
                    this.removeElement(iAdaptableArray[n], iWorkingSet);
                    ++n;
                }
            }
            return iAdaptableArray;
        }

        public IAdaptable[] refresh(IWorkingSet iWorkingSet) {
            IAdaptable[] iAdaptableArray = (IAdaptable[])this.fWorkingSetToElement.get(iWorkingSet);
            if (iAdaptableArray == null) {
                return null;
            }
            IAdaptable[] iAdaptableArray2 = iWorkingSet.getElements();
            ArrayList arrayList = new ArrayList(Arrays.asList(iAdaptableArray));
            ArrayList arrayList2 = new ArrayList(Arrays.asList(iAdaptableArray2));
            this.computeDelta(arrayList, arrayList2, iAdaptableArray, iAdaptableArray2);
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.addElement((IAdaptable)iterator.next(), iWorkingSet);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.removeElement((IAdaptable)iterator.next(), iWorkingSet);
            }
            if (arrayList.size() > 0 || arrayList2.size() > 0) {
                this.fWorkingSetToElement.put(iWorkingSet, iAdaptableArray2);
            }
            return iAdaptableArray;
        }

        private void computeDelta(List list, List list2, IAdaptable[] iAdaptableArray, IAdaptable[] iAdaptableArray2) {
            int n = 0;
            while (n < iAdaptableArray.length) {
                list2.remove(iAdaptableArray[n]);
                ++n;
            }
            n = 0;
            while (n < iAdaptableArray2.length) {
                list.remove(iAdaptableArray2[n]);
                ++n;
            }
        }

        public IWorkingSet getFirstWorkingSet(Object object) {
            return (IWorkingSet)this.getFirstElement(this.fElementToWorkingSet, object);
        }

        public List getAllWorkingSets(Object object) {
            return this.getAllElements(this.fElementToWorkingSet, object);
        }

        public IWorkingSet getFirstWorkingSetForResource(IResource iResource) {
            return (IWorkingSet)this.getFirstElement(this.fResourceToWorkingSet, iResource);
        }

        public List getAllWorkingSetsForResource(IResource iResource) {
            return this.getAllElements(this.fResourceToWorkingSet, iResource);
        }

        private void put(IWorkingSet iWorkingSet) {
            if (this.fWorkingSetToElement.containsKey(iWorkingSet)) {
                return;
            }
            IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
            this.fWorkingSetToElement.put(iWorkingSet, iAdaptableArray);
            int n = 0;
            while (n < iAdaptableArray.length) {
                this.addElement(iAdaptableArray[n], iWorkingSet);
                ++n;
            }
        }

        private void addElement(IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            this.addToMap(this.fElementToWorkingSet, iAdaptable, iWorkingSet);
            IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
            if (iResource != null) {
                this.addToMap(this.fResourceToWorkingSet, (IAdaptable)iResource, iWorkingSet);
            }
        }

        private void removeElement(IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            this.removeFromMap(this.fElementToWorkingSet, iAdaptable, iWorkingSet);
            IResource iResource = (IResource)iAdaptable.getAdapter(IResource.class);
            if (iResource != null) {
                this.removeFromMap(this.fResourceToWorkingSet, (IAdaptable)iResource, iWorkingSet);
            }
        }

        private void addToMap(Map map, IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            Object v = map.get(iAdaptable);
            if (v == null) {
                map.put(iAdaptable, iWorkingSet);
            } else if (v instanceof IWorkingSet) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(v);
                arrayList.add(iWorkingSet);
                map.put(iAdaptable, arrayList);
            } else if (v instanceof List) {
                ((List)v).add(iWorkingSet);
            }
        }

        private void removeFromMap(Map map, IAdaptable iAdaptable, IWorkingSet iWorkingSet) {
            Object v = map.get(iAdaptable);
            if (v == null) {
                return;
            }
            if (v instanceof List) {
                List list = (List)v;
                list.remove(iWorkingSet);
                switch (list.size()) {
                    case 0: {
                        map.remove(iAdaptable);
                        break;
                    }
                    case 1: {
                        map.put(iAdaptable, list.get(0));
                    }
                }
            } else if (v == iWorkingSet) {
                map.remove(iAdaptable);
            }
        }

        private Object getFirstElement(Map map, Object object) {
            Object v = map.get(object);
            if (v instanceof List) {
                return ((List)v).get(0);
            }
            return v;
        }

        private List getAllElements(Map map, Object object) {
            Object v = map.get(object);
            if (v instanceof List) {
                return (List)v;
            }
            if (v == null) {
                return new ArrayList(0);
            }
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(v);
            return arrayList;
        }
    }

    private static class WorkingSetComparar
    implements IElementComparer {
        private WorkingSetComparar() {
        }

        public boolean equals(Object object, Object object2) {
            IWorkingSet iWorkingSet;
            IWorkingSet iWorkingSet2 = object instanceof IWorkingSet ? (IWorkingSet)object : null;
            IWorkingSet iWorkingSet3 = iWorkingSet = object2 instanceof IWorkingSet ? (IWorkingSet)object2 : null;
            if (iWorkingSet2 == null || iWorkingSet == null) {
                return object.equals(object2);
            }
            return iWorkingSet2 == iWorkingSet;
        }

        public int hashCode(Object object) {
            if (object instanceof IWorkingSet) {
                return System.identityHashCode(object);
            }
            return object.hashCode();
        }
    }
}

