/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class CodeDataResolver {
    private static final CodeData[] EMPTY = new CodeData[0];
    private static CodeDataResolver instance;

    private CodeDataResolver() {
    }

    public static CodeDataResolver getInstance() {
        if (instance == null) {
            instance = new CodeDataResolver();
        }
        return instance;
    }

    public CodeData[] resolve(IFile iFile, int n) throws IOException, CoreException {
        IStructuredModel iStructuredModel = null;
        try {
            iStructuredModel = StructuredModelManager.getModelManager().getModelForRead(iFile);
            if (iStructuredModel instanceof DOMModelForPHP) {
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                CodeData[] codeDataArray = this.resolve(iStructuredModel.getStructuredDocument(), n, dOMModelForPHP);
                return codeDataArray;
            }
            CodeData[] codeDataArray = EMPTY;
            return codeDataArray;
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public CodeData[] resolve(IProject iProject, File file, int n) throws IOException {
        IStructuredDocument iStructuredDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor(file.getAbsolutePath(), (InputStream)new FileInputStream(file), (URIResolver)new ProjectResolver(iProject));
        return this.resolve(iStructuredDocument, n);
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n) {
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)iStructuredDocument);
        try {
            if (iStructuredModel instanceof DOMModelForPHP) {
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                CodeData[] codeDataArray = this.resolve(iStructuredDocument, n, dOMModelForPHP);
                return codeDataArray;
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
        return EMPTY;
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n, DOMModelForPHP dOMModelForPHP) {
        PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
        PHPFileData pHPFileData = dOMModelForPHP.getFileData(true);
        if (pHPProjectModel == null || pHPFileData == null) {
            return EMPTY;
        }
        return this.resolve(iStructuredDocument, n, pHPProjectModel, pHPFileData);
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n, PHPProjectModel pHPProjectModel, PHPFileData pHPFileData) {
        block39: {
            try {
                CodeData[] codeDataArray;
                int n2;
                PHPClassData pHPClassData;
                IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
                if (iStructuredDocumentRegion == null) break block39;
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
                IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                if (iTextRegion instanceof ITextRegionContainer) {
                    iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                    iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
                }
                if (iTextRegion.getType() != "PHP_CONTENT") break block39;
                PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
                iTextRegion = phpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - phpScriptRegion.getStart());
                int n3 = iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart() + iTextRegion.getStart();
                TextSequence textSequence = PHPTextSequenceUtilities.getStatment(n3 + iTextRegion.getLength(), iStructuredDocumentRegion, true);
                int n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, textSequence.length());
                int n5 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n4, true);
                String string = textSequence.subSequence(n5, n4).toString();
                int n6 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n5);
                int n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, false);
                String string2 = textSequence.subSequence(n7, n6).toString();
                ITextRegion iTextRegion2 = iTextRegion;
                while ((PHPPartitionTypes.isPHPCommentState((iTextRegion2 = phpScriptRegion.getPhpToken(iTextRegion2.getEnd())).getType()) || iTextRegion2.getType() == "WHITESPACE") && iTextRegion2.getEnd() < phpScriptRegion.getLength()) {
                }
                String string3 = iStructuredDocument.get(iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart() + iTextRegion2.getStart(), iTextRegion2.getTextLength());
                if (string.length() <= 0) break block39;
                String string4 = pHPFileData != null ? pHPFileData.getName() : null;
                PHPClassData pHPClassData2 = pHPClassData = pHPFileData != null ? PHPFileDataUtilities.getContainerClassDada(pHPFileData, n) : null;
                if ("function".equalsIgnoreCase(string2)) {
                    if (pHPClassData != null) {
                        return this.toArray(pHPProjectModel.getClassFunctionData(string4, pHPClassData.getName(), string));
                    }
                    return this.toArray(pHPProjectModel.getFunction(string4, string));
                }
                if ("class".equalsIgnoreCase(string2) || "interface".equalsIgnoreCase(string2)) {
                    return this.toArray(pHPProjectModel.getClass(string4, string));
                }
                CodeData[] codeDataArray2 = this.getMatchingClasses(string, pHPProjectModel, string4);
                if ("new".equalsIgnoreCase(string2)) {
                    return codeDataArray2;
                }
                if (textSequence.length() > 6 && ("class".equals(textSequence.subSequence(0, 5).toString()) || textSequence.length() > 10 && "interface".equals(textSequence.subSequence(0, 9).toString()))) {
                    if ("extends".equalsIgnoreCase(string2) || "implements".equalsIgnoreCase(string2)) {
                        return codeDataArray2;
                    }
                    int n8 = PHPTextSequenceUtilities.readIdentifierListStartIndex(textSequence, n4);
                    n2 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n8);
                    int n9 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n2, false);
                    codeDataArray = textSequence.subSequence(n9, n2).toString();
                    if ("extends".equalsIgnoreCase((String)codeDataArray) || "implements".equalsIgnoreCase((String)codeDataArray)) {
                        return codeDataArray2;
                    }
                }
                String string5 = null;
                if (n5 > 2) {
                    string5 = textSequence.subSequence(n5 - 2, n5).toString();
                }
                if (string.charAt(0) == '$' && !"::".equals(string5)) {
                    PHPCodeContext pHPCodeContext;
                    CodeData[] codeDataArray3;
                    if (PHPPartitionTypes.isPHPQuotesState(iTextRegion.getType())) {
                        try {
                            n2 = iStructuredDocument.get(n3 - 2, 1).charAt(0);
                            if (n2 == 92) {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            PHPCorePlugin.log(badLocationException);
                        }
                    }
                    string = string.substring(1);
                    if (pHPClassData != null) {
                        if ("var".equalsIgnoreCase(string2) || "private".equalsIgnoreCase(string2) || "static".equalsIgnoreCase(string2) || "public".equalsIgnoreCase(string2) || "protected".equalsIgnoreCase(string2)) {
                            return this.filterExact(pHPClassData.getVars(), string);
                        }
                        if ("this".equalsIgnoreCase(string)) {
                            return this.toArray(pHPClassData);
                        }
                    }
                    if ((codeDataArray3 = this.filterExact(pHPProjectModel.getVariables(string4, pHPCodeContext = ModelSupport.createContext(pHPFileData, n3), string, true), string)).length == 1 && codeDataArray3[0].getUserData() == null && codeDataArray3[0] instanceof PHPVariableData) {
                        PHPVariableTypeData pHPVariableTypeData;
                        int n10;
                        codeDataArray = (PHPVariableData)codeDataArray3[0];
                        String string6 = VariableContextBuilder.createVariableContext(string, pHPCodeContext);
                        List list = (List)pHPFileData.getVariableTypeManager().getVariablesInstansiation().get(string6);
                        if (list != null && list.size() > 0 && (iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n10 = (pHPVariableTypeData = (PHPVariableTypeData)list.get(list.size() - 1)).getPosition())) != null) {
                            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n10);
                            iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                            if (iTextRegion instanceof ITextRegionContainer) {
                                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n10);
                            }
                            if (iTextRegion != null && iTextRegion.getType() == "PHP_CONTENT") {
                                phpScriptRegion = (PhpScriptRegion)iTextRegion;
                                ITextRegion iTextRegion3 = iTextRegion = phpScriptRegion.getPhpToken(n10 - iStructuredDocumentRegion2.getStartOffset() - phpScriptRegion.getStart());
                                while ((iTextRegion3 = phpScriptRegion.getPhpToken(iTextRegion3.getStart() - 1)).getType() != "PHP_VARIABLE" && iTextRegion3.getStart() > 0) {
                                }
                                if (iTextRegion3.getType() == "PHP_VARIABLE") {
                                    n10 = iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart() + iTextRegion3.getStart();
                                    int n11 = n10 + string.length();
                                    UserData userData = PHPCodeDataFactory.createUserData(string4, n10, n11, n11, pHPVariableTypeData.getLine());
                                    codeDataArray3[0] = PHPCodeDataFactory.createPHPVariableData(codeDataArray.getName(), codeDataArray.getDocBlock(), userData);
                                }
                            }
                        }
                    }
                    return codeDataArray3;
                }
                if (pHPClassData != null && "const".equalsIgnoreCase(string2)) {
                    return this.filterExact(pHPClassData.getConsts(), string);
                }
                if ("::".equals(string3)) {
                    return codeDataArray2;
                }
                String string7 = this.getClassName(pHPProjectModel, pHPFileData, textSequence, n5, n, iStructuredDocument.getLineOfOffset(n));
                CodeData[] codeDataArray4 = this.getMatchingClasses(string7, pHPProjectModel, string4);
                if ("(".equals(string3)) {
                    codeDataArray = null;
                    if (codeDataArray4.length > 0) {
                        int n12 = 0;
                        while (n12 < codeDataArray4.length) {
                            codeDataArray = ModelSupport.merge(codeDataArray, this.toArray(pHPProjectModel.getClassFunctionData(string4, string7, string)));
                            ++n12;
                        }
                    } else {
                        codeDataArray = pHPProjectModel.getFilteredFunctions(string4, string);
                        if (codeDataArray == null || codeDataArray.length == 0) {
                            codeDataArray = pHPProjectModel.getFunction(string);
                        }
                    }
                    return codeDataArray == null ? EMPTY : codeDataArray;
                }
                if (codeDataArray4.length > 0) {
                    if (n5 > 0 && "::".equals(string5) && string.charAt(0) != '$') {
                        codeDataArray = null;
                        int n13 = 0;
                        while (n13 < codeDataArray4.length) {
                            codeDataArray = ModelSupport.merge(codeDataArray, this.toArray(pHPProjectModel.getClassConstsData(string4, string7, string)));
                            ++n13;
                        }
                        return codeDataArray == null ? EMPTY : codeDataArray;
                    }
                    codeDataArray = null;
                    if (string.charAt(0) == '$') {
                        string = string.substring(1);
                    }
                    int n14 = 0;
                    while (n14 < codeDataArray4.length) {
                        codeDataArray = ModelSupport.merge(codeDataArray, this.toArray(pHPProjectModel.getClassVariablesData(string4, string7, string)));
                        ++n14;
                    }
                    return codeDataArray == null ? EMPTY : codeDataArray;
                }
                codeDataArray = pHPProjectModel.getFilteredConstants(string4, string);
                if (codeDataArray == null || codeDataArray.length == 0) {
                    codeDataArray = pHPProjectModel.getConstant(string);
                }
                return codeDataArray == null ? EMPTY : codeDataArray;
            }
            catch (Exception exception) {
                PHPCorePlugin.log(exception);
            }
        }
        return EMPTY;
    }

    private CodeData[] getMatchingClasses(String string, PHPProjectModel pHPProjectModel, String string2) {
        CodeData[] codeDataArray = pHPProjectModel.getFilteredClasses(string2, string);
        if (codeDataArray == null || codeDataArray.length == 0) {
            codeDataArray = pHPProjectModel.getClass(string);
        }
        return codeDataArray;
    }

    private CodeData[] filterExact(CodeData[] codeDataArray, String string) {
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        if (codeDataArray != null) {
            int n = 0;
            while (n < codeDataArray.length) {
                if (string.equalsIgnoreCase(codeDataArray[n].getName())) {
                    arrayList.add(codeDataArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new CodeData[arrayList.size()]);
    }

    private String getClassName(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, TextSequence textSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n < 2) {
            return null;
        }
        if ((n = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n)) < 2) {
            return null;
        }
        boolean bl = false;
        String string = textSequence.subSequence(n - 2, n).toString();
        if (!"->".equals(string)) {
            if ("::".equals(string)) {
                bl = true;
            } else {
                return null;
            }
        }
        if ((n5 = PHPTextSequenceUtilities.getPrivousTriggerIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n - 2))) == -1) {
            return this.innerGetClassName(pHPProjectModel, pHPFileData, textSequence, n4, bl, n2, n3);
        }
        int n6 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n5 + 2);
        String string2 = textSequence.subSequence(n6, n4).toString();
        String string3 = this.getClassName(pHPProjectModel, pHPFileData, textSequence, n6, n2, n3);
        int n7 = string2.indexOf(40);
        if (n7 == -1) {
            return this.getVarType(pHPProjectModel, pHPFileData, string3, string2, n2, n3);
        }
        String string4 = string2.substring(0, n7).trim();
        return this.getFunctionReturnType(pHPProjectModel, pHPFileData, string3, string4);
    }

    private String innerGetClassName(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, TextSequence textSequence, int n, boolean bl, int n2, int n3) {
        if (pHPFileData == null) {
            return null;
        }
        int n4 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n, true);
        String string = textSequence.subSequence(n4, n).toString();
        if (bl) {
            PHPClassData pHPClassData;
            if (string.equals("self")) {
                PHPClassData pHPClassData2 = PHPFileDataUtilities.getContainerClassDada(pHPFileData, n2 - 6);
                if (pHPClassData2 != null) {
                    return pHPClassData2.getName();
                }
            } else if (string.equals("parent") && (pHPClassData = PHPFileDataUtilities.getContainerClassDada(pHPFileData, n2 - 8)) != null) {
                return pHPProjectModel.getSuperClassName(pHPFileData.getName(), pHPClassData.getName());
            }
            return string;
        }
        if (string.length() > 0 && string.charAt(0) == '$') {
            int n5 = textSequence.getOriginalOffset(0);
            return PHPFileDataUtilities.getVariableType(pHPFileData, string, n5, n3, (IPhpModel)pHPProjectModel, true);
        }
        if (textSequence.charAt(n - 1) == ')') {
            PHPFunctionData[] pHPFunctionDataArray;
            int n6 = this.getFunctionNameEndOffset(textSequence, n - 1);
            int n7 = PHPTextSequenceUtilities.readIdentifiarStartIndex(textSequence, n6, false);
            String string2 = textSequence.subSequence(n7, n6).toString();
            PHPClassData pHPClassData = PHPFileDataUtilities.getContainerClassDada(pHPFileData, n2);
            if (pHPClassData != null) {
                return this.getFunctionReturnType(pHPProjectModel, pHPFileData, pHPClassData.getName(), string2);
            }
            PHPFunctionData[] pHPFunctionDataArray2 = pHPFunctionDataArray = pHPFileData.getFunctions();
            int n8 = pHPFunctionDataArray.length;
            int n9 = 0;
            while (n9 < n8) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray2[n9];
                if (pHPFunctionData.getName().equals(string2)) {
                    return pHPFunctionData.getReturnType();
                }
                ++n9;
            }
        }
        return null;
    }

    private int getFunctionNameEndOffset(TextSequence textSequence, int n) {
        if (textSequence.charAt(n) != ')') {
            return 0;
        }
        int n2 = n;
        int n3 = 1;
        while (n3 != 0 && n2 >= 0) {
            if (textSequence.charAt(--n2) == ')') {
                ++n3;
                continue;
            }
            if (textSequence.charAt(n2) != '(') continue;
            --n3;
        }
        return n2;
    }

    private String getVarType(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, String string, String string2, int n, int n2) {
        String string3 = PHPFileDataUtilities.getVariableType(pHPFileData.getName(), "this;*" + string2, n, n2, (IPhpModel)pHPProjectModel.getPHPUserModel(), true);
        if (string3 != null) {
            return string3;
        }
        CodeData codeData = pHPProjectModel.getClassVariablesData(pHPFileData.getName(), string, string2);
        if (codeData != null) {
            if (codeData instanceof PHPClassVarData) {
                return ((PHPClassVarData)codeData).getClassType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(pHPFileData.getName(), string);
        if (pHPClassData == null) {
            return null;
        }
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return null;
        }
        return this.getVarType(pHPProjectModel, pHPFileData, pHPSuperClassNameData.getName(), string2, n, n2);
    }

    private String getFunctionReturnType(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, String string, String string2) {
        CodeData codeData;
        int n;
        int n2;
        CodeData[] codeDataArray;
        CodeData[] codeDataArray2;
        CodeData codeData2 = pHPProjectModel.getClassFunctionData(pHPFileData.getName(), string, string2);
        if (codeData2 != null) {
            if (codeData2 instanceof PHPFunctionData) {
                return ((PHPFunctionData)codeData2).getReturnType();
            }
            return null;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(pHPFileData.getName(), string);
        if (pHPClassData == null) {
            return null;
        }
        String string3 = null;
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData != null) {
            string3 = this.getFunctionReturnType(pHPProjectModel, pHPFileData, pHPSuperClassNameData.getName(), string2);
        }
        if (string3 == null) {
            codeDataArray2 = pHPFileData.getFunctions();
            codeDataArray = codeDataArray2;
            n2 = codeDataArray2.length;
            n = 0;
            while (n < n2) {
                codeData = codeDataArray[n];
                if (codeData.getName().equals(string2) && codeData instanceof PHPFunctionData) {
                    string3 = ((PHPFunctionData)codeData).getReturnType();
                }
                ++n;
            }
        }
        if (string3 == null) {
            codeDataArray2 = pHPProjectModel.getFunctions();
            codeDataArray = codeDataArray2;
            n2 = codeDataArray2.length;
            n = 0;
            while (n < n2) {
                codeData = codeDataArray[n];
                if (codeData.getName().equals(string2) && codeData instanceof PHPFunctionData) {
                    string3 = ((PHPFunctionData)codeData).getReturnType();
                }
                ++n;
            }
        }
        return string3;
    }

    private CodeData[] toArray(CodeData codeData) {
        if (codeData != null) {
            return new CodeData[]{codeData};
        }
        return EMPTY;
    }
}

