/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.editor.contentassist.PHPDocContentAssistSupport;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PHPDocContentAssistProcessor
implements IContentAssistProcessorForPHP {
    private PHPDocContentAssistSupport support = new PHPDocContentAssistSupport();
    private boolean isExplicitRequest = false;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        ICompletionProposal[] iCompletionProposalArray;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return null;
        }
        IStructuredModel iStructuredModel = null;
        iStructuredModel = iModelManager.getExistingModelForRead(iTextViewer.getDocument());
        if (iStructuredModel == null) {
            return null;
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            try {
                iCompletionProposalArray = this.support.getCompletionOption(iTextViewer, dOMModelForPHP, n, this.isExplicitRequest);
            }
            catch (Exception exception) {
                Logger.logException((Throwable)exception);
                iStructuredModel.releaseFromRead();
                this.isExplicitRequest = false;
                return null;
            }
            if (iCompletionProposalArray == null) {
                iCompletionProposalArray = new ICompletionProposal[]{};
            }
        }
        finally {
            iStructuredModel.releaseFromRead();
            this.isExplicitRequest = false;
        }
        return iCompletionProposalArray;
    }

    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.support.getAutoactivationTriggers();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public void explicitActivationRequest() {
        this.isExplicitRequest = true;
    }
}

