/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpBaseVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpContainerVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBGpContainerValue
extends DBGpValue {
    private IVariable[] childVariables;
    private int numChild;
    private String className;
    private int page = -1;
    private int pageSize;
    private static final boolean IS_ARRAY = false;
    private static final boolean IS_OBJECT = true;
    private boolean containerType = false;

    public DBGpContainerValue(DBGpBaseVariable dBGpBaseVariable, Node node) {
        super(dBGpBaseVariable);
        this.setModifiable(false);
        if (node != null) {
            this.parseData(node);
            this.genValueString("");
        }
    }

    private void parseData(Node node) {
        block8: {
            block7: {
                String string = DBGpResponse.getAttribute(node, "type");
                if (string.equals("object")) {
                    this.containerType = true;
                    this.className = DBGpResponse.getAttribute(node, "classname");
                }
                String string2 = DBGpResponse.getAttribute(node, "numchildren");
                this.numChild = 0;
                if (string2 != null && string2.trim().length() != 0) {
                    this.numChild = Integer.parseInt(string2);
                }
                String string3 = null;
                String string4 = null;
                string3 = DBGpResponse.getAttribute(node, "page");
                string4 = DBGpResponse.getAttribute(node, "pagesize");
                this.pageSize = ((DBGpTarget)this.getDebugTarget()).getMaxChildren();
                if (string4 != null && string4.trim().length() != 0) {
                    this.pageSize = Integer.parseInt(string4);
                }
                this.page = -1;
                if (string3 != null && string3.trim().length() != 0) {
                    this.page = Integer.parseInt(string3);
                }
                if (this.page == -1 && this.numChild > this.pageSize) {
                    this.page = 0;
                }
                if (this.page != -1 && !(this.getOwner() instanceof DBGpContainerVariable)) break block7;
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                if (n <= 0) break block8;
                this.childVariables = new DBGpVariable[n];
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = nodeList.item(n2);
                    this.childVariables[n2] = new DBGpVariable((DBGpTarget)this.getDebugTarget(), node2, this.getOwner().getStackLevel());
                    ++n2;
                }
                break block8;
            }
            int n = this.roundUp((double)this.numChild / (double)this.pageSize);
            this.childVariables = new DBGpContainerVariable[n];
            this.childVariables[0] = new DBGpContainerVariable(this.getDebugTarget(), this.page, this.pageSize, this.numChild, node, this.getOwner().getStackLevel(), this.getOwner().getFullName());
            int n3 = 1;
            while (n3 < n) {
                this.childVariables[n3] = new DBGpContainerVariable(this.getDebugTarget(), this.page + n3, this.pageSize, this.numChild, null, this.getOwner().getStackLevel(), this.getOwner().getFullName());
                ++n3;
            }
        }
    }

    public String getReferenceTypeName() throws DebugException {
        if (this.containerType) {
            return "object";
        }
        return "array";
    }

    void genValueString(String string) {
        if (!(this.getOwner() instanceof DBGpContainerVariable)) {
            if (this.containerType) {
                if (this.className != null && this.className.trim().length() != 0) {
                    this.setValueString(this.className);
                } else {
                    this.setValueString("Unknown Object Type");
                }
            } else {
                this.setValueString("Array [" + this.numChild + "]");
            }
        }
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.childVariables == null) {
            this.requestValue();
            if (this.childVariables == null) {
                this.childVariables = new IVariable[0];
            }
        }
        return this.childVariables;
    }

    private void requestValue() {
        DBGpTarget dBGpTarget = (DBGpTarget)this.getDebugTarget();
        DBGpBaseVariable dBGpBaseVariable = this.getOwner();
        int n = 0;
        if (dBGpBaseVariable instanceof DBGpContainerVariable) {
            n = ((DBGpContainerVariable)dBGpBaseVariable).getPage();
        }
        Node node = dBGpTarget.getProperty(dBGpBaseVariable.getFullName(), dBGpBaseVariable.getStackLevel(), n);
        this.parseData(node);
    }

    public boolean hasVariables() throws DebugException {
        boolean bl = this.childVariables == null || this.childVariables.length > 0;
        return bl;
    }

    private int roundUp(double d) {
        double d2 = d % 1.0;
        double d3 = d - d2;
        if (d2 > 0.0) {
            d3 += 1.0;
        }
        return (int)d3;
    }
}

