/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private IWorkbenchSite fSite;
    private PropertyDialogAction fOpenPropertiesDialog;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite());
    }

    public OpenViewActionGroup(IViewPart iViewPart) {
        this.createSiteActions((IWorkbenchSite)iViewPart.getSite());
    }

    public OpenViewActionGroup(PHPStructuredEditor pHPStructuredEditor) {
        this.fEditorIsOwner = true;
        this.initialize((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
    }

    private void createSiteActions(IWorkbenchSite iWorkbenchSite) {
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)iWorkbenchSite, iWorkbenchSite.getSelectionProvider());
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(iWorkbenchSite);
    }

    private void initialize(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        if (!this.fEditorIsOwner) {
            if (iSelection instanceof IStructuredSelection) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                this.fOpenPropertiesDialog.selectionChanged(iStructuredSelection);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(iSelection);
            }
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && iStructuredSelection != null && this.fOpenPropertiesDialog.isApplicableForSelection(iStructuredSelection)) {
            iMenuManager.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        this.fSite.getSelectionProvider();
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        if (!this.fEditorIsOwner) {
            iActionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.open", iAction);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection iSelection = this.getContext().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }
}

