/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.dnd.ExternalFileDropAdapter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.WorkbenchPage;

public class DNDUtils {
    private static final String DROP_TARGET_ID = "DropTarget";
    private static final IWindowListener WINDOW_LISTENER = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
            DNDUtils.windowEnableExternalDrop(iWorkbenchWindow);
        }
    };
    private static final IPageListener PAGE_LISTENER = new IPageListener(){

        public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        }

        public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        }

        public void pageOpened(IWorkbenchPage iWorkbenchPage) {
            DNDUtils.pageEnableExternalDrop(iWorkbenchPage);
        }
    };
    private static final IPropertyChangeListener PART_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    };

    public static void initEditorSiteExternalDrop() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            DNDUtils.windowEnableExternalDrop(iWorkbenchWindow);
        }
        PlatformUI.getWorkbench().addWindowListener(WINDOW_LISTENER);
    }

    public static void windowEnableExternalDrop(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            DNDUtils.pageEnableExternalDrop(iWorkbenchPage);
        }
        iWorkbenchWindow.addPageListener(PAGE_LISTENER);
    }

    public static void pageEnableExternalDrop(IWorkbenchPage iWorkbenchPage) {
        Control[] controlArray = ((WorkbenchPage)iWorkbenchPage).getClientComposite().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                Control[] controlArray2 = ((Composite)controlArray[n]).getChildren();
                int n2 = 0;
                while (n2 < controlArray2.length) {
                    Object object;
                    if (controlArray2[n2] instanceof CTabFolder && (object = ((CTabFolder)controlArray2[n2]).getData()) instanceof EditorStack) {
                        DNDUtils.enableExternalDrop(controlArray2[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        iWorkbenchPage.addPropertyChangeListener(PART_LISTENER);
    }

    public static void enableExternalDrop(Control control) {
        if (control.getData(DROP_TARGET_ID) != null) {
            return;
        }
        DropTarget dropTarget = new DropTarget(control, 1);
        ExternalFileDropAdapter externalFileDropAdapter = ExternalFileDropAdapter.getInstance();
        dropTarget.setTransfer(new Transfer[]{externalFileDropAdapter.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)externalFileDropAdapter);
        dropTarget.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DNDUtils.initEditorSiteExternalDrop();
            }
        });
    }
}

