/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.filters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.util.StringMatcher;

public class NamePatternFilter
extends ViewerFilter {
    private String[] fPatterns;
    private StringMatcher[] fMatchers;

    private StringMatcher[] getMatchers() {
        return this.fMatchers;
    }

    public String[] getPatterns() {
        return this.fPatterns;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        StringMatcher[] stringMatcherArray;
        String string = null;
        if (object2 instanceof PHPCodeData) {
            string = ((PHPCodeData)object2).getName();
        } else if (object2 instanceof IAdaptable) {
            stringMatcherArray = (StringMatcher[])object2;
            PHPCodeData pHPCodeData = (PHPCodeData)stringMatcherArray.getAdapter(PHPCodeData.class);
            if (pHPCodeData != null) {
                string = pHPCodeData.getName();
            } else {
                IResource iResource = (IResource)stringMatcherArray.getAdapter(IResource.class);
                if (iResource != null) {
                    string = iResource.getName();
                }
            }
        }
        if (string != null) {
            stringMatcherArray = this.getMatchers();
            int n = 0;
            while (n < stringMatcherArray.length) {
                if (stringMatcherArray[n].match(string)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] stringArray) {
        this.fPatterns = stringArray;
        this.fMatchers = new StringMatcher[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.fMatchers[n] = new StringMatcher(stringArray[n], true, false);
            ++n;
        }
    }
}

