/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.osgi.service.prefs.BackingStoreException;

public abstract class UseProjectSpecificSettingsPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static final String DISABLE_LINK = "DISABLE_LINK";
    private Map fData = null;
    private Button fEnableProjectSettings;
    private Link fProjectSettingsLink;

    public final void applyData(Object object) {
        super.applyData(object);
        if (object instanceof Map) {
            this.fData = (Map)object;
            this.updateLinkEnablement();
        }
    }

    protected abstract Control createCommonContents(Composite var1);

    public final Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite3.setLayout((Layout)new GridLayout(2, false));
        if (this.getProject() != null) {
            this.fEnableProjectSettings = new Button(composite3, 32);
            this.fEnableProjectSettings.setText(SSEUIMessages.EnableProjectSettings);
            this.fEnableProjectSettings.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            boolean bl = new ProjectScope(this.getProject()).getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false);
            this.fEnableProjectSettings.setSelection(bl);
        } else {
            Label label = new Label(composite3, 32);
            label.setLayoutData((Object)new GridData());
        }
        this.fProjectSettingsLink = new Link(composite3, 0);
        this.fProjectSettingsLink.setFont(composite2.getFont());
        this.fProjectSettingsLink.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        if (this.getProject() != null) {
            this.fProjectSettingsLink.setText("<a>" + SSEUIMessages.ConfigureWorkspaceSettings + "</a>");
        } else {
            this.fProjectSettingsLink.setText("<a>" + SSEUIMessages.ConfigureProjectSettings + "</a>");
        }
        this.updateLinkEnablement();
        this.fProjectSettingsLink.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UseProjectSpecificSettingsPropertyPage.this.getProject() == null) {
                    UseProjectSpecificSettingsPropertyPage.this.openProjectSettings();
                } else {
                    UseProjectSpecificSettingsPropertyPage.this.openWorkspaceSettings();
                }
            }
        });
        if (this.getProject() != null) {
            Label label = new Label(composite2, 258);
            label.setLayoutData((Object)new GridData(256));
        }
        final Control control = this.createCommonContents(composite2);
        control.setLayoutData((Object)new GridData(1808));
        if (this.fEnableProjectSettings != null) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){
                ControlEnableState enablements = null;

                public void widgetSelected(SelectionEvent selectionEvent) {
                    super.widgetSelected(selectionEvent);
                    if (UseProjectSpecificSettingsPropertyPage.this.fEnableProjectSettings.getSelection()) {
                        if (this.enablements != null) {
                            this.enablements.restore();
                            this.enablements = null;
                        }
                    } else {
                        this.enablements = ControlEnableState.disable((Control)control);
                    }
                }
            };
            selectionAdapter.widgetSelected(null);
            this.fEnableProjectSettings.addSelectionListener((SelectionListener)selectionAdapter);
        }
        return composite2;
    }

    protected abstract String getPreferenceNodeQualifier();

    protected abstract String getPreferencePageID();

    protected IProject getProject() {
        if (this.getElement() != null && this.getElement() instanceof IProject) {
            return (IProject)this.getElement();
        }
        return null;
    }

    protected abstract String getProjectSettingsKey();

    protected abstract String getPropertyPageID();

    protected boolean isElementSettingsEnabled() {
        return this.fEnableProjectSettings != null && this.fEnableProjectSettings.getSelection();
    }

    void openProjectSettings() {
        Object[] objectArray;
        ListDialog listDialog = new ListDialog(this.getShell()){

            protected Control createDialogArea(Composite composite) {
                Control control = super.createDialogArea(composite);
                this.getTableViewer().setSorter((ViewerSorter)new ResourceSorter(1));
                return control;
            }
        };
        listDialog.setMessage(SSEUIMessages.PropertyPreferencePage_02);
        listDialog.setContentProvider(new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return ((IWorkspace)object).getRoot().getProjects();
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        listDialog.setLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), SSEUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        listDialog.setInput((Object)ResourcesPlugin.getWorkspace());
        listDialog.setTitle(SSEUIMessages.PropertyPreferencePage_01);
        if (listDialog.open() == 0 && (objectArray = listDialog.getResult()).length > 0) {
            IProject iProject = (IProject)listDialog.getResult()[0];
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put(DISABLE_LINK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)iProject, (String)this.getPropertyPageID(), (String[])new String[]{this.getPropertyPageID()}, hashMap).open();
        }
    }

    void openWorkspaceSettings() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(DISABLE_LINK, Boolean.TRUE);
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPreferencePageID(), (String[])new String[]{this.getPreferencePageID()}, hashMap).open();
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        if (this.getProject() != null) {
            if (this.isElementSettingsEnabled()) {
                new ProjectScope(this.getProject()).getNode(this.getPreferenceNodeQualifier()).putBoolean(this.getProjectSettingsKey(), this.fEnableProjectSettings.getSelection());
            } else {
                new ProjectScope(this.getProject()).getNode(this.getPreferenceNodeQualifier()).remove(this.getProjectSettingsKey());
            }
            try {
                new ProjectScope(this.getProject()).getNode(this.getPreferenceNodeQualifier()).flush();
            }
            catch (BackingStoreException backingStoreException) {
                Logger.logException("problem saving preference settings to scope " + new ProjectScope(this.getProject()).getName(), backingStoreException);
                bl = false;
            }
        }
        return bl;
    }

    private void updateLinkEnablement() {
        if (this.fData != null && this.fProjectSettingsLink != null) {
            this.fProjectSettingsLink.setEnabled(!Boolean.TRUE.equals(this.fData.get(DISABLE_LINK)));
        }
    }
}

