/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaVersion;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.platform.ColumnContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaVersionContext
extends JavaAttributeContext {
    private ColumnContext columnContext;

    public JavaVersionContext(IContext parentContext, JavaVersion javaVersion) {
        super(parentContext, javaVersion);
        this.columnContext = new ColumnContext(this, javaVersion.getColumn());
    }

    protected JavaVersion version() {
        return (JavaVersion)this.attributeMapping;
    }

    @Override
    protected void refreshDefaultsInternal(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        super.refreshDefaultsInternal(defaultsContext, monitor);
        this.columnContext.refreshDefaults(defaultsContext, monitor);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addColumnMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        boolean doContinue;
        JavaVersion version = this.version();
        ITypeMapping typeMapping = version.typeMapping();
        IColumn column = version.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && column.isConnected();
        if (doContinue && typeMapping.tableNameIsInvalid(table)) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.tableTextRange()));
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            messages.add(JpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.nameTextRange()));
        }
    }
}

