/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.PHPStreamsProxy;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.swt.graphics.Color;

public class PHPConsoleColorProvider
extends ConsoleColorProvider {
    private static IPHPConsoleEventListener[] fConsoleEventListeners;
    private PHPProcess fProcess;
    private IConsole fConsole;
    private ILaunch fLaunch;
    private PHPHyperLink fPHPHyperLink;
    private static final String PHP_DEBUG_STREAM;

    static {
        PHP_DEBUG_STREAM = String.valueOf(PHPDebugUIPlugin.getID()) + ".PHP_CONSOLE_STREAM";
    }

    public void connect(IProcess iProcess, IConsole iConsole) {
        this.fConsole = iConsole;
        PHPStreamsProxy pHPStreamsProxy = (PHPStreamsProxy)iProcess.getStreamsProxy();
        if (!(iProcess instanceof PHPProcess)) {
            return;
        }
        this.fProcess = (PHPProcess)iProcess;
        this.fProcess.setConsole(this.fConsole);
        this.fPHPHyperLink = new PHPHyperLink();
        this.fProcess.setPHPHyperLink(this.fPHPHyperLink);
        DebugConsoleMonitor debugConsoleMonitor = (DebugConsoleMonitor)pHPStreamsProxy.getConsoleStreamMonitor();
        if (pHPStreamsProxy != null) {
            this.fConsole.connect((IStreamMonitor)debugConsoleMonitor, PHP_DEBUG_STREAM);
        }
        this.fLaunch = iProcess.getLaunch();
        PHPDebugTarget pHPDebugTarget = null;
        if (this.fLaunch.getDebugTarget() instanceof PHPDebugTarget) {
            pHPDebugTarget = (PHPDebugTarget)this.fLaunch.getDebugTarget();
        }
        if (pHPDebugTarget != null) {
            IPHPConsoleEventListener[] iPHPConsoleEventListenerArray;
            IPHPConsoleEventListener[] iPHPConsoleEventListenerArray2 = iPHPConsoleEventListenerArray = PHPConsoleColorProvider.getConsoleEventListeners();
            int n = iPHPConsoleEventListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPConsoleEventListener iPHPConsoleEventListener = iPHPConsoleEventListenerArray2[n2];
                iPHPConsoleEventListener.init(this.fLaunch, debugConsoleMonitor, this.fPHPHyperLink);
                pHPDebugTarget.addConsoleEventListener(iPHPConsoleEventListener);
                ++n2;
            }
        }
        super.connect(iProcess, this.fConsole);
    }

    private static IPHPConsoleEventListener[] getConsoleEventListeners() {
        if (fConsoleEventListeners == null) {
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray;
            HashMap<String, IPHPConsoleEventListener> hashMap = new HashMap<String, IPHPConsoleEventListener>();
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugUIPlugin.getID(), "phpConsoleListeners");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                iConfigurationElement = iConfigurationElementArray2[n2];
                if ("listener".equals(iConfigurationElement.getName()) && !hashMap.containsKey(string = iConfigurationElement.getAttribute("id"))) {
                    String string2 = iConfigurationElement.getAttribute("overridesId");
                    if (string2 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                        while (stringTokenizer.hasMoreTokens()) {
                            hashMap.put(stringTokenizer.nextToken(), null);
                        }
                    }
                    try {
                        hashMap.put(string, (IPHPConsoleEventListener)iConfigurationElement.createExecutableExtension("class"));
                    }
                    catch (CoreException coreException) {
                        PHPDebugUIPlugin.log(coreException);
                    }
                }
                ++n2;
            }
            iConfigurationElement = hashMap.values();
            iConfigurationElement.remove(null);
            fConsoleEventListeners = iConfigurationElement.toArray(new IPHPConsoleEventListener[hashMap.size()]);
        }
        return fConsoleEventListeners;
    }

    public void disconnect() {
        this.fConsole = null;
        this.fProcess = null;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Color getColor(String string) {
        if (PHP_DEBUG_STREAM.equals(string)) {
            return DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor");
        }
        return null;
    }

    protected IProcess getProcess() {
        return this.fProcess;
    }

    protected IConsole getConsole() {
        return this.fConsole;
    }
}

