/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.debug.ui.contentassist.DynamicTypeContext;
import org.eclipse.jdt.internal.debug.ui.contentassist.JavaDebugContentAssistProcessor;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class EditLogicalStructureDialog
extends StatusDialog
implements Listener,
ISelectionChangedListener,
IDocumentListener,
DynamicTypeContext.ITypeProvider {
    private final JavaLogicalStructure fLogicalStructure;
    private Text fQualifiedTypeNameText;
    private Text fDescriptionText;
    private TableViewer fAttributeListViewer;
    private Button fSubTypeButton;
    private Button fValueButton;
    private Button fVariablesButton;
    private Button fAttributeUpButton;
    private Button fAttributeDownButton;
    private JDISourceViewer fSnippetViewer;
    private Document fSnippetDocument;
    private Button fBrowseTypeButton;
    private Button fAttributeAddButton;
    private Button fAttributeRemoveButton;
    private Text fAttributeNameText;
    private Composite fAttributesContainer;
    private Group fCodeGroup;
    private Composite fParentComposite;
    private AttributesContentProvider fAttributesContentProvider;
    private String fValueTmp;
    private IStructuredSelection fCurrentAttributeSelection;
    private IType fType;
    private boolean fTypeSearched = false;
    private DisplayViewerConfiguration fViewerConfiguration;
    private IHandlerActivation fHandlerActivation;
    static /* synthetic */ Class class$0;

    public EditLogicalStructureDialog(Shell parentShell, JavaLogicalStructure logicalStructure) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        if (logicalStructure.getQualifiedTypeName().length() == 0) {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_32);
        } else {
            this.setTitle(DebugUIMessages.EditLogicalStructureDialog_31);
        }
        this.fLogicalStructure = logicalStructure;
    }

    protected Control createDialogArea(Composite parent) {
        boolean isValue;
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp((Control)parent, IJavaDebugHelpContextIds.EDIT_LOGICAL_STRUCTURE_DIALOG);
        this.fParentComposite = parent;
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (EditLogicalStructureDialog.this.fSnippetViewer.canDoOperation(13) && EditLogicalStructureDialog.this.fSnippetViewer.getControl().isFocusControl()) {
                    EditLogicalStructureDialog.this.findCorrespondingType();
                    EditLogicalStructureDialog.this.fSnippetViewer.doOperation(13);
                }
                return null;
            }
        };
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)workbench.getAdapter((Class)clazz);
        this.fHandlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
        Composite container = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808);
        Composite typeNameDescriptionContainer = SWTFactory.createComposite(container, container.getFont(), 2, 1, 768);
        SWTFactory.createLabel(typeNameDescriptionContainer, DebugUIMessages.EditLogicalStructureDialog_0, 2);
        this.fQualifiedTypeNameText = SWTFactory.createSingleText(typeNameDescriptionContainer, 1);
        this.fQualifiedTypeNameText.addListener(24, (Listener)this);
        this.fBrowseTypeButton = SWTFactory.createPushButton(typeNameDescriptionContainer, DebugUIMessages.EditLogicalStructureDialog_1, DebugUIMessages.EditLogicalStructureDialog_25, null);
        this.fBrowseTypeButton.addListener(13, (Listener)this);
        SWTFactory.createLabel(typeNameDescriptionContainer, DebugUIMessages.EditLogicalStructureDialog_2, 2);
        this.fDescriptionText = SWTFactory.createSingleText(typeNameDescriptionContainer, 2);
        this.fDescriptionText.addListener(24, (Listener)this);
        this.fSubTypeButton = SWTFactory.createCheckButton(typeNameDescriptionContainer, DebugUIMessages.EditLogicalStructureDialog_3, null, false, 1);
        this.fSubTypeButton.setToolTipText(DebugUIMessages.EditLogicalStructureDialog_26);
        Group radioContainer = SWTFactory.createGroup(container, DebugUIMessages.EditLogicalStructureDialog_33, 1, 1, 768);
        this.fValueButton = SWTFactory.createRadioButton((Composite)radioContainer, DebugUIMessages.EditLogicalStructureDialog_4);
        this.fValueButton.addListener(13, (Listener)this);
        this.fVariablesButton = SWTFactory.createRadioButton((Composite)radioContainer, DebugUIMessages.EditLogicalStructureDialog_5);
        this.fAttributesContainer = SWTFactory.createComposite(container, container.getFont(), 2, 1, 768);
        boolean bl = isValue = this.fLogicalStructure.getValue() != null;
        if (!isValue) {
            this.createAttributeListWidgets();
        }
        this.fCodeGroup = SWTFactory.createGroup(container, "", 1, 1, 1808);
        this.createCodeGroupWidgets(isValue);
        EditLogicalStructureDialog.applyDialogFont((Control)container);
        this.initializeData();
        return container;
    }

    private void createCodeGroupWidgets(boolean isValue) {
        if (isValue) {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_9);
        } else {
            this.fCodeGroup.setText(DebugUIMessages.EditLogicalStructureDialog_7);
            Composite attributeNameContainer = SWTFactory.createComposite((Composite)this.fCodeGroup, this.fCodeGroup.getFont(), 2, 1, 768);
            ((GridLayout)attributeNameContainer.getLayout()).marginWidth = 0;
            SWTFactory.createLabel(attributeNameContainer, DebugUIMessages.EditLogicalStructureDialog_8, 1);
            this.fAttributeNameText = SWTFactory.createSingleText(attributeNameContainer, 1);
            this.fAttributeNameText.addListener(24, (Listener)this);
            SWTFactory.createLabel((Composite)this.fCodeGroup, DebugUIMessages.EditLogicalStructureDialog_9, 1);
        }
        this.fSnippetViewer = new JDISourceViewer((Composite)this.fCodeGroup, null, 2816);
        this.fSnippetViewer.setInput(this);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        if (this.fSnippetDocument == null) {
            this.fSnippetDocument = new Document();
            this.fSnippetDocument.addDocumentListener((IDocumentListener)this);
        }
        tools.setupJavaDocumentPartitioner((IDocument)this.fSnippetDocument, "___java_partitioning");
        if (this.fViewerConfiguration == null) {
            this.fViewerConfiguration = new DisplayViewerConfiguration(){

                public IContentAssistProcessor getContentAssistantProcessor() {
                    return new JavaDebugContentAssistProcessor(new DynamicTypeContext(EditLogicalStructureDialog.this));
                }
            };
        }
        this.fSnippetViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)this.fSnippetDocument);
        Control control = this.fSnippetViewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(isValue ? 20 : 10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
    }

    private void createAttributeListWidgets() {
        this.fAttributeListViewer = new TableViewer(this.fAttributesContainer, 67586);
        Table table = (Table)this.fAttributeListViewer.getControl();
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(this.fAttributesContainer.getFont());
        if (this.fAttributesContentProvider == null) {
            this.fAttributesContentProvider = new AttributesContentProvider(this.fLogicalStructure.getVariables());
        }
        this.fAttributeListViewer.setContentProvider((IContentProvider)this.fAttributesContentProvider);
        this.fAttributeListViewer.setLabelProvider((IBaseLabelProvider)new AttributesLabelProvider());
        this.fAttributeListViewer.setInput((Object)this);
        this.fAttributeListViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite attributeListButtonsCotnainer = SWTFactory.createComposite(this.fAttributesContainer, this.fAttributesContainer.getFont(), 1, 1, 0);
        this.fAttributeAddButton = SWTFactory.createPushButton(attributeListButtonsCotnainer, DebugUIMessages.EditLogicalStructureDialog_10, DebugUIMessages.EditLogicalStructureDialog_27, null);
        this.fAttributeAddButton.addListener(13, (Listener)this);
        this.fAttributeRemoveButton = SWTFactory.createPushButton(attributeListButtonsCotnainer, DebugUIMessages.EditLogicalStructureDialog_11, DebugUIMessages.EditLogicalStructureDialog_28, null);
        this.fAttributeRemoveButton.addListener(13, (Listener)this);
        this.fAttributeUpButton = SWTFactory.createPushButton(attributeListButtonsCotnainer, DebugUIMessages.EditLogicalStructureDialog_12, DebugUIMessages.EditLogicalStructureDialog_29, null);
        this.fAttributeUpButton.addListener(13, (Listener)this);
        this.fAttributeDownButton = SWTFactory.createPushButton(attributeListButtonsCotnainer, DebugUIMessages.EditLogicalStructureDialog_13, DebugUIMessages.EditLogicalStructureDialog_30, null);
        this.fAttributeDownButton.addListener(13, (Listener)this);
    }

    private void initializeData() {
        this.fQualifiedTypeNameText.setText(this.fLogicalStructure.getQualifiedTypeName());
        this.fDescriptionText.setText(this.fLogicalStructure.getDescription());
        this.fSubTypeButton.setSelection(this.fLogicalStructure.isSubtypes());
        this.fValueTmp = this.fLogicalStructure.getValue();
        if (this.fValueTmp == null) {
            this.fValueTmp = "";
            this.fVariablesButton.setSelection(true);
            this.setAttributesData(false);
        } else {
            this.fValueButton.setSelection(true);
            this.setAttributesData(true);
        }
        this.checkValues();
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        switch (event.type) {
            case 13: {
                if (source == this.fValueButton) {
                    this.toggleAttributesWidgets(this.fValueButton.getSelection());
                    this.checkValues();
                    break;
                }
                if (source == this.fBrowseTypeButton) {
                    this.selectType();
                    break;
                }
                if (source == this.fAttributeAddButton) {
                    this.addAttribute();
                    break;
                }
                if (source == this.fAttributeRemoveButton) {
                    this.removeAttribute();
                    break;
                }
                if (source == this.fAttributeUpButton) {
                    this.attributeUp();
                    break;
                }
                if (source != this.fAttributeDownButton) break;
                this.attributeDown();
                break;
            }
            case 24: {
                if (source == this.fAttributeNameText) {
                    this.saveNewAttributeName();
                    this.checkValues();
                    break;
                }
                if (source == this.fQualifiedTypeNameText) {
                    this.checkValues();
                    this.fTypeSearched = false;
                    break;
                }
                if (source != this.fDescriptionText) break;
                this.checkValues();
            }
        }
    }

    private void addAttribute() {
        String[] newAttribute = new String[]{DebugUIMessages.EditLogicalStructureDialog_14, DebugUIMessages.EditLogicalStructureDialog_15};
        this.fAttributesContentProvider.add(newAttribute);
        this.fAttributeListViewer.refresh();
        this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute));
    }

    private void removeAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            List selectedElements = selection.toList();
            String[][] elements = this.fAttributesContentProvider.getElements();
            String[] newSelectedElement = null;
            int i = 0;
            while (i < elements.length) {
                if (selectedElements.contains(elements[i])) break;
                newSelectedElement = elements[i];
                ++i;
            }
            this.fAttributesContentProvider.remove(selectedElements);
            this.fAttributeListViewer.refresh();
            if (newSelectedElement == null) {
                String[][] newElements = this.fAttributesContentProvider.getElements();
                if (newElements.length > 0) {
                    this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newElements[0]));
                }
            } else {
                this.fAttributeListViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedElement));
            }
        }
    }

    private void attributeUp() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.up(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void attributeDown() {
        IStructuredSelection selection = (IStructuredSelection)this.fAttributeListViewer.getSelection();
        if (selection.size() > 0) {
            this.fAttributesContentProvider.down(selection.toList());
            this.fAttributeListViewer.refresh();
            this.fAttributeListViewer.setSelection((ISelection)selection);
        }
    }

    private void saveNewAttributeName() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            variable[0] = this.fAttributeNameText.getText();
            this.fAttributeListViewer.refresh((Object)variable);
        }
    }

    private void toggleAttributesWidgets(boolean isValue) {
        int i;
        Control[] children;
        if (!isValue) {
            this.fValueTmp = this.fSnippetDocument.get();
            this.createAttributeListWidgets();
        } else if (isValue) {
            this.saveAttributeValue();
            children = this.fAttributesContainer.getChildren();
            i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        children = this.fCodeGroup.getChildren();
        i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fSnippetViewer.dispose();
        this.createCodeGroupWidgets(isValue);
        this.setAttributesData(isValue);
        this.fParentComposite.layout(true, true);
    }

    private void setAttributesData(boolean isValue) {
        if (isValue) {
            this.fSnippetDocument.set(this.fValueTmp);
        } else {
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            this.fCurrentAttributeSelection = new StructuredSelection();
            if (elements.length > 0) {
                StructuredSelection newSelection = new StructuredSelection(elements[0]);
                this.fAttributeListViewer.setSelection((ISelection)newSelection);
            } else {
                this.fAttributeListViewer.setSelection((ISelection)this.fCurrentAttributeSelection);
            }
        }
    }

    private void setNameValueToSelection() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            String[] variable = (String[])this.fCurrentAttributeSelection.getFirstElement();
            this.fAttributeNameText.setText(variable[0]);
            this.fSnippetDocument.set(variable[1]);
            this.fAttributeNameText.setEnabled(true);
            this.fSnippetViewer.setEditable(true);
            this.fAttributeNameText.setSelection(0, variable[0].length());
            this.fAttributeNameText.setFocus();
        } else {
            this.fAttributeNameText.setEnabled(false);
            this.fSnippetViewer.setEditable(false);
            this.fAttributeNameText.setText("");
            this.fSnippetDocument.set("");
        }
    }

    private void saveAttributeValue() {
        if (this.fCurrentAttributeSelection.size() == 1) {
            ((String[])this.fCurrentAttributeSelection.getFirstElement())[1] = this.fSnippetDocument.get();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.saveAttributeValue();
        this.fCurrentAttributeSelection = (IStructuredSelection)event.getSelection();
        this.setNameValueToSelection();
        this.updateAttributeListButtons();
    }

    private void updateAttributeListButtons() {
        int selectionSize = this.fCurrentAttributeSelection.size();
        if (selectionSize > 0) {
            this.fAttributeRemoveButton.setEnabled(true);
            String[][] elements = this.fAttributesContentProvider.getElements();
            this.fAttributeUpButton.setEnabled(this.fCurrentAttributeSelection.getFirstElement() != elements[0]);
            this.fAttributeDownButton.setEnabled(this.fCurrentAttributeSelection.toArray()[selectionSize - 1] != elements[elements.length - 1]);
        } else {
            this.fAttributeRemoveButton.setEnabled(false);
            this.fAttributeUpButton.setEnabled(false);
            this.fAttributeDownButton.setEnabled(false);
        }
    }

    public void checkValues() {
        StatusInfo status = new StatusInfo();
        if (this.fQualifiedTypeNameText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_16);
        } else if (this.fDescriptionText.getText().trim().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_17);
        } else if (this.fValueButton.getSelection() && this.fSnippetDocument.get().length() == 0) {
            status.setError(DebugUIMessages.EditLogicalStructureDialog_18);
        } else if (this.fVariablesButton.getSelection()) {
            boolean oneElementSelected;
            Object[] elements = this.fAttributesContentProvider.getElements(null);
            boolean bl = oneElementSelected = this.fCurrentAttributeSelection.size() == 1;
            if (elements.length == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_19);
            } else if (oneElementSelected && this.fAttributeNameText.getText().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_20);
            } else if (oneElementSelected && this.fSnippetDocument.get().trim().length() == 0) {
                status.setError(DebugUIMessages.EditLogicalStructureDialog_21);
            } else {
                int i = 0;
                while (i < elements.length) {
                    String[] variable = (String[])elements[i];
                    if (variable[0].trim().length() == 0) {
                        status.setError(DebugUIMessages.EditLogicalStructureDialog_22);
                        break;
                    }
                    if (!(variable[1].trim().length() != 0 || oneElementSelected && this.fCurrentAttributeSelection.getFirstElement() == variable)) {
                        status.setError(MessageFormat.format((String)DebugUIMessages.EditLogicalStructureDialog_23, (Object[])new String[]{variable[0]}));
                        break;
                    }
                    ++i;
                }
            }
        }
        if (!status.isError() && this.fType == null && this.fTypeSearched) {
            status.setWarning(DebugUIMessages.EditLogicalStructureDialog_24);
        }
        this.updateStatus(status);
    }

    private void selectType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)this.fQualifiedTypeNameText.getText());
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.DetailFormatterDialog_Select_type_6;
            String message = DebugUIMessages.DetailFormatterDialog_Could_not_open_type_selection_dialog_for_detail_formatters_7;
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.DetailFormatterDialog_Select_type_8);
        dialog.setMessage(DebugUIMessages.DetailFormatterDialog_Select_a_type_to_format_when_displaying_its_detail_9);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fType = (IType)types[0];
            this.fQualifiedTypeNameText.setText(this.fType.getFullyQualifiedName());
            this.fTypeSearched = true;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.checkValues();
    }

    protected void okPressed() {
        this.fLogicalStructure.setType(this.fQualifiedTypeNameText.getText().trim());
        this.fLogicalStructure.setDescription(this.fDescriptionText.getText().trim());
        this.fLogicalStructure.setSubtypes(this.fSubTypeButton.getSelection());
        if (this.fValueButton.getSelection()) {
            this.fLogicalStructure.setValue(this.fSnippetDocument.get());
        } else {
            this.saveAttributeValue();
            this.fLogicalStructure.setValue(null);
        }
        if (this.fAttributesContentProvider != null) {
            this.fLogicalStructure.setVariables(this.fAttributesContentProvider.getElements());
        }
        super.okPressed();
    }

    private void findCorrespondingType() {
        if (this.fTypeSearched) {
            return;
        }
        this.fType = null;
        this.fTypeSearched = true;
        String pattern = this.fQualifiedTypeNameText.getText().trim().replace('$', '.');
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        SearchRequestor collector = new SearchRequestor((IProgressMonitor)monitor){
            private boolean fFirst = true;
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public void endReporting() {
                EditLogicalStructureDialog.this.checkValues();
            }

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object enclosingElement = match.getElement();
                if (!this.fFirst) {
                    return;
                }
                this.fFirst = false;
                if (enclosingElement instanceof IType) {
                    EditLogicalStructureDialog.this.fType = (IType)enclosingElement;
                }
                this.val$monitor.setCanceled(true);
            }
        };
        SearchEngine engine = new SearchEngine(JavaCore.getWorkingCopies(null));
        SearchPattern searchPattern = SearchPattern.createPattern((String)pattern, (int)0, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        try {
            engine.search(searchPattern, participants, scope, collector, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public IType getType() {
        if (!this.fTypeSearched) {
            this.findCorrespondingType();
        }
        return this.fType;
    }

    public boolean close() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)workbench.getAdapter((Class)clazz);
        handlerService.deactivateHandler(this.fHandlerActivation);
        this.fSnippetViewer.dispose();
        return super.close();
    }

    public class AttributesContentProvider
    implements IStructuredContentProvider {
        private final List fVariables = new ArrayList();

        public AttributesContentProvider(String[][] variables) {
            int i = 0;
            while (i < variables.length) {
                String[] variable = new String[]{variables[i][0], variables[i][1]};
                this.fVariables.add(variable);
                ++i;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        public String[][] getElements() {
            return (String[][])this.fVariables.toArray((T[])new String[this.fVariables.size()][]);
        }

        public void add(String[] newAttribute) {
            this.fVariables.add(newAttribute);
        }

        public void remove(List list) {
            this.fVariables.removeAll(list);
        }

        public void up(List list) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String[] variable = (String[])iter.next();
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index - 1, variable);
            }
        }

        public void down(List list) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String[] variable = (String[])iter.next();
                int index = this.fVariables.indexOf(variable);
                this.fVariables.remove(variable);
                this.fVariables.add(index + 1, variable);
            }
        }
    }

    public class AttributesLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            return ((String[])element)[0];
        }
    }
}

