/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.Messages;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.TypeUtil;

public final class TypeComparator {
    /*
     * Unable to fully structure code
     */
    public static Diagnostic calculateTypeCompatibility(CompositeType firstType, CompositeType secondType) {
        boxedFirstType = TypeTransformer.transformBoxPrimitives(firstType);
        boxedSecondType = TypeTransformer.transformBoxPrimitives(secondType);
        mustBeSatisfied = boxedFirstType.getSignatures();
        testSignatures = boxedSecondType.getSignatures();
        result = new BasicDiagnostic(2, "", 0, Messages.getString("TypeComparator.Expression.Doesnt.Match.Expected.Types"), null);
        i = 0;
        block0: while (i < mustBeSatisfied.length) {
            curSatisfyType = mustBeSatisfied[i];
            j = 0;
            while (j < testSignatures.length) {
                testType = testSignatures[j];
                if (curSatisfyType.equals(testType)) {
                    result = TypeComparator.checkAssignability(firstType, secondType);
                    break block0;
                }
                if (TypeUtil.isMethodSignature(curSatisfyType)) {
                    if (TypeUtil.isMethodSignature(testType)) {
                        test = TypeComparator.methodSignaturesMatch(curSatisfyType, testType);
                        if (test.getSeverity() == 0) {
                            result = Diagnostic.OK_INSTANCE;
                            break block0;
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else if (TypeComparator.canCoerce(testType, curSatisfyType, firstType.isLHS())) {
                    result = TypeComparator.checkAssignability(firstType, secondType);
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static boolean canCoerce(String testType, String checkType, boolean checkTypeIsWritable) {
        boolean canCoerce = TypeComparator.canCoerce(testType, checkType);
        if (canCoerce && checkTypeIsWritable) {
            canCoerce &= TypeComparator.canCoerce(checkType, testType);
        }
        return canCoerce;
    }

    private static boolean canCoerce(String testType, String checkType) {
        if (TypeCoercer.typeIsString(checkType)) {
            return true;
        }
        if (TypeCoercer.typeIsNumeric(checkType)) {
            return TypeComparator.canCoerceNumeric(testType);
        }
        if (TypeCoercer.typeIsBoolean(checkType)) {
            return TypeCoercer.canCoerceToBoolean(testType);
        }
        return false;
    }

    private static boolean canCoerceNumeric(String testType) {
        try {
            TypeCoercer.coerceToNumber(testType);
            return true;
        }
        catch (TypeCoercionException typeCoercionException) {
            return false;
        }
    }

    private static Diagnostic methodSignaturesMatch(String firstMethodSig, String secondMethodSig) {
        String secondReturn;
        String[] secondMethodParams;
        String[] firstMethodParams = Signature.getParameterTypes((String)firstMethodSig);
        if (firstMethodParams.length != (secondMethodParams = Signature.getParameterTypes((String)secondMethodSig)).length) {
            return new BasicDiagnostic(4, "", 0, Messages.getString("TypeComparator.Parameter.count.mismatch"), null);
        }
        int i = 0;
        while (i < firstMethodParams.length) {
            String secondMethodParam;
            String firstMethodParam = TypeTransformer.transformBoxPrimitives(firstMethodParams[i]);
            if (!firstMethodParam.equals(secondMethodParam = TypeTransformer.transformBoxPrimitives(secondMethodParams[i]))) {
                return new BasicDiagnostic(4, "", 0, String.valueOf(Messages.getString("TypeComparator.Type.mismatch.on.parameter")) + i, null);
            }
            ++i;
        }
        String firstReturn = TypeTransformer.transformBoxPrimitives(Signature.getReturnType((String)firstMethodSig));
        if (!firstReturn.equals(secondReturn = TypeTransformer.transformBoxPrimitives(Signature.getReturnType((String)secondMethodSig)))) {
            return new BasicDiagnostic(4, "", 0, Messages.getString("TypeComparator.Return.Types.Dont.Match"), null);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static Diagnostic checkAssignability(CompositeType firstType, CompositeType secondType) {
        if (firstType.isRHS() && !secondType.isRHS()) {
            return new BasicDiagnostic(2, "", 0, Messages.getString("TypeComparator.Expression.Not.Gettable"), null);
        }
        if (firstType.isLHS() && !secondType.isLHS()) {
            return new BasicDiagnostic(2, "", 0, Messages.getString("TypeComparator.Expression.Expected.Settable"), null);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private TypeComparator() {
    }
}

