/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;

public class TreeProvider {
    private static final String EXTENSION_POINT_NAME = "phpTreeContentProviders";
    private static final String TREE_CONTENT_PROVIDOR_TAG = "provider";
    private static final String TARGET_ID_ATTRIBUTE = "targetId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static TreeProvider[] fgTreeProviders;
    private IConfigurationElement fElement;
    private String[] targetIDs = new String[0];

    public TreeProvider(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
        String string = iConfigurationElement.getAttribute(TARGET_ID_ATTRIBUTE);
        if (string != null && string.trim().length() > 0) {
            this.targetIDs = string.split(",");
        }
    }

    public static TreeProvider[] getTreeProviders() {
        if (fgTreeProviders == null) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.php.ui", EXTENSION_POINT_NAME);
            fgTreeProviders = TreeProvider.createTreeProviders(iConfigurationElementArray);
        }
        return fgTreeProviders;
    }

    private static TreeProvider[] createTreeProviders(IConfigurationElement[] iConfigurationElementArray) {
        ArrayList<TreeProvider> arrayList = new ArrayList<TreeProvider>(5);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (TREE_CONTENT_PROVIDOR_TAG.equals(iConfigurationElement.getName())) {
                TreeProvider treeProvider = new TreeProvider(iConfigurationElement);
                arrayList.add(treeProvider);
            }
            ++n;
        }
        return arrayList.toArray(new TreeProvider[arrayList.size()]);
    }

    public static IPHPTreeContentProvider[] getTreeProviders(String string) {
        TreeProvider[] treeProviderArray = TreeProvider.getTreeProviders();
        ArrayList<IPHPTreeContentProvider> arrayList = new ArrayList<IPHPTreeContentProvider>(treeProviderArray.length);
        int n = 0;
        while (n < treeProviderArray.length) {
            if (treeProviderArray[n].targets(string)) {
                arrayList.add(treeProviderArray[n].createProvider());
            }
            ++n;
        }
        return arrayList.toArray(new IPHPTreeContentProvider[arrayList.size()]);
    }

    private IPHPTreeContentProvider createProvider() {
        final IPHPTreeContentProvider[] iPHPTreeContentProviderArray = new IPHPTreeContentProvider[1];
        String string = PHPUIMessages.getString("TreeProvider.1");
        SafeRunnable safeRunnable = new SafeRunnable(string){

            public void run() throws Exception {
                iPHPTreeContentProviderArray[0] = (IPHPTreeContentProvider)TreeProvider.this.fElement.createExecutableExtension(TreeProvider.CLASS_ATTRIBUTE);
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
        return iPHPTreeContentProviderArray[0];
    }

    private boolean targets(String string) {
        if (this.targetIDs.length == 0) {
            return true;
        }
        int n = 0;
        while (n < this.targetIDs.length) {
            if (this.targetIDs[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

