/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.containers;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class ZipEntryStorage
extends PlatformObject
implements IStorage {
    private ZipFile fArchive;
    private ZipEntry fZipEntry;
    private IProject fProject;

    public ZipEntryStorage(ZipFile zipFile, ZipEntry zipEntry) {
        this.setArchive(zipFile);
        this.setZipEntry(zipEntry);
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.getArchive().getInputStream(this.getZipEntry());
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, PHPCorePlugin.getPluginId(), 10001, CoreMessages.getString("zipEntryStorage_error"), (Throwable)iOException));
        }
    }

    public IPath getFullPath() {
        return new Path(this.getArchive().getName()).append(this.getZipEntry().getName());
    }

    public String getName() {
        String string = this.getZipEntry().getName();
        int n = Math.max(string.lastIndexOf(92), string.indexOf(47));
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void setArchive(ZipFile zipFile) {
        this.fArchive = zipFile;
    }

    public ZipFile getArchive() {
        return this.fArchive;
    }

    private void setZipEntry(ZipEntry zipEntry) {
        this.fZipEntry = zipEntry;
    }

    public ZipEntry getZipEntry() {
        return this.fZipEntry;
    }

    public boolean equals(Object object) {
        return object instanceof ZipEntryStorage && this.getArchive().getName().equals(((ZipEntryStorage)((Object)object)).getArchive().getName()) && this.getZipEntry().getName().equals(((ZipEntryStorage)((Object)object)).getZipEntry().getName());
    }

    public int hashCode() {
        return this.getZipEntry().getName().hashCode();
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public IProject getProject() {
        return this.fProject;
    }
}

