/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser;

import org.eclipse.datatools.sqltools.sql.parser.Messages;
import org.eclipse.datatools.sqltools.sql.parser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -5147769565793762975L;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        int maxSize = this.getExpectedTokenSequencesMaxSize();
        StringBuffer expected = this.buildExpectedTokenMessage();
        StringBuffer retval = this.buildShortMessage(maxSize);
        if (this.expectedTokenSequences.length == 1) {
            retval.append(Messages.ParseException_expecting).append(this.eol).append("    ");
        } else {
            retval.append(Messages.ParseException_expection_oneof).append(this.eol).append("    ");
        }
        retval.append(expected);
        return retval.toString();
    }

    private StringBuffer buildExpectedTokenMessage() {
        StringBuffer expected = new StringBuffer("");
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            int width = 0;
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
                width += this.tokenImage[this.expectedTokenSequences[i][j]].length() + 1;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
                width += 3;
            }
            expected.append(this.eol).append("    ");
        }
        return expected;
    }

    private StringBuffer buildShortMessage(int maxSize) {
        StringBuffer retval = new StringBuffer(Messages.ParseException_encountered);
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        retval.append(Messages.ParseException_period + this.eol);
        return retval;
    }

    public String getShortMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        int maxSize = this.getExpectedTokenSequencesMaxSize();
        StringBuffer retval = this.buildShortMessage(maxSize);
        return retval.toString();
    }

    private int getExpectedTokenSequencesMaxSize() {
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (maxSize >= this.expectedTokenSequences[i].length) continue;
            maxSize = this.expectedTokenSequences[i].length;
        }
        return maxSize;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

