/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.utils;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class XMLRelationInfoUtil {
    public static String concatRelationInfo(String originalStr, String newInfo) {
        if (originalStr == null || originalStr.trim().length() <= 0) {
            return newInfo;
        }
        return originalStr + "#-#" + newInfo;
    }

    public static String getTableRelationInfo(String info, String tableName) {
        String[] splitStr = info.split("\\Q#-#\\E");
        for (int i = 0; i < splitStr.length; ++i) {
            if (!splitStr[i].startsWith(tableName)) continue;
            if (splitStr[i].indexOf("#-TNAME-#") > 0) {
                String[] relationInfo = splitStr[i].split("#-TNAME-#");
                if (relationInfo.length != 2) continue;
                return relationInfo[1];
            }
            return splitStr[i];
        }
        return null;
    }

    private static int getRelationInfoSize(String info) {
        if (info == null || info.trim().length() <= 0) {
            return 0;
        }
        String[] splitStr = info.split("\\Q#-#\\E");
        return splitStr.length;
    }

    public static final String getUniqueName(String info) {
        String prefix = "table";
        StringBuffer buf = new StringBuffer();
        int n = XMLRelationInfoUtil.getRelationInfoSize(info);
        buf.append(prefix).append(n++);
        return buf.toString() + "#-TNAME-#" + buf.toString();
    }

    public static String replaceInfo(String tableName, String newString, String relationInformation) {
        if (tableName == null || newString == null) {
            return null;
        }
        if (relationInformation == null || relationInformation.trim().length() == 0) {
            return newString;
        }
        String[] splitStr = relationInformation.split("\\Q#-#\\E");
        for (int i = 0; i < splitStr.length; ++i) {
            if (!splitStr[i].startsWith(tableName)) continue;
            splitStr[i] = newString;
        }
        return XMLRelationInfoUtil.concatRealtionInfo(splitStr);
    }

    private static String concatRealtionInfo(String[] splitStr) {
        int i;
        String str = "";
        for (i = 0; i < splitStr.length; ++i) {
            if (splitStr[i] == null || splitStr[i].trim().length() <= 0) continue;
            str = splitStr[i];
            break;
        }
        for (i = 1; i < splitStr.length; ++i) {
            if (splitStr[i] == null || splitStr[i].trim().length() <= 0) continue;
            str = XMLRelationInfoUtil.concatRelationInfo(str, splitStr[i]);
        }
        return str;
    }

    private static int getTableRelationInfoIndex(String info, String tableName) {
        String[] splitStr = info.split("\\Q#-#\\E");
        for (int i = 0; i < splitStr.length; ++i) {
            if (!splitStr[i].startsWith(tableName)) continue;
            return i;
        }
        return -1;
    }

    public static String replaceXpathExpression(String tableName, String relationInfo, String xPath) {
        String infoStr = relationInfo;
        String[] splitStr = relationInfo.split("\\Q#-#\\E");
        String tableStr = splitStr[0];
        RelationInformation info = null;
        try {
            info = new RelationInformation(tableStr);
            String rootPath = info.getTableOriginalRootPath(tableName);
            tableStr = tableStr.replaceFirst("\\Q" + rootPath + "\\E", xPath);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        int index = XMLRelationInfoUtil.getTableRelationInfoIndex(infoStr, tableName);
        if (index >= 0) {
            splitStr[index] = tableStr;
            return XMLRelationInfoUtil.concatRealtionInfo(splitStr);
        }
        return infoStr;
    }

    public static String getTableName(String queryText) {
        RelationInformation info = null;
        if (queryText != null && queryText.trim().length() > 0) {
            try {
                info = new RelationInformation(queryText);
            }
            catch (OdaException e) {
                return null;
            }
            Iterator iter = info.getTableNames();
            if (iter.hasNext()) {
                return (String)iter.next();
            }
            return null;
        }
        return null;
    }

    public static String getXPathExpression(String queryText, String tableName) {
        RelationInformation info = null;
        if (queryText != null && queryText.trim().length() > 0) {
            try {
                info = new RelationInformation(queryText);
            }
            catch (OdaException e) {
                return null;
            }
            return info.getTableOriginalRootPath(tableName);
        }
        return null;
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }
}

