/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.impl.Connection;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public final class ResultSetTableViewer {
    private Table viewer;
    private Composite mainControl;
    private Button btnRefresh;
    private MenuItem itmRefresh;
    private String[][] resultSet;
    private TableColumn column;
    private final int MAX_ROW = 500;

    public ResultSetTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.mainControl.setLayout((Layout)layout);
        GridData data = null;
        this.viewer = new Table(this.mainControl, 65536);
        data = new GridData(1808);
        this.viewer.setLayoutData((Object)data);
        this.viewer.setHeaderVisible(true);
        this.viewer.setLinesVisible(true);
        if (showButtons) {
            Composite btnComposite = new Composite(this.mainControl, 0);
            data = new GridData();
            data.verticalAlignment = 0x1000000;
            btnComposite.setLayoutData((Object)data);
            GridLayout btnLayout = new GridLayout();
            layout.verticalSpacing = 20;
            btnComposite.setLayout((Layout)btnLayout);
            GridData btnData = new GridData(2);
            btnData.widthHint = 20;
            btnData.heightHint = 20;
            this.btnRefresh = new Button(btnComposite, 8);
            this.btnRefresh.setToolTipText("Preview the result set");
            this.btnRefresh.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW"));
            this.btnRefresh.setLayoutData((Object)btnData);
            this.btnRefresh.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ResultSetTableViewer.this.btnRefresh.setEnabled(false);
                    ResultSetTableViewer.this.retrieveResult();
                    ResultSetTableViewer.this.btnRefresh.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (showMenus) {
            Menu menu = new Menu((Control)this.viewer);
            this.itmRefresh = new MenuItem(menu, 0);
            this.itmRefresh.setText(Messages.getString("button.refresh"));
            this.itmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResultSetTableViewer.this.retrieveResult();
                }
            });
            this.viewer.setMenu(menu);
        }
        if (enableKeyStrokes) {
            this.viewer.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 65536) {
                        ResultSetTableViewer.this.retrieveResult();
                    }
                }
            });
        }
    }

    private void retrieveResult() {
        BusyIndicator.showWhile((Display)this.viewer.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResultSetTableViewer.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void refresh() {
        block15: {
            Connection conn = new Connection();
            IResultSet rs = null;
            Properties properties = new Properties();
            String xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE");
            if (xmlFile == null || xmlFile.trim().length() == 0) {
                xmlFile = XMLInformationHolder.getPropertyValue("FILELIST");
            }
            properties.setProperty("FILELIST", xmlFile == null ? "" : xmlFile);
            String xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
            properties.setProperty("ENCODINGLIST", xmlEncoding == null ? "" : xmlEncoding);
            conn.open(properties);
            IQuery query = conn.newQuery(null);
            int maxRow = Integer.parseInt(XMLInformationHolder.getPropertyValue("MAX_ROW") != null ? XMLInformationHolder.getPropertyValue("MAX_ROW") : "-1");
            query.setMaxRows(maxRow);
            query.prepare(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            rs = query.executeQuery();
            this.refreshTable(rs);
            Object var9_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
                break block15;
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            break block15;
            {
                catch (Exception ex) {
                    ExceptionHandler.showException(this.getControl().getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
                    Object var9_10 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        break block15;
                    }
                    catch (OdaException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (OdaException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void refreshTable(IResultSet rs) {
        this.viewer.removeAll();
        for (int i = 0; i < this.viewer.getColumnCount(); ++i) {
            this.viewer.getColumn(i).setText("");
        }
        while (this.viewer.getColumnCount() > 0) {
            this.viewer.getColumn(0).dispose();
        }
        int count = 0;
        String[] columnName = null;
        int rowCount = 0;
        if (rs != null) {
            int i;
            IResultSetMetaData metadata = null;
            try {
                int i2;
                metadata = rs.getMetaData();
                count = metadata.getColumnCount();
                this.resultSet = new String[500][count];
                columnName = new String[count];
                int[] columnType = new int[count];
                for (i2 = 0; i2 < count; ++i2) {
                    columnName[i2] = metadata.getColumnName(i2 + 1);
                    columnType[i2] = metadata.getColumnType(i2 + 1);
                }
                while (rs.next()) {
                    for (i2 = 0; i2 < count && rowCount < 500; ++i2) {
                        switch (columnType[i2]) {
                            case 12: {
                                this.resultSet[rowCount][i2] = rs.getString(i2 + 1);
                                break;
                            }
                            case 4: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getInt(i2 + 1));
                                break;
                            }
                            case 8: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getDouble(i2 + 1));
                                break;
                            }
                            case 91: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getDate(i2 + 1));
                                break;
                            }
                            case 92: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getTime(i2 + 1));
                                break;
                            }
                            case 93: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getTimestamp(i2 + 1));
                                break;
                            }
                            case 2: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBigDecimal(i2 + 1));
                                break;
                            }
                            case 2004: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBlob(i2 + 1));
                                break;
                            }
                            case 16: {
                                this.resultSet[rowCount][i2] = String.valueOf(rs.getBoolean(i2 + 1));
                                break;
                            }
                            default: {
                                this.resultSet[rowCount][i2] = rs.getString(i2 + 1);
                            }
                        }
                        if (!rs.wasNull()) continue;
                        this.resultSet[rowCount][i2] = null;
                    }
                    ++rowCount;
                }
                if (rowCount > 500) {
                    MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.getString("ColumnMappingDialog.prompt.dialog.title"), (String)Messages.getString("ColumnMappingDialog.prompt.maxRow"));
                    rowCount = 500;
                }
            }
            catch (OdaException e) {
                e.printStackTrace();
            }
            this.column = new TableColumn(this.viewer, 16384);
            this.column.setText(" ");
            this.column.setResizable(false);
            this.column.setWidth(20);
            for (i = 0; i < count; ++i) {
                this.column = this.viewer.getColumnCount() <= i + 1 ? new TableColumn(this.viewer, 16384) : this.viewer.getColumn(i + 1);
                this.column.setText(columnName[i]);
                this.column.setWidth(100);
                this.addColumnSortListener(this.column, i + 1);
            }
            for (i = 0; i < rowCount; ++i) {
                TableItem tableItem = new TableItem(this.viewer, 0);
                String[] record = new String[count + 1];
                for (int j = 0; j < count; ++j) {
                    record[j + 1] = this.resultSet[i][j];
                }
                tableItem.setText(record);
                this.viewer.redraw();
            }
        }
    }

    private void addColumnSortListener(TableColumn column, final int index) {
        column.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                ResultSetTableViewer.this.sort(index, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void sort(final int columnIndex, final boolean asc) {
        TableItem[] tableItems = this.viewer.getItems();
        Arrays.sort(tableItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                TableItem it1 = (TableItem)o1;
                TableItem it2 = (TableItem)o2;
                int result = 0;
                result = asc ? it1.getText(columnIndex).compareTo(it2.getText(columnIndex)) : it2.getText(columnIndex).compareTo(it1.getText(columnIndex));
                return result;
            }
        });
        String[][] records = this.mapTableItemsTo2DArray(tableItems);
        this.viewer.removeAll();
        for (int i = 0; i < tableItems.length; ++i) {
            TableItem tableItem = new TableItem(this.viewer, 0);
            tableItem.setText(records[i]);
        }
    }

    private String[][] mapTableItemsTo2DArray(TableItem[] tableItems) {
        String[][] records = new String[tableItems.length][this.viewer.getColumnCount()];
        for (int i = 0; i < tableItems.length; ++i) {
            for (int j = 0; j < this.viewer.getColumnCount(); ++j) {
                records[i][j] = tableItems[i].getText(j);
            }
        }
        return records;
    }

    public Table getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }

    public Button getRefreshButton() {
        return this.btnRefresh;
    }

    public MenuItem getRefreshMenu() {
        return this.itmRefresh;
    }
}

