/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding.proposal;

import java.util.Hashtable;

public class ResolvedVariable {
    public static final ResolvedVariable UNKNOWN = new ResolvedVariable();
    private static final Hashtable<String, ResolvedVariable> _globals = new Hashtable();
    private static final Hashtable<String, ResolvedVariable> _locals = new Hashtable();
    private static Hashtable<String, ResolvedVariable> _undetermined = null;
    private final String _name;
    private final ScopeKind _scope;

    private ResolvedVariable(ScopeKind scopeKind, String string) {
        assert (string != null) : "ResolvedVariable created with null name.";
        this._scope = scopeKind;
        this._name = string;
        switch (scopeKind) {
            case GLOBAL: {
                _globals.put(this._name, this);
                break;
            }
            case LOCAL: {
                _locals.put(this._name, this);
                break;
            }
            case UNDETERMINED: {
                if (_undetermined == null) {
                    _undetermined = new Hashtable();
                }
                _undetermined.put(this._name, this);
            }
        }
    }

    private ResolvedVariable() {
        this._name = null;
        this._scope = null;
    }

    public String getName() {
        return this._name;
    }

    public ScopeKind getScope() {
        return this._scope;
    }

    public String toString() {
        return "(" + (Object)((Object)this._scope) + "," + this._name + ")";
    }

    public static ResolvedVariable getBinding(ScopeKind scopeKind, String string) {
        ResolvedVariable resolvedVariable;
        if (string == null) {
            return UNKNOWN;
        }
        switch (scopeKind) {
            case GLOBAL: {
                resolvedVariable = _globals.get(string);
                break;
            }
            case LOCAL: {
                resolvedVariable = _locals.get(string);
                break;
            }
            case UNDETERMINED: {
                if (_undetermined == null) {
                    resolvedVariable = null;
                    break;
                }
                resolvedVariable = _undetermined.get(string);
                break;
            }
            default: {
                throw new AssertionError((Object)"Nonexistent scope value");
            }
        }
        if (resolvedVariable == null) {
            return new ResolvedVariable(scopeKind, string);
        }
        return resolvedVariable;
    }

    public static void printContents() {
        System.out.println("Globals:");
        for (ResolvedVariable resolvedVariable : _globals.values()) {
            System.out.println("  " + resolvedVariable);
        }
        System.out.println("Locals:");
        for (ResolvedVariable resolvedVariable : _locals.values()) {
            System.out.println("  " + resolvedVariable);
        }
        System.out.println("Undetermined:");
        if (_undetermined == null) {
            System.out.println("  None.");
        } else {
            for (ResolvedVariable resolvedVariable : _undetermined.values()) {
                System.out.println("  " + resolvedVariable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeKind {
        GLOBAL,
        LOCAL,
        UNDETERMINED;

    }
}

