/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal.cactus;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.server.core.internal.cactus.CactusLaunchable;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ClientDelegate;

public class JUnitClientDelegate
extends ClientDelegate {
    public IStatus launch(IServer server, Object object, String launchMode, ILaunch launch) {
        URL url;
        String urlString;
        CactusLaunchable launchable = (CactusLaunchable)object;
        ILaunchConfiguration config = this.findLaunchConfiguration(launchable, launchMode);
        if (config == null) {
            String testName = launchable.getTestName();
            testName = "".equals(testName) ? launchable.getTestClassName() : String.valueOf(launchable.getTestClassName()) + "." + testName + "()";
            config = this.createConfiguration(launchable.getProjectName(), testName, launchable.getTestClassName(), "", launchable.getTestName());
        }
        if ((urlString = (url = launchable.getCactusURL()).toString()).endsWith("/")) {
            try {
                url = new URL(urlString.substring(0, urlString.length() - 1));
            }
            catch (MalformedURLException e) {
                return new Status(4, "org.eclipse.jst.server.ui", 4, Messages.errorInternalCactus, (Throwable)e);
            }
        }
        try {
            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
            String vmArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, String.valueOf(vmArgs) + " -Dcactus.contextURL=" + url.toString());
            config = copy.doSave();
            DebugUITools.launch((ILaunchConfiguration)config, (String)launchMode);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.jst.server.ui", 4, Messages.errorInternalCactus, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected ILaunchConfiguration createConfiguration(String projectName, String name, String mainType, String container, String testName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", container);
            if (testName.length() > 0) {
                wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            config = wc.doSave();
        }
        catch (CoreException e) {
            JavaServerUIPlugin.log(e);
        }
        return config;
    }

    private ILaunchConfiguration findLaunchConfiguration(CactusLaunchable launchable, String mode) {
        String testName = launchable.getTestName();
        String testClass = launchable.getTestClassName();
        String javaProjectName = launchable.getProjectName();
        String container = "";
        ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "").equals(container) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(testClass) && config.getAttribute("org.eclipse.jdt.junit.TESTNAME", "").equals(testName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(javaProjectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaServerUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(JavaServerUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.LaunchTestAction_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(Messages.LaunchTestAction_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(Messages.LaunchTestAction_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchConfigurationType getJUnitLaunchConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.jdt.junit.launchconfig");
    }

    public boolean supports(IServer server, Object launchable, String launchMode) {
        return launchable instanceof CactusLaunchable;
    }
}

