/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.resources;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistryListener;

public class ExternalFilesRegistry {
    private static final ExternalFilesRegistry instance = new ExternalFilesRegistry();
    private final HashMap<String, IFile> externalFilesRegistry = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private IProject externalFilesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("external_" + System.currentTimeMillis());

    private ExternalFilesRegistry() {
    }

    public static ExternalFilesRegistry getInstance() {
        return instance;
    }

    public synchronized void addFileEntry(String string, IFile iFile) {
        if (!this.externalFilesRegistry.containsKey(string)) {
            this.externalFilesRegistry.put(string, iFile);
            this.notifyEntryChange(string, true);
        }
    }

    public IFile getFileEntry(String string) {
        IFile iFile = this.externalFilesRegistry.get(string);
        Collection<IFile> collection = this.externalFilesRegistry.values();
        for (IFile iFile2 : collection) {
            if (!iFile2.getFullPath().equals((Object)new Path(string))) continue;
            iFile = iFile2;
            break;
        }
        return iFile;
    }

    public synchronized void removeFileEntry(String string) {
        if (this.externalFilesRegistry.remove(string) != null) {
            this.notifyEntryChange(string, false);
        }
    }

    private void notifyEntryChange(String string, boolean bl) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (bl) {
                ((ExternalFilesRegistryListener)object).externalFileAdded(string);
            } else {
                ((ExternalFilesRegistryListener)object).externalFileRemoved(string);
            }
            ++n2;
        }
    }

    public boolean isEntryExist(String string) {
        if (this.externalFilesRegistry.containsKey(string)) {
            return true;
        }
        Collection<IFile> collection = this.externalFilesRegistry.values();
        for (IFile iFile : collection) {
            if (!iFile.getFullPath().equals((Object)new Path(string))) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryExist(IFile iFile) {
        if (iFile == null) {
            return false;
        }
        Collection<IFile> collection = this.externalFilesRegistry.values();
        for (IFile iFile2 : collection) {
            if (!iFile2.getFullPath().toOSString().equals(iFile.getFullPath().toOSString())) continue;
            return true;
        }
        return false;
    }

    public void addListener(ExternalFilesRegistryListener externalFilesRegistryListener) {
        this.listeners.add((Object)externalFilesRegistryListener);
    }

    public void removeListener(ExternalFilesRegistryListener externalFilesRegistryListener) {
        this.listeners.remove((Object)externalFilesRegistryListener);
    }

    public IFile[] getAllAsIFiles() {
        Collection<IFile> collection = this.externalFilesRegistry.values();
        IFile[] iFileArray = new ExternalFileWrapper[collection.size()];
        collection.toArray(iFileArray);
        return iFileArray;
    }

    public IProject getExternalFilesProject() {
        return this.externalFilesProject;
    }
}

