/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ResourceSetWorkbenchEditSynchronizer
extends ResourceSetWorkbenchSynchronizer
implements IResourceDeltaVisitor {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_EXTENSION = "java";
    private Set recentlySavedFiles = new HashSet();
    private Map ignoredFilesCache = new HashMap();
    protected List deferredRemoveResources = new ArrayList();
    protected List deferredUnloadResources = new ArrayList();
    protected List deferredLoadResources = new ArrayList();
    protected List autoloadResourcesURIs = new ArrayList();
    protected List autoloadResourcesExts = new ArrayList();
    private ILock lock;
    private static final long delay = 30L;

    public ResourceSetWorkbenchEditSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        super(aResourceSet, aProject);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent event) {
        super.resourceChanged(event);
        try {
            try {
                this.acceptDelta(event);
                this.notifyExtendersIfNecessary();
                this.processDeferredResources();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deferredRemoveResources.clear();
            this.deferredUnloadResources.clear();
            this.deferredLoadResources.clear();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.deferredRemoveResources.clear();
            this.deferredUnloadResources.clear();
            this.deferredLoadResources.clear();
            return;
        }
    }

    protected void processDeferredRemovedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredRemoveResources.size()) {
            resource = (Resource)this.deferredRemoveResources.get(i);
            this.resourceSet.getResources().remove((Object)resource);
            resource.unload();
            ++i;
        }
    }

    protected void processDeferredUnloadedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredUnloadResources.size()) {
            resource = (Resource)this.deferredUnloadResources.get(i);
            resource.unload();
            ++i;
        }
    }

    private void processDeferredLoadResources() {
        URI uri = null;
        int i = 0;
        while (i < this.deferredLoadResources.size()) {
            uri = (URI)this.deferredLoadResources.get(i);
            try {
                this.resourceSet.getResource(uri, true);
            }
            catch (WrappedException ex) {
                Logger.getLogger().logError((Throwable)ex);
            }
            ++i;
        }
    }

    private ILock getLock() {
        if (this.lock == null) {
            this.lock = Platform.getJobManager().newLock();
        }
        return this.lock;
    }

    private void releaseLock() {
        this.getLock().release();
    }

    private boolean aquireLock() throws InterruptedException {
        return this.getLock().acquire(30L);
    }

    /*
     * Exception decompiling
     */
    protected void acceptDelta(IResourceChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 107->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void primAcceptDelta(IResourceDelta delta, IResourceChangeEvent event) {
        if (delta != null) {
            try {
                this.currentProjectDelta = null;
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void release() {
        if (!JEMUtilPlugin.isActivated()) return;
        try {
            if (this.resourceSet instanceof ProjectResourceSet) {
                ((ProjectResourceSet)this.resourceSet).release();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
            this.dispose();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
        this.dispose();
    }

    private void processDeferredResources() {
        this.processDeferredRemovedResources();
        this.processDeferredUnloadedResources();
        this.processDeferredLoadResources();
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                IProject p = (IProject)resource;
                if (this.isInterrestedInProject(p)) {
                    this.currentProjectDelta = delta;
                    return true;
                }
                return false;
            }
            if (resource.getType() == 1 && this.isInterrestedInFile((IFile)resource)) {
                switch (delta.getKind()) {
                    case 2: {
                        this.removedResource((IFile)resource);
                        break;
                    }
                    case 1: {
                        this.addedResource((IFile)resource);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x100) == 0) break;
                        this.changedResource((IFile)resource);
                        break;
                    }
                    default: {
                        if ((delta.getFlags() & 0x1000) == 0 && (delta.getFlags() & 0x2000) == 0) break;
                        this.movedResource((IFile)resource);
                    }
                }
                return false;
            }
        }
        return true;
    }

    protected boolean removedResource(IFile aFile) {
        return this.processResource(aFile, true);
    }

    protected boolean addedResource(IFile aFile) {
        boolean didProcess = false;
        Resource resource = this.getResource(aFile);
        if (resource != null || this.recentlySavedFiles.contains(resource)) {
            if (resource.isModified()) {
                ReferencedResource refRes;
                if (WorkbenchResourceHelper.isReferencedResource(resource) && (refRes = (ReferencedResource)resource).shouldForceRefresh()) {
                    this.deferredUnloadResources.add(resource);
                    didProcess = true;
                }
            } else if (resource.isLoaded()) {
                if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                    if (!WorkbenchResourceHelper.isConsistent((ReferencedResource)resource)) {
                        this.deferredUnloadResources.add(resource);
                        didProcess = true;
                    }
                } else {
                    this.deferredUnloadResources.add(resource);
                    didProcess = true;
                }
            }
        } else {
            URI uri = URI.createPlatformResourceURI((String)aFile.getFullPath().toString());
            if (this.autoloadResourcesURIs.contains(uri) || this.autoloadResourcesExts.contains(aFile.getFileExtension())) {
                this.deferredLoadResources.add(uri);
                didProcess = true;
            }
        }
        return didProcess;
    }

    protected boolean processResource(IFile aFile, boolean isRemove) {
        Resource resource = this.getResource(aFile);
        if (resource != null || this.recentlySavedFiles.contains(resource)) {
            if (resource.isModified()) {
                if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                    ReferencedResource refRes = (ReferencedResource)resource;
                    if (!refRes.shouldForceRefresh()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (isRemove) {
                this.deferredRemoveResources.add(resource);
            } else if (resource.isLoaded()) {
                if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                    if (!WorkbenchResourceHelper.isConsistent((ReferencedResource)resource)) {
                        this.deferredUnloadResources.add(resource);
                    }
                } else {
                    this.deferredUnloadResources.add(resource);
                }
            }
        }
        return false;
    }

    protected boolean movedResource(IFile aFile) {
        return this.removedResource(aFile);
    }

    protected boolean changedResource(IFile aFile) {
        return this.processResource(aFile, false);
    }

    protected Resource getResource(IFile aFile) {
        return this.resourceSet.getResource(URI.createPlatformResourceURI((String)aFile.getFullPath().toString()), false);
    }

    public void preSave(IFile aFile) {
        if (aFile != null) {
            this.recentlySavedFiles.add(aFile);
            this.ignoredFilesCache.remove(aFile);
        }
    }

    public void removeFromRecentlySavedList(IFile aFile) {
        if (aFile != null) {
            this.recentlySavedFiles.remove(aFile);
            this.ignoredFilesCache.remove(aFile);
        }
    }

    public void postSave(IFile aFile) {
    }

    protected boolean isInterrestedInProject(IProject aProject) {
        return aProject.equals((Object)this.getProject());
    }

    protected boolean isInterrestedInFile(IFile aFile) {
        String extension = aFile.getFileExtension();
        if (CLASS_EXTENSION.equals(extension) || JAVA_EXTENSION.equals(extension)) {
            return false;
        }
        if (this.recentlySavedFiles.remove(aFile)) {
            this.cacheIgnored(aFile);
            return false;
        }
        return !this.hasIgnored(aFile);
    }

    private boolean hasIgnored(IFile file) {
        Long cachedStamp = (Long)this.ignoredFilesCache.get(file);
        if (cachedStamp == null) {
            return false;
        }
        long stamp = WorkbenchResourceHelper.computeModificationStamp(file);
        return cachedStamp == stamp;
    }

    private void cacheIgnored(IFile file) {
        long stamp = WorkbenchResourceHelper.computeModificationStamp(file);
        this.ignoredFilesCache.put(file, new Long(stamp));
    }

    public void enableAutoload(URI uri) {
        URI normalized = this.resourceSet.getURIConverter().normalize(uri);
        this.autoloadResourcesURIs.add(normalized);
    }

    public void disableAutoload(URI uri) {
        URI normalized = this.resourceSet.getURIConverter().normalize(uri);
        this.autoloadResourcesURIs.remove(normalized);
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    public void enableAutoload(String extension) {
        this.autoloadResourcesExts.add(extension);
    }

    public void disableAutoload(String extension) {
        this.autoloadResourcesExts.remove(extension);
    }

    public void dispose() {
        super.dispose();
        this.currentProjectDelta = null;
        this.extenders = null;
    }
}

