/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import org.eclipse.datatools.enablement.oda.xml.util.XPathParserUtil;

public class SaxParserUtil {
    public static final String TEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN$-";
    public static final String ROOTTEMPCOLUMNNAMEPREFIX = "-$TEMP_XML_COLUMN_ROOT$-";

    public static boolean isSamePath(String path, String generatedPath) {
        return XPathParserUtil.match(generatedPath, path);
    }

    public static String processParentAxis(String path) {
        int i;
        String prefix = "";
        if (path.startsWith("//")) {
            path = path.replaceFirst("//", "");
            prefix = "//";
        } else if (path.startsWith("/")) {
            path = path.replaceFirst("/", "");
            prefix = "/";
        }
        String[] temp = path.split("/");
        block0: for (i = 0; i < temp.length; ++i) {
            if (!temp[i].equals("..")) continue;
            temp[i] = null;
            for (int j = i - 1; j >= 0; --j) {
                if (temp[j] == null) continue;
                temp[j] = null;
                continue block0;
            }
        }
        path = prefix;
        for (i = 0; i < temp.length; ++i) {
            if (temp[i] == null) continue;
            path = i == 0 ? path + temp[i] : path + (temp[i].startsWith("[") ? "" : "/") + temp[i];
        }
        if (path.startsWith("///")) {
            path = path.replaceFirst("\\Q/\\E", "");
        }
        return path;
    }

    static String createTempColumnName(int index) {
        return TEMPCOLUMNNAMEPREFIX + index;
    }

    static String createTableRootTempColumnNameForFilter() {
        return ROOTTEMPCOLUMNNAMEPREFIX;
    }

    static boolean isTempColumn(String name) {
        if (name == null) {
            return false;
        }
        return name.startsWith(TEMPCOLUMNNAMEPREFIX) || name.startsWith(ROOTTEMPCOLUMNNAMEPREFIX);
    }
}

