/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterHTML
implements INodeAdapter {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.html.ui/projectionperf"));
    ProjectionModelNodeAdapterFactoryHTML fAdapterFactory;
    protected Map<ProjectionAnnotation, Position> previousAnnotations = new HashMap<ProjectionAnnotation, Position>();

    public ProjectionModelNodeAdapterHTML(ProjectionModelNodeAdapterFactoryHTML projectionModelNodeAdapterFactoryHTML) {
        this.fAdapterFactory = projectionModelNodeAdapterFactoryHTML;
    }

    private Position createProjectionPosition(Node node) {
        Position position = null;
        if (this.fAdapterFactory.isNodeProjectable(node) && node instanceof IndexedRegion) {
            IndexedRegion indexedRegion = (IndexedRegion)node;
            int n = indexedRegion.getStartOffset();
            int n2 = indexedRegion.getEndOffset();
            if (n >= 0 && n < n2) {
                position = new Position(n, n2 - n);
            }
        }
        return position;
    }

    private TagProjectionAnnotation getExistingAnnotation(Node node) {
        TagProjectionAnnotation tagProjectionAnnotation = null;
        if (node != null && !this.previousAnnotations.isEmpty()) {
            Iterator<ProjectionAnnotation> iterator = this.previousAnnotations.keySet().iterator();
            while (iterator.hasNext() && tagProjectionAnnotation == null) {
                TagProjectionAnnotation tagProjectionAnnotation2 = (TagProjectionAnnotation)iterator.next();
                Node node2 = tagProjectionAnnotation2.getNode();
                if (!node.equals(node2)) continue;
                tagProjectionAnnotation = tagProjectionAnnotation2;
            }
        }
        return tagProjectionAnnotation;
    }

    public boolean isAdapterForType(Object object) {
        return object == ProjectionModelNodeAdapterHTML.class;
    }

    public void notifyChanged(INodeNotifier iNodeNotifier, int n, Object object, Object object2, Object object3, int n2) {
        if (!this.fAdapterFactory.isActive()) {
            return;
        }
        if (n == 4 && iNodeNotifier instanceof Node) {
            this.updateAdapter((Node)iNodeNotifier);
        }
    }

    public void updateAdapter(Node node) {
        this.updateAdapter(node, null);
    }

    void updateAdapter(Node node, ProjectionViewer projectionViewer) {
        Object object;
        long l = System.currentTimeMillis();
        HashMap<String, ProjectionAnnotation[]> hashMap = new HashMap<String, ProjectionAnnotation[]>();
        HashMap<ProjectionAnnotation, Position> hashMap2 = new HashMap<ProjectionAnnotation, Position>();
        if (node != null) {
            ProjectionAnnotation[] projectionAnnotationArray;
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                projectionAnnotationArray = this.createProjectionPosition(node2);
                if (projectionAnnotationArray != null) {
                    object = new TagProjectionAnnotation(node2, false);
                    TagProjectionAnnotation tagProjectionAnnotation = this.getExistingAnnotation(node2);
                    if (tagProjectionAnnotation == null) {
                        hashMap2.put((ProjectionAnnotation)object, (Position)projectionAnnotationArray);
                        hashMap.put((String)object, projectionAnnotationArray);
                    } else {
                        hashMap2.put(tagProjectionAnnotation, (Position)projectionAnnotationArray);
                        this.previousAnnotations.remove((Object)tagProjectionAnnotation);
                    }
                }
                node2 = node2.getNextSibling();
            }
            projectionAnnotationArray = null;
            if (!this.previousAnnotations.isEmpty()) {
                projectionAnnotationArray = this.previousAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            hashMap2.isEmpty();
            if (projectionViewer != null && !hashMap2.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, hashMap2, null, projectionViewer);
            }
            if (projectionAnnotationArray != null && projectionAnnotationArray.length > 0 || !hashMap.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])projectionAnnotationArray, hashMap, new HashMap());
            }
        }
        this.previousAnnotations = hashMap2;
        if (debugProjectionPerf) {
            long l2 = System.currentTimeMillis();
            object = node != null ? node.getNodeName() : "null";
            System.out.println("ProjectionModelNodeAdapterHTML.updateAdapter (" + object + "):" + (l2 - l));
        }
    }

    private static class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean bl) {
            super(bl);
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void setNode(Node node) {
            this.fNode = node;
        }

        public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
            FontMetrics fontMetrics;
            if (!this.isCollapsed() && (fontMetrics = gC.getFontMetrics()) != null && rectangle.height / fontMetrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gC, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

