/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.php.internal.core.util.preferences.Key;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPFormatterConfigurationBlock
extends PHPCoreOptionsConfigurationBlock
implements ModifyListener,
SelectionListener {
    public static final Key PREF_FORMATTER_USE_TABS = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterUseTabs");
    public static final Key PREF_FORMATTER_INDENTATION_SIZE = PHPFormatterConfigurationBlock.getPHPCoreKey("org.eclipse.php.core.phpForamtterIndentationSize");
    private static final int MIN_INDENT_SIZE = 0;
    private static final int MAX_INDENT_SIZE = 32;
    private IStatus fFormatterStatus = new StatusInfo();
    private Combo tabPolicyCombo;
    private Text indentSizeTxt;
    private boolean fUseTabs;
    private int fIndentationSize;

    public PHPFormatterConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, PHPFormatterConfigurationBlock.getKeys(), iWorkbenchPreferenceContainer);
    }

    public Control createContents(Composite composite) {
        this.setShell(composite.getShell());
        Composite composite2 = this.createFormaterContent(composite);
        this.validateSettings(null, null, null);
        return composite2;
    }

    private Composite createFormaterContent(Composite composite) {
        Group group = this.createComposite(composite, 2);
        String[] stringArray = new String[]{PHPUIMessages.getString("PHPFormatterConfigurationBlock_tabsLabel"), PHPUIMessages.getString("PHPFormatterConfigurationBlock_spacesLabel")};
        Label label = new Label((Composite)group, 0);
        label.setText(PHPUIMessages.getString("PHPFormatterConfigurationBlock_tabPolicyLabel"));
        this.tabPolicyCombo = new Combo((Composite)group, 8);
        this.tabPolicyCombo.setItems(stringArray);
        this.tabPolicyCombo.select(0);
        GridData gridData = new GridData();
        gridData.widthHint = 20;
        Label label2 = new Label((Composite)group, 0);
        label2.setText(PHPUIMessages.getString("PHPFormatterConfigurationBlock_indentSizeLabel"));
        this.indentSizeTxt = new Text((Composite)group, 2048);
        this.indentSizeTxt.setTextLimit(2);
        this.indentSizeTxt.setLayoutData((Object)gridData);
        this.tabPolicyCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.getSource();
                int n = combo.getSelectionIndex();
                if (n == 1) {
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setEnabled(true);
                } else {
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setEnabled(false);
                    PHPFormatterConfigurationBlock.this.indentSizeTxt.setText("1");
                }
            }
        });
        this.indentSizeTxt.addModifyListener((ModifyListener)this);
        this.tabPolicyCombo.addSelectionListener((SelectionListener)this);
        this.initValues();
        this.updateValues();
        return group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(Key key, String string, String string2) {
        block5: {
            if (key != null) {
                if (!PREF_FORMATTER_INDENTATION_SIZE.equals(key)) return;
                try {
                    this.fIndentationSize = Integer.valueOf(string2);
                    if (this.fIndentationSize < 0 || this.fIndentationSize > 32) {
                        this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.getString("PHPFormatterConfigurationBlock_indentSizeErrorMessage"));
                        break block5;
                    }
                    this.setValue(PREF_FORMATTER_INDENTATION_SIZE, String.valueOf(this.fIndentationSize));
                    this.fFormatterStatus = new StatusInfo();
                }
                catch (NumberFormatException numberFormatException) {
                    this.fFormatterStatus = new StatusInfo(4, PHPUIMessages.getString("PHPFormatterConfigurationBlock_indentSizeErrorMessage"));
                }
            } else {
                this.fFormatterStatus = new StatusInfo();
            }
        }
        this.fContext.statusChanged(this.fFormatterStatus);
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_FORMATTER_USE_TABS, PREF_FORMATTER_INDENTATION_SIZE};
    }

    private Group createComposite(Composite composite, int n) {
        Group group = new Group(composite, 0);
        group.setText(PHPUIMessages.getString("PHPFormatterConfigurationBlock.0"));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.marginTop = 5;
        gridLayout.marginBottom = 5;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 128, true, false);
        group.setLayoutData((Object)gridData);
        group.setLayoutData((Object)gridData);
        return group;
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget != null && modifyEvent.widget.isDisposed()) {
            return;
        }
        this.validateValues(modifyEvent.widget);
    }

    protected void validateValues(Widget widget) {
        Text text = (Text)widget;
        String string = text.getText();
        this.validateSettings(PREF_FORMATTER_INDENTATION_SIZE, new Integer(this.fIndentationSize).toString(), string);
    }

    protected void updateControls() {
        this.initValues();
        this.updateValues();
    }

    private void initValues() {
        String string = this.getValue(PREF_FORMATTER_USE_TABS);
        String string2 = this.getValue(PREF_FORMATTER_INDENTATION_SIZE);
        this.fUseTabs = Boolean.valueOf(string);
        this.fIndentationSize = Integer.valueOf(string2);
        this.indentSizeTxt.setText(string2);
    }

    private void updateValues() {
        if (this.fUseTabs) {
            this.tabPolicyCombo.select(0);
            this.indentSizeTxt.setEnabled(false);
        } else {
            this.tabPolicyCombo.select(1);
            this.indentSizeTxt.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.updateButtonStatus((Combo)selectionEvent.widget);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.updateButtonStatus((Combo)selectionEvent.widget);
    }

    private void updateButtonStatus(Combo combo) {
        this.fUseTabs = combo.getSelectionIndex() == 0;
        this.setValue(PREF_FORMATTER_USE_TABS, this.fUseTabs ? "true" : "false");
    }
}

