/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class PHPSearchEditorOpener {
    private IEditorPart fEditor;

    public IEditorPart openElement(Object object) throws PartInitException {
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(object, iWorkbenchPage);
        }
        return this.showWithoutReuse(object, iWorkbenchPage);
    }

    public IEditorPart openMatch(Match match) throws PartInitException {
        Object object = this.getElementToOpen(match);
        return this.openElement(object);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object object, IWorkbenchPage iWorkbenchPage) throws PartInitException {
        return EditorUtility.openInEditor(object, false);
    }

    private IEditorPart showWithReuse(Object object, IWorkbenchPage iWorkbenchPage) throws PartInitException {
        IFile iFile = this.getFile(object);
        if (iFile != null) {
            String string = this.getEditorID(iFile);
            return this.showInEditor(iWorkbenchPage, (IEditorInput)new FileEditorInput(iFile), string);
        }
        return null;
    }

    private IFile getFile(Object object) {
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof IAdaptable) {
            return (IFile)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    private String getEditorID(IFile iFile) throws PartInitException {
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
        if (iEditorDescriptor == null) {
            return PHPUiPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return iEditorDescriptor.getId();
    }

    private boolean isPinned(IEditorPart iEditorPart) {
        if (iEditorPart == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = iEditorPart.getEditorSite().getPage().getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            if (iEditorPart.equals(iEditorReferenceArray[n].getEditor(false))) {
                return iEditorReferenceArray[n].isPinned();
            }
            ++n;
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage iWorkbenchPage, IEditorInput iEditorInput, String string) {
        IEditorPart iEditorPart = iWorkbenchPage.findEditor(iEditorInput);
        if (iEditorPart != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
        } else {
            int n;
            boolean bl = false;
            if (this.fEditor != null) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                n = 0;
                while (!bl && n < iEditorReferenceArray.length) {
                    boolean bl2 = bl = this.fEditor == iEditorReferenceArray[n++].getEditor(false);
                }
            }
            boolean bl3 = bl && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            int n2 = n = this.fEditor != null && this.fEditor.getSite().getId().equals(string) ? 1 : 0;
            if (bl3 && n == 0) {
                iWorkbenchPage.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (bl3 && n != 0) {
                ((IReusableEditor)this.fEditor).setInput(iEditorInput);
                iWorkbenchPage.bringToTop((IWorkbenchPart)this.fEditor);
                iEditorPart = this.fEditor;
            } else {
                try {
                    iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, false);
                    this.fEditor = iEditorPart instanceof IReusableEditor ? iEditorPart : null;
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)PHPUIMessages.getString("Search_Error_openEditor_title"), (String)PHPUIMessages.getString("Search_Error_openEditor_message"));
                    return null;
                }
            }
        }
        return iEditorPart;
    }
}

