/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void log(Throwable throwable, String string) {
        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", 10001, string, throwable));
    }

    public static void handle(CoreException coreException, String string, String string2) {
        ExceptionHandler.handle(coreException, PHPUiPlugin.getActiveWorkbenchShell(), string, string2);
    }

    public static void handle(CoreException coreException, Shell shell, String string, String string2) {
        fgInstance.perform(coreException, shell, string, string2);
    }

    public static void handle(InvocationTargetException invocationTargetException, String string, String string2) {
        ExceptionHandler.handle(invocationTargetException, PHPUiPlugin.getActiveWorkbenchShell(), string, string2);
    }

    public static void handle(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        fgInstance.perform(invocationTargetException, shell, string, string2);
    }

    protected void perform(CoreException coreException, Shell shell, String string, String string2) {
        PHPUiPlugin.log(coreException);
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        } else {
            this.displayMessageDialog(coreException, coreException.getMessage(), shell, string, string2);
        }
    }

    protected void perform(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof CoreException) {
            this.perform((CoreException)throwable, shell, string, string2);
        } else {
            PHPUiPlugin.log(invocationTargetException);
            if (invocationTargetException.getMessage() != null && invocationTargetException.getMessage().length() > 0) {
                this.displayMessageDialog(invocationTargetException, invocationTargetException.getMessage(), shell, string, string2);
            } else {
                this.displayMessageDialog(invocationTargetException, throwable.getMessage(), shell, string, string2);
            }
        }
    }

    private void displayMessageDialog(Throwable throwable, String string, Shell shell, String string2, String string3) {
        StringWriter stringWriter = new StringWriter();
        if (string3 != null) {
            stringWriter.write(string3);
            stringWriter.write("\n\n");
        }
        if (string == null || string.length() == 0) {
            stringWriter.write(PHPUIMessages.getString("ExceptionDialog_seeErrorLogMessage"));
        } else {
            stringWriter.write(string);
        }
        MessageDialog.openError((Shell)shell, (String)string2, (String)stringWriter.toString());
    }
}

