/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;

public class PHPManual
implements IPropertyChangeListener {
    private static final String BROWSER_ID = "PHPManual.browser";
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("http://[^\\s]*");
    private static int browserCount = 0;
    private PHPManualSite site;
    private boolean openManualInNewBrowser;
    private IPreferenceStore fStore;
    private static Map phpEntityPathMap;

    public PHPManual(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
        this.fStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.initPreferences();
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this, (Object)this.fStore));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("phpManualOpenInNewBrowser")) {
            this.initPreferences();
        }
    }

    public void initPreferences() {
        this.openManualInNewBrowser = this.fStore.getBoolean("phpManualOpenInNewBrowser");
    }

    public PHPManualSite getSite() {
        return this.site;
    }

    public void setSite(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
    }

    private synchronized Map getPHPEntityPathMap() {
        if (phpEntityPathMap == null) {
            phpEntityPathMap = new HashMap();
            URL uRL = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path("phpdoc.mapping"), null);
            if (uRL != null) {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        int n = string.indexOf(61);
                        if (n == -1) continue;
                        phpEntityPathMap.put(string.substring(0, n).toLowerCase(), string.substring(n + 1));
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return phpEntityPathMap;
    }

    private String buildPathForMethod(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function.");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("-");
        }
        stringBuffer.append(Pattern.compile("([A-Z])").matcher(string2).replaceAll("-$1").replaceAll("_", "-"));
        return stringBuffer.toString().toLowerCase().replaceAll("-+", "-");
    }

    public String getURLForManual(PHPCodeData pHPCodeData) {
        Object object;
        PHPCodeData pHPCodeData2;
        Object object2;
        if (pHPCodeData == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        PHPDocBlock pHPDocBlock = pHPCodeData.getDocBlock();
        if (pHPDocBlock != null) {
            object2 = pHPDocBlock.getTags(23);
            while (object2.hasNext()) {
                pHPCodeData2 = (PHPDocTag)object2.next();
                object = HTTP_URL_PATTERN.matcher(pHPCodeData2.getValue().trim());
                if (!((Matcher)object).find()) continue;
                try {
                    URL uRL = new URL(((Matcher)object).group());
                    string = new File(uRL.getFile()).getName();
                    int n = string.lastIndexOf(46);
                    if (n <= 0) break;
                    string = string.substring(0, n);
                    break;
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        if (string == null) {
            if (pHPCodeData instanceof PHPFunctionData) {
                object2 = (PHPFunctionData)pHPCodeData;
                pHPCodeData2 = object2.getContainer();
                if (pHPCodeData2 instanceof PHPClassData) {
                    object = String.valueOf(pHPCodeData2.getName()) + "::" + object2.getName();
                    string = (String)this.getPHPEntityPathMap().get(((String)object).toLowerCase());
                    if (string == null) {
                        string = this.buildPathForMethod(pHPCodeData2.getName(), object2.getName());
                    }
                } else {
                    string = (String)this.getPHPEntityPathMap().get(object2.getName().toLowerCase());
                    if (string == null) {
                        string = this.buildPathForMethod(null, object2.getName());
                    }
                }
            } else if (pHPCodeData instanceof PHPKeywordData) {
                string = (String)this.getPHPEntityPathMap().get(pHPCodeData.getName().toLowerCase());
            }
        }
        if (string == null) {
            return null;
        }
        object2 = new StringBuffer();
        ((StringBuffer)object2).append(this.site.getUrl());
        if (!this.site.getUrl().endsWith("/")) {
            ((StringBuffer)object2).append("/");
        }
        ((StringBuffer)object2).append(string);
        ((StringBuffer)object2).append(".");
        ((StringBuffer)object2).append(this.site.getExtension());
        return ((StringBuffer)object2).toString();
    }

    public void showFunctionHelp(String string) {
        IWorkbenchBrowserSupport iWorkbenchBrowserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser iWebBrowser = this.openManualInNewBrowser ? iWorkbenchBrowserSupport.createBrowser(BROWSER_ID + ++browserCount) : iWorkbenchBrowserSupport.createBrowser(BROWSER_ID);
            if (string.startsWith("mk:")) {
                iWebBrowser.openURL(new URL(null, string, new MkHandler()));
            } else {
                iWebBrowser.openURL(new URL(string));
            }
        }
        catch (PartInitException partInitException) {
            Logger.logException(partInitException);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logException(malformedURLException);
        }
    }

    private class MkHandler
    extends URLStreamHandler {
        private MkHandler() {
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            return null;
        }
    }
}

