/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.workingset.EditorTracker;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;

public class HistoryWorkingSetUpdater
implements IWorkingSetUpdater {
    public static final String ID = "org.eclipse.php.ui.HistoryWorkingSet";
    private IWorkingSet fWorkingSet;
    private Set fOpenFiles = new HashSet();
    private Tracker fTracker;
    private ModelListener fPHPListener;
    private int fMaxElements = 15;
    private IResourceChangeListener fResourceChangeListener;

    public HistoryWorkingSetUpdater() {
        this.initListeners();
    }

    public void add(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == null ? 1 : 0) != 0);
        this.fWorkingSet = iWorkingSet;
    }

    public boolean remove(IWorkingSet iWorkingSet) {
        Assert.isTrue((this.fWorkingSet == iWorkingSet ? 1 : 0) != 0);
        this.fWorkingSet = null;
        return true;
    }

    public boolean contains(IWorkingSet iWorkingSet) {
        return this.fWorkingSet == iWorkingSet;
    }

    public void dispose() {
        if (this.fTracker != null) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            iWorkbench.removeWindowListener((IWindowListener)this.fTracker);
            IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
            int n = 0;
            while (n < iWorkbenchWindowArray.length) {
                iWorkbenchWindowArray[n].removePageListener((IPageListener)this.fTracker);
                IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
                int n2 = 0;
                while (n2 < iWorkbenchPageArray.length) {
                    iWorkbenchPageArray[n2].removePartListener((IPartListener)this.fTracker);
                    ++n2;
                }
                ++n;
            }
            this.fTracker = null;
        }
        if (this.fPHPListener != null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener(this.fPHPListener);
            this.fPHPListener = null;
        }
        if (this.fResourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceChangeListener);
            this.fResourceChangeListener = null;
        }
    }

    private void initListeners() {
        this.fTracker = new Tracker();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        iWorkbench.addWindowListener((IWindowListener)this.fTracker);
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            iWorkbenchWindowArray[n].addPageListener((IPageListener)this.fTracker);
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                iWorkbenchPageArray[n2].addPartListener((IPartListener)this.fTracker);
                ++n2;
            }
            ++n;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceChangeListener, 1);
        this.fPHPListener = new ModelListener(){

            public void fileDataChanged(PHPFileData pHPFileData) {
                IFile iFile = (IFile)PHPModelUtil.getResource((Object)pHPFileData);
                HistoryWorkingSetUpdater.this.elementSaved((IAdaptable)iFile);
            }

            public void fileDataAdded(PHPFileData pHPFileData) {
            }

            public void fileDataRemoved(PHPFileData pHPFileData) {
                IFile iFile = (IFile)PHPModelUtil.getResource((Object)pHPFileData);
                HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)iFile);
            }

            public void dataCleared() {
            }
        };
        PHPWorkspaceModelManager.getInstance().addModelListener(this.fPHPListener);
    }

    private void elementSaved(IAdaptable iAdaptable) {
        if (!this.fOpenFiles.contains(iAdaptable)) {
            return;
        }
        this.updateHistory(iAdaptable);
    }

    private void elementRemoved(IAdaptable iAdaptable) {
        this.fOpenFiles.remove(iAdaptable);
        List list = this.getElements();
        if (list.remove(iAdaptable)) {
            this.setElements(list);
        }
    }

    private void elementMoved(IAdaptable iAdaptable, IAdaptable iAdaptable2) {
        List list = this.getElements();
        int n = list.indexOf(iAdaptable);
        if (n == -1) {
            return;
        }
        list.set(n, iAdaptable2);
        this.fOpenFiles.remove(iAdaptable);
        this.fOpenFiles.add(iAdaptable2);
        this.setElements(list);
    }

    private void projectClosed(IProject iProject) {
        List list = this.getElements();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IAdaptable iAdaptable = (IAdaptable)iterator.next();
            IProject iProject2 = this.getProject(iAdaptable);
            if (!iProject.equals((Object)iProject2)) continue;
            iterator.remove();
            ++n;
        }
        if (n > 0) {
            this.setElements(list);
        }
    }

    private IProject getProject(IAdaptable iAdaptable) {
        if (iAdaptable instanceof IResource) {
            return ((IResource)iAdaptable).getProject();
        }
        if (iAdaptable instanceof PHPCodeData) {
            return PHPModelUtil.getResource((Object)((PHPCodeData)iAdaptable)).getProject();
        }
        return null;
    }

    private void updateHistory(IAdaptable iAdaptable) {
        List list = this.getElements();
        int n = list.indexOf(iAdaptable);
        if (n != -1) {
            list.remove(n);
            list.add(0, iAdaptable);
        } else {
            if (list.size() == this.fMaxElements) {
                list.remove(list.size() - 1);
            }
            list.add(0, iAdaptable);
        }
        this.setElements(list);
    }

    private List getElements() {
        return new ArrayList(Arrays.asList(this.fWorkingSet.getElements()));
    }

    private void setElements(List list) {
        this.fWorkingSet.setElements(list.toArray(new IAdaptable[list.size()]));
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                iResourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                        IResource iResource = iResourceDelta.getResource();
                        if (iResource.getType() != 1) {
                            return true;
                        }
                        IFile iFile = (IFile)iResource;
                        if ((iResourceDelta.getKind() & 4) != 0) {
                            if ((iResourceDelta.getFlags() & 0x100) != 0) {
                                HistoryWorkingSetUpdater.this.elementSaved((IAdaptable)iFile);
                            }
                        } else if ((iResourceDelta.getKind() & 2) != 0) {
                            if ((iResourceDelta.getFlags() & 0x2000) != 0) {
                                IFile iFile2 = ResourcesPlugin.getWorkspace().getRoot().getFile(iResourceDelta.getMovedToPath());
                                if (!iFile2.exists()) {
                                    HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)iFile);
                                } else {
                                    HistoryWorkingSetUpdater.this.elementMoved((IAdaptable)iFile, (IAdaptable)iFile2);
                                }
                            } else {
                                HistoryWorkingSetUpdater.this.elementRemoved((IAdaptable)iFile);
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException coreException) {}
        }
    }

    private class Tracker
    extends EditorTracker {
        private Tracker() {
        }

        public void editorOpened(IEditorPart iEditorPart) {
            IAdaptable iAdaptable = this.getInput(iEditorPart);
            if (iAdaptable == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.add(iAdaptable);
        }

        public void editorClosed(IEditorPart iEditorPart) {
            IAdaptable iAdaptable = this.getInput(iEditorPart);
            if (iAdaptable == null) {
                return;
            }
            HistoryWorkingSetUpdater.this.fOpenFiles.remove(iAdaptable);
        }

        private IAdaptable getInput(IEditorPart iEditorPart) {
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (!(iEditorInput instanceof IFileEditorInput)) {
                return null;
            }
            return ((IFileEditorInput)iEditorInput).getFile();
        }
    }
}

