/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.util.AppearanceAwareLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.workingset.PHPWorkingSetPageContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class PHPWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = PHPUIMessages.getString("PHPWorkingSetPage_title");
    private static final String PAGE_ID = "phpWorkingSetPage";
    private Text fWorkingSetName;
    private CheckboxTreeViewer fTree;
    private ITreeContentProvider fTreeContentProvider;
    private boolean fFirstCheck;
    private IWorkingSet fWorkingSet;

    public PHPWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, PHPPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.setDescription(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_description"));
        this.fFirstCheck = true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite2);
        Label label = new Label(composite2, 64);
        label.setText(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_name"));
        GridData gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.fWorkingSetName = new Text(composite2, 2052);
        this.fWorkingSetName.setLayoutData((Object)new GridData(768));
        this.fWorkingSetName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPWorkingSetPage.this.validateInput();
            }
        });
        this.fWorkingSetName.setFocus();
        label = new Label(composite2, 64);
        label.setText(PHPUIMessages.getString("PHPWorkingSetPage_workingSet_content"));
        gridData = new GridData(772);
        label.setLayoutData((Object)gridData);
        this.fTree = new CheckboxTreeViewer(composite2, 2816);
        gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(15);
        this.fTree.getControl().setLayoutData((Object)gridData);
        this.fTreeContentProvider = new PHPWorkingSetPageContentProvider();
        this.fTree.setContentProvider((IContentProvider)this.fTreeContentProvider);
        AppearanceAwareLabelProvider appearanceAwareLabelProvider = new AppearanceAwareLabelProvider(1627389963, 3);
        this.fTree.setLabelProvider((IBaseLabelProvider)appearanceAwareLabelProvider);
        this.fTree.setSorter((ViewerSorter)new PHPElementSorter());
        this.fTree.setUseHashlookup(true);
        this.fTree.setInput((Object)PHPWorkspaceModelManager.getInstance());
        this.fTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                PHPWorkingSetPage.this.handleCheckStateChange(checkStateChangedEvent);
            }
        });
        this.fTree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                final Object object = treeExpansionEvent.getElement();
                if (!PHPWorkingSetPage.this.fTree.getGrayed(object)) {
                    BusyIndicator.showWhile((Display)PHPWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PHPWorkingSetPage.this.setSubtreeChecked(object, PHPWorkingSetPage.this.fTree.getChecked(object), false);
                        }
                    });
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(256));
        Button button = new Button(composite3, 8);
        button.setText(PHPUIMessages.getString("PHPWorkingSetPage_selectAll_label"));
        button.setToolTipText(PHPUIMessages.getString("PHPWorkingSetPage_selectAll_toolTip"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPWorkingSetPage.this.fTree.setCheckedElements(PHPWorkingSetPage.this.fTreeContentProvider.getElements(PHPWorkingSetPage.this.fTree.getInput()));
                PHPWorkingSetPage.this.validateInput();
            }
        });
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        Button button2 = new Button(composite3, 8);
        button2.setText(PHPUIMessages.getString("PHPWorkingSetPage_deselectAll_label"));
        button2.setToolTipText(PHPUIMessages.getString("PHPWorkingSetPage_deselectAll_toolTip"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPWorkingSetPage.this.fTree.setCheckedElements(new Object[0]);
                PHPWorkingSetPage.this.validateInput();
            }
        });
        button2.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button2);
        if (this.fWorkingSet != null) {
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
        }
        this.initializeCheckedState();
        this.validateInput();
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.ui.php_working_set_page_context");
    }

    public IWorkingSet getSelection() {
        return this.fWorkingSet;
    }

    public void setSelection(IWorkingSet iWorkingSet) {
        Assert.isNotNull((Object)iWorkingSet, (String)"Working set must not be null");
        this.fWorkingSet = iWorkingSet;
        if (this.getContainer() != null && this.getShell() != null && this.fWorkingSetName != null) {
            this.fFirstCheck = false;
            this.fWorkingSetName.setText(this.fWorkingSet.getName());
            this.initializeCheckedState();
            this.validateInput();
        }
    }

    public void finish() {
        String string = this.fWorkingSetName.getText();
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(10);
        this.findCheckedElements(arrayList, this.fTree.getInput());
        if (this.fWorkingSet == null) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.fWorkingSet = iWorkingSetManager.createWorkingSet(string, arrayList.toArray(new IAdaptable[arrayList.size()]));
        } else {
            IAdaptable[] iAdaptableArray = this.fWorkingSet.getElements();
            ArrayList<IProject> arrayList2 = new ArrayList<IProject>(arrayList.size());
            int n = 0;
            while (n < iAdaptableArray.length) {
                IProject iProject;
                IResource iResource = null;
                iResource = iAdaptableArray[n] instanceof IResource ? (IResource)iAdaptableArray[n] : (IResource)iAdaptableArray[n].getAdapter(IResource.class);
                if (iResource != null && !iResource.isAccessible() && (arrayList.contains(iProject = iResource.getProject()) || arrayList2.contains(iProject))) {
                    arrayList.add(iAdaptableArray[n]);
                    arrayList.remove(iProject);
                    arrayList2.add(iProject);
                }
                ++n;
            }
            this.fWorkingSet.setName(string);
            this.fWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    private void validateInput() {
        String string = null;
        String string2 = this.fWorkingSetName.getText();
        if (!string2.equals(string2.trim())) {
            string = PHPUIMessages.getString("PHPWorkingSetPage_warning_nameWhitespace");
        }
        if (string2.equals("")) {
            if (this.fFirstCheck) {
                this.setPageComplete(false);
                this.fFirstCheck = false;
                return;
            }
            string = PHPUIMessages.getString("PHPWorkingSetPage_warning_nameMustNotBeEmpty");
        }
        this.fFirstCheck = false;
        if (!(string != null || this.fWorkingSet != null && string2.equals(this.fWorkingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = 0;
            while (n < iWorkingSetArray.length) {
                if (string2.equals(iWorkingSetArray[n].getName())) {
                    string = PHPUIMessages.getString("PHPWorkingSetPage_warning_workingSetExists");
                }
                ++n;
            }
        }
        if (string == null && !this.hasCheckedElement()) {
            string = PHPUIMessages.getString("PHPWorkingSetPage_warning_resourceMustBeChecked");
        }
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    private boolean hasCheckedElement() {
        TreeItem[] treeItemArray = this.fTree.getTree().getItems();
        int n = 0;
        while (n < treeItemArray.length) {
            if (treeItemArray[n].getChecked()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void findCheckedElements(List list, Object object) {
        Object[] objectArray = this.fTreeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.fTree.getGrayed(objectArray[n])) {
                this.findCheckedElements(list, objectArray[n]);
            } else if (this.fTree.getChecked(objectArray[n])) {
                list.add(objectArray[n]);
            }
            ++n;
        }
    }

    void handleCheckStateChange(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable iAdaptable = (IAdaptable)checkStateChangedEvent.getElement();
                boolean bl = checkStateChangedEvent.getChecked();
                PHPWorkingSetPage.this.fTree.setGrayed((Object)iAdaptable, false);
                if (PHPWorkingSetPage.this.isExpandable(iAdaptable)) {
                    PHPWorkingSetPage.this.setSubtreeChecked(iAdaptable, bl, bl);
                }
                PHPWorkingSetPage.this.updateParentState(iAdaptable, bl);
                PHPWorkingSetPage.this.validateInput();
            }
        });
    }

    private void setSubtreeChecked(Object object, boolean bl, boolean bl2) {
        if (!(object instanceof IAdaptable)) {
            return;
        }
        IContainer iContainer = (IContainer)((IAdaptable)object).getAdapter(IContainer.class);
        if (!this.fTree.getExpandedState(object) && bl2 || iContainer != null && !iContainer.isAccessible()) {
            return;
        }
        Object[] objectArray = this.fTreeContentProvider.getChildren(object);
        int n = objectArray.length - 1;
        while (n >= 0) {
            Object object2 = objectArray[n];
            if (bl) {
                this.fTree.setChecked(object2, true);
                this.fTree.setGrayed(object2, false);
            } else {
                this.fTree.setGrayChecked(object2, false);
            }
            if (this.isExpandable(object2)) {
                this.setSubtreeChecked(object2, bl, true);
            }
            --n;
        }
    }

    private void updateParentState(Object object, boolean bl) {
        Object object2;
        if (object == null) {
            return;
        }
        if (object instanceof IAdaptable && (object2 = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null && !object2.isAccessible()) {
            return;
        }
        object2 = this.fTreeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        boolean bl2 = true;
        Object[] objectArray = null;
        objectArray = this.fTreeContentProvider.getChildren(object2);
        int n = objectArray.length - 1;
        while (n >= 0) {
            if (this.fTree.getChecked(objectArray[n]) != bl || this.fTree.getGrayed(objectArray[n])) {
                bl2 = false;
                break;
            }
            --n;
        }
        this.fTree.setGrayed(object2, !bl2);
        this.fTree.setChecked(object2, !bl2 || bl);
        this.updateParentState(object2, bl);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] objectArray;
                Object object;
                if (PHPWorkingSetPage.this.fWorkingSet == null) {
                    IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
                    if (iWorkbenchPage == null) {
                        return;
                    }
                    object = PHPUiPlugin.getActivePage().getActivePart();
                    if (object == null) {
                        return;
                    }
                    objectArray = SelectionConverter.getStructuredSelection(object).toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        PHPFileData pHPFileData;
                        if (objectArray[n] instanceof IFile && (pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile((IFile)objectArray[n], false)) != null) {
                            objectArray[n] = pHPFileData;
                        }
                        ++n;
                    }
                } else {
                    objectArray = PHPWorkingSetPage.this.fWorkingSet.getElements();
                }
                int n = 0;
                while (n < objectArray.length) {
                    IResource iResource;
                    IProject iProject;
                    object = objectArray[n];
                    if (object instanceof IResource && !(iProject = ((IResource)object).getProject()).isAccessible()) {
                        objectArray[n] = iProject;
                    }
                    if (object instanceof PHPCodeData && (iResource = PHPModelUtil.getResource((Object)object)) != null && !iResource.getProject().isAccessible()) {
                        objectArray[n] = iResource.getProject();
                    }
                    ++n;
                }
                PHPWorkingSetPage.this.fTree.setCheckedElements(objectArray);
                n = 0;
                while (n < objectArray.length) {
                    object = objectArray[n];
                    if (PHPWorkingSetPage.this.isExpandable(object)) {
                        PHPWorkingSetPage.this.setSubtreeChecked(object, true, true);
                    }
                    PHPWorkingSetPage.this.updateParentState(object, true);
                    ++n;
                }
            }
        });
    }

    private boolean isExpandable(Object object) {
        return object instanceof PHPWorkspaceModelManager || object instanceof IContainer;
    }
}

